---
generated_at: 2026-01-20 16:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-BigInteger

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Numerics/BigInteger.cls` 38-46行目（クラスドキュメント）
- E-02: `Source/CorLib/System.Numerics/BigInteger.cls` 48-50行目（Implements宣言）
- E-03: `Source/CorLib/System.Numerics/BigInteger.cls` 54-60行目（データ構造）
- E-04: `Source/CorLib/System.Numerics/BigInteger.cls` 337-347行目（Add）
- E-05: `Source/CorLib/System.Numerics/BigInteger.cls` 370-380行目（Subtract）
- E-06: `Source/CorLib/System.Numerics/BigInteger.cls` 403-419行目（Multiply）
- E-07: `Source/CorLib/System.Numerics/BigInteger.cls` 442-457行目（Divide）
- E-08: `Source/CorLib/System.Numerics/BigInteger.cls` 526-533行目（Modulus）
- E-09: `Source/CorLib/System.Numerics/BigInteger.cls` 699-772行目（ビット演算）
- E-10: `Source/CorLib/System.Numerics/BigInteger.cls` 557-692行目（ビット操作）
- E-11: `Source/CorLib/System.Numerics/BigInteger.cls` 893-920行目（Init）
- E-12: `Source/CorLib/System.Numerics/BigInteger.cls` 206-208行目（ToString）
- E-13: `Source/CorLib/System.Numerics/BigInteger.cls` 137-185行目（ToByteArray）
- E-14: `Source/CorLib/System.Numerics/BigInteger.cls` 67-69行目（Sign）
- E-15: `Source/CorLib/System.Numerics/BigInteger.cls` 75-77行目（IsZero）
- E-16: `Source/CorLib/System.Numerics/BigInteger.cls` 83-87行目（IsOne）
- E-17: `Source/CorLib/System.Numerics/BigInteger.cls` 97-103行目（IsEven）
- E-18: `docs/code-to-docs/機能一覧/機能一覧.csv` 84行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 任意精度の符号付き整数演算を提供 | E-01 (クラスドキュメント) | ○ |
| C-02 | 2の補数表現で負数を表す | E-01 (42-43行目ドキュメント) | ○ |
| C-03 | 内部表現はInteger配列 | E-01 (44-45行目), E-03 | ○ |
| C-04 | IObject, IComparable, IFormattable実装 | E-02 | ○ |
| C-05 | Add演算でゼロチェック後AddTo呼び出し | E-04 | ○ |
| C-06 | Subtract演算でゼロチェック後SubtractFrom呼び出し | E-05 | ○ |
| C-07 | Multiply演算でゼロ/1チェック後MultiplyBy呼び出し | E-06 | ○ |
| C-08 | Divide演算でゼロ除算チェック後DivideInto呼び出し | E-07 | ○ |
| C-09 | Modulus演算でゼロ除算チェック後ModulusOf呼び出し | E-08 | ○ |
| C-10 | ビット演算（AND, OR, XOR, NOT）をサポート | E-09 | ○ |
| C-11 | TestBit, SetBit, ClearBit, FlipBitをサポート | E-10 | ○ |
| C-12 | Long, Double, Currency, Decimal, Byte配列, Int64から初期化可能 | E-11 | ○ |
| C-13 | ToStringでNumberFormatter.FormatBigNumber呼び出し | E-12 | ○ |
| C-14 | ToByteArrayでバイト配列を返す | E-13 | ○ |
| C-15 | Signプロパティで符号取得 | E-14 | ○ |
| C-16 | IsZeroプロパティでゼロ判定 | E-15 | ○ |
| C-17 | IsOneプロパティで1判定 | E-16 | ○ |
| C-18 | IsEvenプロパティで偶数判定 | E-17 | ○ |
| C-19 | 機能種別は「任意精度整数演算」 | E-18 | ○ |
| C-20 | NothingはZeroとして扱う | E-04 (ValueOrZero呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] データ構造（BigNumber型）がソースコードと一致している
- [x] 四則演算のメソッド行番号が正確である
- [x] ビット演算のメソッド行番号が正確である
- [x] 初期化処理でサポートされる型が正確である
- [x] プログラム呼び出し階層図が実装と一致している
