---
generated_at: 2026-01-20 16:32:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-ResourceWriter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Resources/ResourceWriter.cls` 38-40行目（クラスドキュメント）
- E-02: `Source/CorLib/System.Resources/ResourceWriter.cls` 45-47行目（メンバ変数）
- E-03: `Source/CorLib/System.Resources/ResourceWriter.cls` 58-69行目（AddEncoder）
- E-04: `Source/CorLib/System.Resources/ResourceWriter.cls` 79-82行目（AddResource）
- E-05: `Source/CorLib/System.Resources/ResourceWriter.cls` 87-91行目（Generate）
- E-06: `Source/CorLib/System.Resources/ResourceWriter.cls` 146-154行目（Class_Initialize）
- E-07: `Source/CorLib/System.Resources/ResourceWriter.cls` 190-198行目（WriteResources）
- E-08: `Source/CorLib/System.Resources/ResourceWriter.cls` 200-202行目（WriteBlankHeader）
- E-09: `Source/CorLib/System.Resources/ResourceWriter.cls` 216-271行目（WriteResource）
- E-10: `Source/CorLib/System.Resources/ResourceWriter.cls` 273-277行目（ComputeDWordAlignedOffset）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 87行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .RES形式のリソースファイルを作成する | E-01 (クラスドキュメント) | ○ |
| C-02 | mWriter, mEncoders, mGeneratedがメンバ変数 | E-02 | ○ |
| C-03 | AddEncoderでエンコーダーを先頭に挿入 | E-03 (68行目 Insert 0) | ○ |
| C-04 | AddResourceでリソース追加 | E-04 | ○ |
| C-05 | GenerateでNotGenerated検証後WriteResources | E-05 | ○ |
| C-06 | 標準エンコーダー7種類を登録 | E-06 | ○ |
| C-07 | WriteResourcesで空ヘッダーと各リソース書き込み | E-07 | ○ |
| C-08 | 空ヘッダーは32バイト | E-08 | ○ |
| C-09 | メモリフラグにMOVEABLE, PURE, DISCARDABLE設定 | E-09 (217-220行目) | ○ |
| C-10 | DWordアライメント計算式 | E-10 | ○ |
| C-11 | IResourceWriterインターフェース実装 | E-01 (Implements IResourceWriter) | ○ |
| C-12 | Generate後はAddResourceできない | E-04 (VerifyNotGenerated呼び出し) | ○ |
| C-13 | CloseWriterで未生成の場合はGenerate呼び出し | E-01 (96-105行目) | ○ |
| C-14 | 機能種別は「リソースファイル書き込み」 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] メンバ変数がソースコードと一致している
- [x] 標準エンコーダー7種類が正確に記載されている
- [x] 空ヘッダーのバイト数（32）が正確である
- [x] DWordアライメント計算式が正確である
- [x] プログラム呼び出し階層図が実装と一致している
