---
generated_at: 2026-01-20 16:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-Registry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/Microsoft.Win32/Registry.cls` 38-50行目（クラスドキュメント）
- E-02: `Source/CorLib/Microsoft.Win32/Registry.cls` 53-58行目（メンバ変数）
- E-03: `Source/CorLib/Microsoft.Win32/Registry.cls` 69-71行目（ClassesRoot）
- E-04: `Source/CorLib/Microsoft.Win32/Registry.cls` 78-80行目（CurrentConfig）
- E-05: `Source/CorLib/Microsoft.Win32/Registry.cls` 87-89行目（CurrentUser）
- E-06: `Source/CorLib/Microsoft.Win32/Registry.cls` 95-97行目（LocalMachine）
- E-07: `Source/CorLib/Microsoft.Win32/Registry.cls` 103-105行目（PerformanceData）
- E-08: `Source/CorLib/Microsoft.Win32/Registry.cls` 111-113行目（Users）
- E-09: `Source/CorLib/Microsoft.Win32/Registry.cls` 127-132行目（GetValue）
- E-10: `Source/CorLib/Microsoft.Win32/Registry.cls` 145-150行目（SetValue）
- E-11: `Source/CorLib/Microsoft.Win32/Registry.cls` 156-173行目（GetRootKey）
- E-12: `Source/CorLib/Microsoft.Win32/Registry.cls` 175-192行目（GetSubKey）
- E-13: `Source/CorLib/Microsoft.Win32/Registry.cls` 198-205行目（Class_Initialize）
- E-14: `Source/CorLib/Microsoft.Win32/RegistryKey.cls` 104-112行目（RegistryValueKind列挙）
- E-15: `Source/CorLib/Microsoft.Win32/RegistryKey.cls` 119-121行目（RegistryKeyメンバ変数）
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 90行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windowsレジストリへのアクセスを提供 | E-01 (クラスドキュメント) | ○ |
| C-02 | 6つのルートキー用メンバ変数を持つ | E-02 | ○ |
| C-03 | ClassesRootはHKEY_CLASSES_ROOT | E-03, E-13 | ○ |
| C-04 | CurrentConfigはHKEY_CURRENT_CONFIG | E-04, E-13 | ○ |
| C-05 | CurrentUserはHKEY_CURRENT_USER | E-05, E-13 | ○ |
| C-06 | LocalMachineはHKEY_LOCAL_MACHINE | E-06, E-13 | ○ |
| C-07 | PerformanceDataはHKEY_PERFORMANCE_DATA | E-07, E-13 | ○ |
| C-08 | UsersはHKEY_USERS | E-08, E-13 | ○ |
| C-09 | GetValueでサブキーを開いて値を取得 | E-09 | ○ |
| C-10 | SetValueでサブキーを作成/開いて値を設定 | E-10 | ○ |
| C-11 | GetRootKeyで文字列からルートキーを取得 | E-11 | ○ |
| C-12 | 無効なルートキー名でArgument例外 | E-11 (171行目) | ○ |
| C-13 | GetSubKeyでWritable=TrueならCreateSubKey | E-12 (187-188行目) | ○ |
| C-14 | GetSubKeyでWritable=FalseならOpenSubKey | E-12 (189-190行目) | ○ |
| C-15 | REG_DWORD, REG_QWORD, REG_SZ等をサポート | E-14 | ○ |
| C-16 | 機能種別は「レジストリアクセス」 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 6つのルートキープロパティがソースコードと一致している
- [x] GetRootKeyのSelect Case文が正確である
- [x] GetSubKeyのWritableフラグによる分岐が正確である
- [x] Class_Initializeでの初期化が正確である
- [x] プログラム呼び出し階層図が実装と一致している
- [x] RegistryValueKind列挙値が正確である
