---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：91-RegistryKey

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：実測データなし
  2. **セキュリティ考慮事項**：一般的な知識に基づく記述
  3. **Windows 95/98/MEでの動作**：テスト環境なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/Microsoft.Win32/RegistryKey.cls`
- E-02: `Source/CorLib/Microsoft.Win32/RegistryKeyStatic.cls`
- E-03: `Source/Tests/Microsoft.Win32/RegistryKeyTests.cls`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RegistryKeyはレジストリキーレベルノードを表現する | E-01: 38-84行目コメント | ○ |
| C-02 | RegistryValueKind列挙体で値の型を定義 | E-01: 104-112行目 | ○ |
| C-03 | OpenSubKeyでサブキーを開く | E-01: 144-155行目 | ○ |
| C-04 | CreateSubKeyで新しいノードを作成 | E-01: 191-203行目 | ○ |
| C-05 | DeleteSubKeyでキーを削除 | E-01: 215-230行目 | ○ |
| C-06 | DeleteSubKeyTreeで再帰的に削除 | E-01: 238-260行目 | ○ |
| C-07 | GetValueで値を取得 | E-01: 402-476行目 | ○ |
| C-08 | SetValueで値を設定 | E-01: 352-380行目 | ○ |
| C-09 | DeleteValueで値を削除 | E-01: 484-491行目 | ○ |
| C-10 | GetSubKeyNamesでサブキー名を取得 | E-01: 269-290行目 | ○ |
| C-11 | GetValueNamesで値名を取得 | E-01: 304-325行目 | ○ |
| C-12 | GetValueKindで値の型を取得 | E-01: 519-522行目 | ○ |
| C-13 | キー長制限は255文字 | E-01: 89行目、598-608行目 | ○ |
| C-14 | 値名長制限は16383文字 | E-01: 90行目、356行目、405行目 | ○ |
| C-15 | Writableで書き込み権限を制御 | E-01: 621-625行目 | ○ |
| C-16 | システムキーはCloseKeyで閉じない | E-01: 611-613行目 | ○ |
| C-17 | Flushでディスクへ書き込み強制 | E-01: 179-182行目 | ○ |
| C-18 | GetLastWriteTimeで最終書き込み時刻取得 | E-01: 530-540行目 | ○ |
| C-19 | Windows 95/98/MEではMinValueを返す | E-01: 533行目、538行目 | ○ |
| C-20 | RegistryHive列挙体でルートキーを定義 | E-02: 64-71行目 | ○ |
| C-21 | OpenRemoteBaseKeyでリモート接続 | E-02: 84-94行目 | ○ |
| C-22 | 関連画面にSimply VB Unit Runnerがある | E-05: 43行目 | ○ |
| C-23 | 関連画面にSimple Registry Browserがある | E-05: 78-82行目 | ○ |
| C-24 | テストでRoundTrip検証を実施 | E-03: 301-310行目 | ○ |
| C-25 | パフォーマンス要件（数ミリ秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件：実測データがないため、一般的な知識に基づく記述
  - 候補：Windows API公式ドキュメント / パフォーマンステスト結果 / ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能説明、API仕様（コードから直接確認可能）
- 1: 中リスク - セキュリティ考慮事項（一般的な知識に基づく）
- 1: 中リスク - パフォーマンス要件（実測データなし）

## 6) レビュアーチェックリスト（最小）
- [ ] RegistryValueKind列挙体の値が正確か確認
- [ ] OpenSubKey/CreateSubKeyの戻り値の挙動を確認
- [ ] エラーケースの網羅性を確認
- [ ] セキュリティ考慮事項が組織のセキュリティポリシーに適合するか確認
