---
generated_at: 2026-01-20 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：93-Ticker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Threading/Ticker.cls`
- E-02: `Source/CorLib/System.Threading/TickerShared.bas`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tickerは繰り返しタイマーイベントを提供 | E-01: 39-41行目コメント | ○ |
| C-02 | イベント方式とコールバック方式をサポート | E-01: 78行目（Event）、264行目（Callback） | ○ |
| C-03 | StartTickerでタイマーを開始 | E-01: 209-215行目 | ○ |
| C-04 | StopTickerでタイマーを停止 | E-01: 220-224行目 | ○ |
| C-05 | Elapsedイベントが発生 | E-01: 78行目、260行目 | ○ |
| C-06 | AutoResetで繰り返し/単発を制御 | E-01: 143-145行目、256-258行目 | ○ |
| C-07 | Intervalに負の値を設定するとArgumentOutOfRangeException | E-01: 114-115行目 | ○ |
| C-08 | SetTimer APIを使用 | E-02: 40行目 | ○ |
| C-09 | KillTimer APIを使用 | E-02: 53行目 | ○ |
| C-10 | WeakReferenceでTickerを保持 | E-02: 44行目 | ○ |
| C-11 | TickerCallbackがWM_TIMERを処理 | E-02: 58-89行目 | ○ |
| C-12 | デフォルトAutoResetはTrue | E-01: 143行目 | ○ |
| C-13 | タイマー実行中にInterval変更で自動リスタート | E-01: 119-122行目 | ○ |
| C-14 | Class_TerminateでStopTickerが呼ばれる | E-01: 249-251行目 | ○ |
| C-15 | 関連画面にSimple Ticker (Event版)がある | E-04: 48-49行目 | ○ |
| C-16 | 関連画面にSimple Ticker 2 (Callback版)がある | E-04: 58-59行目 | ○ |
| C-17 | Dataプロパティでユーザー定義データを保持 | E-01: 171-173行目 | ○ |
| C-18 | Enabledプロパティでタイマー状態を取得 | E-01: 131-133行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SetTimer/KillTimerのエラーハンドリングが適切か確認
- [ ] WeakReferenceの解放タイミングが適切か確認
- [ ] コールバック関数のシグネチャが正しいか確認
- [ ] タイマー精度の記述がWindowsの仕様と一致するか確認
