---
generated_at: 2026-01-20 17:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-MemoryMappedFile

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedFile.cls`
- E-02: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedFileStatic.cls`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryMappedFileはメモリマップトファイルを表す | E-01: 38-39行目コメント | ○ |
| C-02 | CreateFromFileでファイルからマップ作成 | E-02: 67-110行目 | ○ |
| C-03 | CreateNewで新規マップ作成 | E-02: 131-157行目 | ○ |
| C-04 | OpenExistingで既存マップをオープン | E-02: 173-192行目 | ○ |
| C-05 | CreateViewAccessorでアクセサ作成 | E-01: 63-75行目 | ○ |
| C-06 | CreateViewStreamでストリーム作成 | E-01: 87-99行目 | ○ |
| C-07 | CreateFile APIを使用 | E-02: 82行目 | ○ |
| C-08 | CreateFileMapping APIを使用 | E-02: 89行目、149行目 | ○ |
| C-09 | OpenFileMapping APIを使用 | E-02: 185行目 | ○ |
| C-10 | SafeMemoryMappedFileHandleでハンドル管理 | E-01: 48行目 | ○ |
| C-11 | SafeFileHandleでファイルハンドル管理 | E-01: 47行目 | ○ |
| C-12 | Capacityは0より大きい必要がある | E-02: 138-139行目 | ○ |
| C-13 | MapNameが空文字でArgumentException | E-02: 135-136行目 | ○ |
| C-14 | Disposeでリソース解放 | E-01: 110-119行目 | ○ |
| C-15 | Currency型で64ビットサイズをサポート | E-01: 63行目（Offset As Currency） | ○ |
| C-16 | ページ境界調整を実施 | E-02: コメント参照 | ○ |
| C-17 | アクセス権をMemoryMappedFileAccessで制御 | E-02: 71行目、133行目、175行目 | ○ |
| C-18 | 機能一覧でメモリマップトファイルとして定義 | E-03: 96行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CreateFile/CreateFileMappingのエラーハンドリングが適切か確認
- [ ] ページ境界調整ロジックが正確か確認
- [ ] Disposeでファイルハンドルとマッピングハンドルの両方が解放されるか確認
- [ ] アクセス権の継承ルールが適切か確認
