---
generated_at: 2026-01-20 17:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：96-MemoryMappedViewAccessor

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO.MemoryMappedFiles/MemoryMappedViewAccessor.cls`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryMappedViewAccessorはランダムアクセスビューを提供 | E-01: 39行目コメント | ○ |
| C-02 | ReadByteで1バイト読み取り | E-01: 109-115行目 | ○ |
| C-03 | ReadBooleanでブール値読み取り | E-01: 138-143行目 | ○ |
| C-04 | ReadInt16で16ビット整数読み取り | E-01: 196-202行目 | ○ |
| C-05 | ReadInt32で32ビット整数読み取り | E-01: 225-231行目 | ○ |
| C-06 | ReadInt64で64ビット整数読み取り | E-01: 254-260行目 | ○ |
| C-07 | ReadCurrencyで通貨型読み取り | E-01: 319-325行目 | ○ |
| C-08 | ReadDateで日付読み取り（Ticks形式） | E-01: 288-293行目 | ○ |
| C-09 | WriteValueで値書き込み | E-01: 605-643行目 | ○ |
| C-10 | WriteArrayで配列書き込み | E-01: 690-726行目 | ○ |
| C-11 | Readで構造体読み取り | E-01: 440-468行目 | ○ |
| C-12 | CanReadで読み取り権限チェック | E-01: 68-70行目 | ○ |
| C-13 | CanWriteで書き込み権限チェック | E-01: 60-62行目 | ○ |
| C-14 | Capacityでビュー容量を取得 | E-01: 76-78行目 | ○ |
| C-15 | GetSafeIndexで位置検証 | E-01: 915-931行目 | ○ |
| C-16 | MapViewOfFileでビューをマップ | E-01: 833-834行目 | ○ |
| C-17 | FlushViewOfFileでディスク書き込み | E-01: 772-776行目 | ○ |
| C-18 | UnmapViewOfFileでビュー解除 | E-01: 883-885行目 | ○ |
| C-19 | Boolean は1バイトで0または1 | E-01: 612-613行目（WriteValue内） | ○ |
| C-20 | 機能一覧でメモリマップトファイルビューアクセサとして定義 | E-02: 97行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 位置検証（GetSafeIndex）のロジックが正確か確認
- [ ] Boolean/Dateの型変換が.NET互換か確認
- [ ] 構造体読み書きのValidateStructureが適切か確認
- [ ] CopyMemoryの使用が安全か確認
