---
generated_at: 2026-01-20 17:52:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-Exception

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Exception.cls`
- E-02: `Source/CorLib/System/ExceptionBase.cls`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Exceptionはすべての例外クラスの基底クラス | E-01: 38-85行目コメント | ○ |
| C-02 | mBaseがExceptionBaseへの参照を保持 | E-01: 94行目 | ○ |
| C-03 | HResultはCOR_E_EXCEPTIONを返却 | E-01: 137-139行目 | ○ |
| C-04 | ErrorNumberのデフォルトはvbInvalidProcedureCall | E-01: 257行目 | ○ |
| C-05 | MessageはGetExceptionMessageで取得 | E-01: 184-186行目 | ○ |
| C-06 | InnerExceptionでチェーン可能 | E-01: 196-198行目 | ○ |
| C-07 | GetBaseExceptionで最も内側の例外を取得 | E-01: 213-215行目、E-02: 289-295行目 | ○ |
| C-08 | DataでIDictionaryを返却 | E-01: 102-104行目 | ○ |
| C-09 | ToStringで文字列表現を生成 | E-01: 225-227行目 | ○ |
| C-10 | ExceptionBaseがプロパティ値を保持 | E-02: 60-69行目 | ○ |
| C-11 | Persistable属性でシリアライズ可能 | E-01: 4行目 | ○ |
| C-12 | Class_ReadPropertiesでデシリアライズ | E-01: 270-272行目 | ○ |
| C-13 | Class_WritePropertiesでシリアライズ | E-01: 274-276行目 | ○ |
| C-14 | IObjectインターフェースを実装 | E-01: 88行目 | ○ |
| C-15 | 機能一覧で例外基底クラスとして定義 | E-03: 99行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExceptionBaseへの委譲が正しく実装されているか確認
- [ ] GetBaseExceptionの再帰ロジックが正しいか確認
- [ ] シリアライズ/デシリアライズが正しく動作するか確認
