---
generated_at: 2026-01-20 17:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：99-ArgumentException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentException.cls`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArgumentExceptionは無効な引数の例外 | E-01: 38-48行目コメント | ○ |
| C-02 | Implements IObject, Exception, SystemException | E-01: 57-59行目 | ○ |
| C-03 | ParamNameでmBase.GetValueを使用 | E-01: 84-86行目 | ○ |
| C-04 | PropParamName定数 = "ParamName" | E-01: 61行目 | ○ |
| C-05 | HResultはCOR_E_ARGUMENT | E-01: 118-120行目 | ○ |
| C-06 | ErrorNumberはvbInvalidProcedureCall | E-01: 126-128行目 | ○ |
| C-07 | MessageにParamNameを追加 | E-01: 167-171行目 | ○ |
| C-08 | GetExceptionMessageで基本メッセージ取得 | E-01: 165行目 | ○ |
| C-09 | Arg_ArgumentExceptionリソースを使用 | E-01: 165行目 | ○ |
| C-10 | Class_InitPropertiesでExceptionBase生成 | E-01: 241-243行目 | ○ |
| C-11 | InitでMessage、ParamName、InnerException設定 | E-01: 245-249行目 | ○ |
| C-12 | Exception_*でインターフェース実装 | E-01: 282-333行目 | ○ |
| C-13 | SystemException_*でインターフェース実装 | E-01: 336-389行目 | ○ |
| C-14 | 機能一覧で引数例外として定義 | E-02: 100行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての機能説明がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ParamNameの追加形式が正しいか確認（"Parameter name: "）
- [ ] GetExceptionMessageの動作が正しいか確認
- [ ] Exception/SystemExceptionインターフェースの完全実装を確認
