---
generated_at: 2026-01-20 15:41:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Tests/frmSimplyVBUnitRunner.frm` - ユニットテストランナー画面
- E-02: `Examples/Misc/StaticClasses/Form1.frm` - 静的クラスデモ画面
- E-03: `Examples/Misc/SimpleTicker/Form1.frm` - Tickerイベント版画面
- E-04: `Examples/Misc/Base64 Encoding/Form1.frm` - Base64エンコード画面
- E-05: `Examples/Misc/SimpleTicker2/Form1.frm` - Tickerコールバック版画面
- E-06: `Examples/Cryptography/RealTimeDecryption/Form1.frm` - リアルタイム復号画面
- E-07: `Examples/Cryptography/FileEncryption/Form1.frm` - ファイル暗号化画面
- E-08: `Examples/Cryptography/HashCodes/Form1.frm` - ハッシュコード画面
- E-09: `Examples/Registry/SimpleRegistryBrowser/Form1.frm` - レジストリブラウザ画面
- E-10: `Examples/IO Examples/ResourceBrowser/Form1.frm` - リソースブラウザ画面
- E-11: `Examples/IO Examples/SimpleINIFileBrowser/Form1.frm` - INIファイルブラウザ画面
- E-12: `Examples/IO Examples/SimpleBrowser2/Form1.frm` - ファイルブラウザ（コールバック版）画面
- E-13: `Examples/IO Examples/FileHexViewer/Form1.frm` - HEXビューア画面
- E-14: `Examples/IO Examples/SimpleBrowser/Form1.frm` - ファイルブラウザ（IComparer版）画面
- E-15: `Examples/NumberFormatting/Format Integer/Form1.frm` - 数値フォーマット画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Simply VB Unit Runnerはテストスイート実行画面 | E-01: Caption="Simply VB Unit"、Form_Load内でテストスイート追加、F5でUIRunner1.Run実行 | ○ |
| C-02 | Static Classes Demoは各種静的クラス機能のデモ | E-02: Caption="Some Available Functions"、Path/Environment/MathExt/TimeZoneのデモコード | ○ |
| C-03 | Simple Tickerはイベント通知デモ | E-03: Private WithEvents mTicker As Ticker宣言、mTicker_Elapsedイベントハンドラ | ○ |
| C-04 | Base64 EncodingはBase64エンコード/デコード画面 | E-04: cmdEncode_Click/cmdDecode_Click、Convert.ToBase64String/FromBase64String使用 | ○ |
| C-05 | Simple Ticker 2はコールバック通知デモ | E-05: コメント"callback method"、AddressOf TickerCallback使用 | ○ |
| C-06 | Real-Time Decryptionはリアルタイム復号デモ | E-06: CryptoStream使用、RijndaelManaged、StreamReaderで行単位読み込み | ○ |
| C-07 | File Encryptionはファイル暗号化/復号画面 | E-07: cmdEncrypt_Click/cmdDecrypt_Click、SymmetricAlgorithm使用、複数アルゴリズム対応 | ○ |
| C-08 | Hash Codesは各種ハッシュアルゴリズムデモ | E-08: SHA1/SHA256/SHA384/SHA512/MD5/RIPEMD160の各インスタンス、ComputeHash呼び出し | ○ |
| C-09 | Simple Registry Browserはレジストリ閲覧画面 | E-09: Caption="Simple Registry Browser"、TreeView/ListView、Registry.ClassesRoot等使用 | ○ |
| C-10 | Resource Browserはリソースファイル閲覧画面 | E-10: Caption="Resource File Browser"、mnuFileOpenRes/mnuFileOpenEXE、IResourceReader使用 | ○ |
| C-11 | Simple INI File BrowserはINIファイル閲覧画面 | E-11: Caption="Simple INI File Browser"、INIFileクラス使用、GetSectionNames/GetValues | ○ |
| C-12 | Simple Browser 2はコールバックソート版ブラウザ | E-12: Caption含"Callback method"、CorArray.Sort Files, AddressOf FileInfoComparer | ○ |
| C-13 | File Hex ViewerはHEXダンプ表示画面 | E-13: Caption="Virtually Mapped File Hex Viewer"、MemoryMappedFile使用、16進表示処理 | ○ |
| C-14 | Simple BrowserはIComparer版ブラウザ | E-14: Caption含"Custom IComparer"、CorArray.Sort Files, mSortComparer | ○ |
| C-15 | Number Formattingは数値フォーマットデモ | E-15: Caption="Some Formatted Numbers"、CorString.Format各種パターン（G/D/E/F/C/N/X） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全画面の.frmファイルを直接確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面名がCaptionプロパティと整合しているか確認
- [ ] 各画面の説明がコード内コメントおよび実装と一致しているか確認
- [ ] 使用OCXファイルが備考欄に正しく記載されているか確認
- [ ] カテゴリ分類がプロジェクトディレクトリ構造と一致しているか確認
