# VBCorLib 画面遷移図

## 概要

VBCorLibプロジェクトは主にライブラリであり、画面間の遷移は存在しません。
各画面（フォーム）は独立したサンプルアプリケーションまたはテストランナーとして動作します。

## 画面構成

```mermaid
graph TB
    subgraph テスト
        A[Simply VB Unit Runner<br/>frmSimplyVBUnitRunner]
    end

    subgraph サンプル/その他
        B1[Static Classes Demo<br/>Form1]
        B2[Simple Ticker Event版<br/>Form1]
        B3[Base64 Encoding<br/>Form1]
        B4[Simple Ticker 2 Callback版<br/>Form1]
    end

    subgraph サンプル/暗号化
        C1[Real-Time Decryption<br/>Form1]
        C2[File Encryption<br/>Form1]
        C3[Hash Codes<br/>Form1]
    end

    subgraph サンプル/レジストリ
        D1[Simple Registry Browser<br/>Form1]
    end

    subgraph サンプル/IO
        E1[Resource Browser<br/>Form1]
        E2[Simple INI File Browser<br/>Form1]
        E3[Simple Browser 2<br/>Form1]
        E4[File Hex Viewer<br/>Form1]
        E5[Simple Browser<br/>Form1]
    end

    subgraph サンプル/数値フォーマット
        F1[Number Formatting<br/>Form1]
    end
```

## 画面内操作フロー

### Simply VB Unit Runner

```mermaid
graph LR
    A[フォーム起動] --> B[テストスイート読み込み]
    B --> C{ユーザー操作}
    C -->|F5キー| D[テスト実行]
    C -->|ESCキー| E[終了]
    D --> C
```

### File Encryption

```mermaid
graph LR
    A[フォーム起動] --> B[アルゴリズム選択]
    B --> C[入力ファイル選択]
    C --> D[出力ファイル指定]
    D --> E{操作選択}
    E -->|暗号化| F[ファイル暗号化処理]
    E -->|復号| G[ファイル復号処理]
    F --> H[完了]
    G --> H
```

### Simple Registry Browser

```mermaid
graph LR
    A[フォーム起動] --> B[ルートキー表示]
    B --> C{ノードクリック}
    C --> D[サブキー展開]
    D --> E[値一覧表示]
    E --> C
```

### File System Browser (Simple Browser / Simple Browser 2)

```mermaid
graph LR
    A[フォーム起動] --> B[ドライブ一覧表示]
    B --> C{ノードクリック}
    C --> D[サブディレクトリ展開]
    D --> E[ファイル一覧表示]
    E --> F{列ヘッダクリック}
    F --> G[ソート実行]
    G --> E
    E --> C
```

### Base64 Encoding

```mermaid
graph LR
    A[フォーム起動] --> B[入力ファイル選択]
    B --> C{操作選択}
    C -->|エンコード| D[Base64エンコード]
    D --> E[結果表示]
    C -->|デコード| F[出力ファイル選択]
    F --> G[Base64デコード]
    G --> H[ファイル出力]
```

## 備考

- 各画面は独立したVBプロジェクト（.vbp）として構成されています
- 画面間での直接的な遷移や連携は存在しません
- 共通ライブラリ（VBCorLib）の機能をデモンストレーションすることが目的です
