---
generated_at: 2026-01-20 21:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **IT-015 ArrayList-Comparer連携**：テストファイルは存在するが直接確認未実施
  2. **IT-016 Hashtable-StringComparer連携**：テストファイルは存在するが直接確認未実施
  3. **IT-025 StringBuilder-Encoding連携**：テストファイルは存在するが直接確認未実施
  4. **IT-028 IniFile-Stream連携**：テストファイルは存在するが直接確認未実施
  5. **IT-035 Version-Compare連携**：テストファイルは存在するが直接確認未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Tests/System.IO/StreamWriterTests.cls`
- E-02: `Source/Tests/System.IO/StreamReaderTests.cls`
- E-03: `Source/Tests/System.IO/FileStreamTests.cls`
- E-04: `Source/Tests/System.IO/BinaryReaderTests.cls`
- E-05: `Source/Tests/System.IO/BinaryWriterTests.cls`
- E-06: `Source/Tests/System.IO/MemoryStreamTests.cls`
- E-07: `Source/Tests/System.Security.Cryptography/CryptoStreamTests.cls`
- E-08: `Source/Tests/System.Text/UTF8EncodingTests.cls`
- E-09: `Source/Tests/System.Resources/ResourceManagerTests.cls`
- E-10: `Source/Tests/System.IO/DirectoryTests.cls`
- E-11: `Source/Tests/System.IO/DirectoryInfoTests.cls`
- E-12: `Source/Tests/System.IO/FileTests.cls`
- E-13: `Source/Tests/System.IO/FileInfoTests.cls`
- E-14: `Source/Tests/System.IO/IniFileTests.cls`
- E-15: `Source/Tests/System.IO/PathTests.cls`
- E-16: `Source/Tests/System.Collections/ArrayListTests.cls`
- E-17: `Source/Tests/System.Collections/HashtableTests.cls`
- E-18: `Source/Tests/System.Security.Cryptography/TripleDESEncryptionTests.cls`
- E-19: `Source/Tests/System.Security.Cryptography/RijndaelTests.cls`
- E-20: `Source/Tests/System.Security.Cryptography/SHA256ManagedTests.cls`
- E-21: `Source/Tests/System.Security.Cryptography/RSACryptoServiceProviderTests.cls`
- E-22: `Source/Tests/System.Security.Cryptography/HMACSHA256Tests.cls`
- E-23: `Source/Tests/System.Text/StringBuilderTests.cls`
- E-24: `Source/Tests/System.Globalization/JapaneseCalendarTests.cls`
- E-25: `Source/Tests/System.Globalization/CultureInfoTests.cls`
- E-26: `Source/Tests/System.Numerics/BigIntegerTests.cls`
- E-27: `Source/Tests/System.IO.MemoryMappedFiles/MemoryMappedFileTests.cls`
- E-28: `Source/Tests/System.IO.MemoryMappedFiles/MemoryMappedViewStreamTests.cls`
- E-29: `Source/Tests/System/ArgumentExceptionTests.cls`
- E-30: `Source/Tests/System/GuidTests.cls`
- E-31: `Source/Tests/System/VersionTests.cls`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: StreamWriterからFileStreamへの書き込み | E-01 | ○ |
| C-02 | IT-002: StreamReaderからFileStreamの読み込み | E-02 | ○ |
| C-03 | IT-003: StreamWriterからMemoryStreamへの書き込み | E-01 | ○ |
| C-04 | IT-004: StreamReaderからMemoryStreamの読み込み | E-02 | ○ |
| C-05 | IT-005: BinaryReaderによるMemoryStreamからのバイナリ読み込み | E-04 | ○ |
| C-06 | IT-006: BinaryWriterによるMemoryStreamへのバイナリ書き込み | E-05 | ○ |
| C-07 | IT-007: CryptoStreamによる暗号化書き込み | E-07 | ○ |
| C-08 | IT-008: CryptoStreamによる復号化読み込み | E-07 | ○ |
| C-09 | IT-009: UTF8EncodingによるStream経由のエンコード/デコード | E-08 | ○ |
| C-10 | IT-010: StreamReaderでのエンコーディング自動検出 | E-02 | ○ |
| C-11 | IT-011: StreamWriterでのBOM出力 | E-01 | ○ |
| C-12 | IT-012: ResourceManagerによるリソース読み込み | E-09 | ○ |
| C-13 | IT-013: ResourceManagerでのカルチャ別リソース取得 | E-09 | ○ |
| C-14 | IT-014: Pathユーティリティを使用したFileStream操作 | E-03, E-15 | ○ |
| C-15 | IT-015: ArrayListでのComparerを使用したソート | E-16 | △ |
| C-16 | IT-016: Hashtableでの大文字小文字無視検索 | E-17 | △ |
| C-17 | IT-017: IOHelperを使用したFileStream操作 | E-03 | ○ |
| C-18 | IT-018: TripleDES暗号化アルゴリズムとCryptoStreamの連携 | E-18 | ○ |
| C-19 | IT-019: Rijndael暗号化アルゴリズムとCryptoStreamの連携 | E-19 | ○ |
| C-20 | IT-020: SHA256ハッシュアルゴリズムとStreamの連携 | E-20 | ○ |
| C-21 | IT-021: RSA暗号化とバイト配列エンコーディングの連携 | E-21 | ○ |
| C-22 | IT-022: HMACとStreamの連携によるメッセージ認証 | E-22 | ○ |
| C-23 | IT-023: DecoderとFallbackの連携 | E-08 | ○ |
| C-24 | IT-024: EncoderとFallbackの連携 | E-08 | ○ |
| C-25 | IT-025: StringBuilderとEncodingの連携 | E-23 | △ |
| C-26 | IT-026: DirectoryクラスとDirectoryInfoクラスの連携 | E-10, E-11 | ○ |
| C-27 | IT-027: FileクラスとFileInfoクラスの連携 | E-12, E-13 | ○ |
| C-28 | IT-028: IniFileとStreamの連携 | E-14 | △ |
| C-29 | IT-029: CalendarとCultureInfoの連携 | E-24, E-25 | ○ |
| C-30 | IT-030: BigIntegerと変換機能の連携 | E-26 | ○ |
| C-31 | IT-031: MemoryMappedFileとFileStreamの連携 | E-27 | ○ |
| C-32 | IT-032: MemoryMappedViewStreamとStreamの連携 | E-28 | ○ |
| C-33 | IT-033: 例外クラスとエラーハンドリングの連携 | E-29 | ○ |
| C-34 | IT-034: GUIDと文字列/バイト配列変換の連携 | E-30 | ○ |
| C-35 | IT-035: Versionクラスと比較機能の連携 | E-31 | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-015**: ArrayListTests.clsは存在するが、Comparerを使用したソートの具体的なテストケースは直接確認していない
  - 候補：ArrayListTests.cls / ComparerTests.cls / SortedListTests.cls
- **IT-016**: HashtableTests.clsは存在するが、StringComparerを使用した大文字小文字無視検索の具体的なテストケースは直接確認していない
  - 候補：HashtableTests.cls / StringComparerTests.cls / CaseInsensitiveComparerTests.cls
- **IT-025**: StringBuilderTests.clsは存在するが、Encodingとの連携テストは直接確認していない
  - 候補：StringBuilderTests.cls / EncodingTests.cls
- **IT-028**: IniFileTests.clsは存在するが、Stream連携の具体的なテストケースは直接確認していない
  - 候補：IniFileTests.cls / IniResourceWriterTests.cls
- **IT-035**: VersionTests.clsは存在するが、Compare機能の連携テストは直接確認していない
  - 候補：VersionTests.cls / ComparerTests.cls

## 5) リスクフラグ（レビュー観点）
- **リスク 0 (低)**: IT-034, IT-035 - 基本的なユーティリティ機能であり、影響範囲が限定的
- **リスク 1 (中)**: IT-015, IT-016, IT-025, IT-028, IT-029 - テストファイルは存在するが詳細未確認
- **リスク 2 (高)**: なし - 主要な結合テストケースはすべてソースコードで根拠を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] IT-015: ArrayListTests.clsでComparerを使用したソートテストが存在するか確認
- [ ] IT-016: HashtableTests.clsでStringComparerを使用した検索テストが存在するか確認
- [ ] IT-025: StringBuilderとEncodingの連携が実際にテストされているか確認
- [ ] IT-028: IniFileのStream連携が実際にテストされているか確認
- [ ] IT-035: Versionの比較機能が実際にテストされているか確認
- [ ] CSV形式が正しく、Excelで開いた際に文字化けしないか確認
- [ ] テストケースの優先度設定が適切か確認
- [ ] テスト手順が実行可能な粒度で記載されているか確認
