---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：API設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **業務要件ID**: 具体的な要件IDは推測であり、実際のプロジェクト要件定義書が存在しない
  2. **選択理由の深掘り**: 手動連携・バッチ連携との比較は本プロジェクト（COMライブラリ）の性質上該当しない
  3. **ROI観点**: 具体的な投資対効果の数値根拠が存在しない
  4. **利用者の具体的シーン**: 想定される利用シーンは推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、機能一覧
- E-02: `Source/CorLib/README.TXT` - バージョン履歴、変更ログ
- E-03: `docs/code-to-docs/API設計書/API設計書.md` - API一覧、クラス定義
- E-04: `Source/CorLib/System/IObject.cls` - 基底インターフェース定義
- E-05: `Source/CorLib/System.Collections/ArrayList.cls` - コレクション実装例
- E-06: `Source/CorLib/CorLib.vbp` - プロジェクト構成ファイル
- E-07: `Source/CorLib/System/` - Systemクラス群のソースコード
- E-08: `Source/CorLib/System.Text/` - テキスト処理クラス群
- E-09: `Source/CorLib/System.IO/` - IO処理クラス群
- E-10: `Source/CorLib/System.Security.Cryptography/` - 暗号化クラス群
- E-11: `Source/CorLib/System.Globalization/` - 国際化クラス群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Framework 2.0のクラスを再実装したCOMライブラリ | E-01, E-02, E-03 | ○ |
| C-02 | コレクション、暗号化、エンコーディング、ファイル操作、グローバリゼーション機能を提供 | E-01, E-03 | ○ |
| C-03 | レガシーVB6/VBAシステムの近代化ニーズに対応 | E-01, E-02 | ○ |
| C-04 | VB6/VBAと.NETアプリケーション間のデータ共有が可能 | E-01 | ○ |
| C-05 | 国際化対応（Unicode、多様なエンコーディング、各国カレンダー）をサポート | E-03, E-08, E-11 | ○ |
| C-06 | 産業標準の暗号化・ハッシュアルゴリズム（AES、RSA、SHA-256等）を提供 | E-02, E-03, E-10 | ○ |
| C-07 | 2GBを超えるファイルの操作が可能 | E-01 | ○ |
| C-08 | VB6/VBAの言語機能の限界（コレクション貧弱、Unicode不完全等）が背景にある | E-01, E-02 | ○ |
| C-09 | 業務要件IDはBR-001〜BR-005 | **根拠なし** | △ |
| C-10 | IObjectインターフェースが基底として全クラスに実装されている | E-04, E-05 | ○ |
| C-11 | ICollection、IEnumerable、IList、IDictionaryの階層構造を持つ | E-03, E-05 | ○ |
| C-12 | System.*の階層型名前空間構造を採用 | E-03, E-06 | ○ |
| C-13 | .NET互換の例外クラス階層（ArgumentException、IOException等）を提供 | E-02, E-03 | ○ |
| C-14 | Staticサフィックスクラスパターンでスタティックメソッドを実装 | E-05, E-07 | ○ |
| C-15 | ActiveX DLL（COMコンポーネント）として提供 | E-06 | ○ |
| C-16 | UTF-8、UTF-16、UTF-32等のマルチエンコーディングをサポート | E-03, E-08 | ○ |
| C-17 | MITライセンスで提供 | E-04, E-05 | ○ |
| C-18 | バージョン2.0から4.0にかけて段階的に機能強化 | E-02 | ○ |
| C-19 | 破壊的変更はメジャーバージョンで行い、BREAKINGタグで明示 | E-02 | ○ |
| C-20 | cArray->CorArray等のクラス名変更はバージョン3.0で実施 | E-02 | ○ |
| C-21 | IHashCodeProviderが削除されIEqualityComparerに置換 | E-02 | ○ |
| C-22 | 詳細ドキュメントはkellyethridge.comで参照可能 | E-01 | ○ |
| C-23 | 想定利用者はVB6開発者、Excel/Accessマクロ開発者、システム統合担当者 | **根拠なし** | △ |
| C-24 | 手動連携・バッチ連携との比較検討を実施 | **根拠なし（性質上非該当）** | △ |
| C-25 | 具体的なROI（投資対効果）の数値 | **根拠なし** | △ |
| C-26 | BigInteger、MemoryMappedFile等の高度な機能を提供 | E-02, E-03 | ○ |
| C-27 | SHA384Managed、SHA512Managedは.NET 2.0互換値を出力 | E-02 | ○ |
| C-28 | DEP保護に対応したASMコードを使用 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **業務要件定義書**: VBCorLibはオープンソースプロジェクトであり、正式な業務要件定義書は存在しない。業務要件IDは一般的なユースケースからの推測
  - 候補：プロジェクト作者へのインタビュー / GitHubのIssue履歴 / ユーザーコミュニティのフィードバック

- **利用者調査データ**: 実際の利用者属性・利用シーンの調査データは存在しない
  - 候補：GitHubのStargazer分析 / ダウンロード統計 / ユーザーアンケート

- **手動連携・バッチ連携との比較**: 本プロジェクトはCOMライブラリであり、REST APIやWebサービスではないため、これらの観点は適用外
  - 補足：代替案としての「独自設計API」「Windows API直接呼び出し」「サードパーティ購入」との比較は記載済み

- **ROI数値根拠**: オープンソースプロジェクトのため、商業的なROI分析は存在しない
  - 候補：類似商用製品との価格比較 / 開発工数の概算

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 技術的な設計判断（API形式、インターフェース設計、名前空間構造等）- コードから直接確認可能
- **1（中リスク）**: 業務観点の推測（利用者シーン、業務課題等）- 一般的なVB6/VBA開発の知識に基づく妥当な推測
- **2（高リスク）**: 業務要件ID - 実際の要件定義が存在しないため、完全に推測

## 6) レビュアーチェックリスト（最小）
- [ ] 業務要件IDは本プロジェクトの実態に合わせて修正または削除が必要か確認
- [ ] 想定利用者・利用シーンの記述が実際のユースケースと合致しているか確認
- [ ] 技術的な設計判断（.NET互換、インターフェース設計等）がコード実装と一致しているか確認
- [ ] バージョン履歴に基づく後方互換性の方針説明が正確か確認
- [ ] 「手動連携・バッチ連携との比較」が本プロジェクトの性質上不要であることを了承
