---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：アーキテクチャ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **業務要件ID（BR-001〜BR-005）の妥当性**：推測に基づく要件定義
  2. **ROI・効果の数値見積もり**：具体的根拠なし
  3. **将来の.NET移行容易性**：検証困難
  4. **開発者オンボーディング期間短縮（1/3程度）**：推測値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/アーキテクチャ設計書/アーキテクチャ設計書.md`
- E-02: `README.md` - プロジェクト概要
- E-03: `Source/CorLib/CorLib.vbp` - VB6プロジェクトファイル（クラス一覧）
- E-04: `Source/CorLib/System/Constructors.cls` - ファクトリメソッド実装
- E-05: `Source/CorLib/System/IObject.cls` - 基本インターフェース定義
- E-06: `Source/CorLib/System.Collections/IEnumerable.cls` - コレクションインターフェース
- E-07: `Source/CorLib/System/ExceptionManagement.bas` - 例外処理ブリッジ
- E-08: `Source/CorLib/System.IO/Stream.cls` - ストリーム抽象クラス
- E-09: `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` - ハッシュ抽象クラス
- E-10: `Source/CorLib/System.Collections/ArrayList.cls` - コレクション実装例
- E-11: ディレクトリ構造（Source/CorLib/System.*, Microsoft.Win32等）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの多くのクラスをVB6で再実装したライブラリである | E-01, E-02 | ○ |
| C-02 | VB6と.NETアプリケーション間のデータ共有を容易にすることが目的 | E-01, E-02 | ○ |
| C-03 | .NET Framework名前空間互換のライブラリアーキテクチャを採用 | E-01, E-03, E-11 | ○ |
| C-04 | 4層構造（Public API / Domain / Core / Type Definition）を採用 | E-01 | ○ |
| C-05 | Constructors.clsがGlobal-MultiuseのFactory関数を提供 | E-04（VB_GlobalNameSpace = True） | ○ |
| C-06 | Factory Methodパターンを使用（NewArrayList, NewFileStream等） | E-04 | ○ |
| C-07 | インターフェース駆動設計（IEnumerable, ICollection, IList分離） | E-06, E-10（Implements文） | ○ |
| C-08 | Template Methodパターンを使用（HashAlgorithmBase等） | E-03（HashAlgorithmBase.cls登録）, E-09 | ○ |
| C-09 | Decoratorパターンを使用（CryptoStreamがStreamをラップ） | E-01, E-03（CryptoStream.cls登録） | ○ |
| C-10 | VB6のOn ErrorとException階層をブリッジする機構を提供 | E-07（Throw/Catch関数実装） | ○ |
| C-11 | 例外階層がException -> SystemException -> 具体例外の構造 | E-03（クラス登録順序）, E-01 | ○ |
| C-12 | Win32 API連携はMicrosoft.Win32名前空間に分離 | E-03, E-11 | ○ |
| C-13 | CultureTable、EncodingTableをインメモリキャッシュとして使用 | E-01, E-03（CultureTable.cls, EncodingTable.cls） | ○ |
| C-14 | データベースを使用しない（ライブラリのため） | E-01, E-03（DB関連クラスなし） | ○ |
| C-15 | メッセージキューを使用しない | E-01, E-03 | ○ |
| C-16 | SimplyVBUnitによる単体テストが整備されている | E-02, テストディレクトリ構造 | ○ |
| C-17 | Unicode対応（Windows NT系）のファイルAPI使用 | E-01 | ○ |
| C-18 | DEP対応（バージョン2.3以降） | E-01 | ○ |
| C-19 | MIT Licenseで公開 | E-02, LICENSE | ○ |
| C-20 | Stream.BeginRead/BeginWriteによる限定的非同期処理サポート | E-08（メソッド定義）, E-01 | ○ |
| C-21 | 300以上のクラスが存在する | E-03（クラス登録数確認） | ○ |
| C-22 | 業務要件BR-001〜BR-005の定義 | **根拠なし** | △ |
| C-23 | システム間データ連携不具合が50%以上削減される | **根拠なし** | △ |
| C-24 | 新規開発者オンボーディング期間が1/3程度に短縮される | **根拠なし** | △ |
| C-25 | .NET移行時にコード変換が容易である | **根拠なし（推測）** | △ |
| C-26 | vbvm6lib.tlb, CorType.tlbを参照している | E-03（Reference設定） | ○ |
| C-27 | XMLスタイルのVBDocコメントを使用 | E-04, E-05, E-06（コメント形式確認） | ○ |
| C-28 | DocIncludesフォルダに詳細ドキュメントを分離 | E-04（include参照）, E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

### 業務要件定義の根拠
- 業務要件ID（BR-001〜BR-005）はプロジェクト内に明示的な要件定義書が存在しないため、README.mdやプロジェクトの目的から推察して定義
  - 候補：要件定義書 / ユーザーストーリー / プロダクトバックログ

### 効果見積もりの根拠
- 「50%削減」「1/3短縮」等の数値は類似プロジェクトの一般論からの推測値であり、VBCorLib固有の実測データは存在しない
  - 候補：ユーザー事例 / ベンチマークデータ / アンケート結果

### .NET移行容易性の検証
- .NET移行時のコード変換容易性は、実際の移行プロジェクト事例がないため検証困難
  - 候補：移行ガイド / 移行ツール / 移行事例ドキュメント

## 5) リスクフラグ（レビュー観点）

| リスク項目 | レベル | 説明 |
|---|---|---|
| 業務要件の妥当性 | 1: 中リスク | 要件定義書不在のため推測に基づく。利害関係者との確認が必要 |
| 効果見積もりの精度 | 1: 中リスク | 具体的数値の根拠が薄い。削除または「期待される」表現への修正を推奨 |
| 将来予測の不確実性 | 0: 低リスク | .NET移行容易性は一般論として妥当だが、検証は困難 |
| 技術的記述の正確性 | 0: 低リスク | ソースコードと設計書から十分な根拠を確認済み |

## 6) レビュアーチェックリスト（最小）

- [ ] 業務要件（BR-001〜BR-005）が実際のプロジェクト目的と一致しているか確認
- [ ] 効果見積もり（50%削減、1/3短縮等）の数値を削除または「期待される」表現に修正するか検討
- [ ] Factory Methodパターンの使用例（Constructors.cls）が正確に記述されているか確認
- [ ] 例外処理ブリッジ（Throw/Catch）の説明がExceptionManagement.basの実装と一致しているか確認
- [ ] インターフェース階層（IEnumerable, ICollection, IList）の説明が実装と一致しているか確認
- [ ] 4層構造の説明がアーキテクチャ設計書と整合しているか確認
- [ ] キャッシュ構成（CultureTable, EncodingTable）の説明が実装と一致しているか確認
- [ ] 利害関係者（VB6アプリケーション保守チーム等）への説明として適切な粒度か確認
