---
generated_at: 2026-01-20 21:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：インフラ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **業務要件との関連（BR-001〜BR-005）**：コードからの類推であり、実際の要件文書が存在しない
  2. **コスト情報（月額インフラ予算等）**：GitHub無償プランの推測であり、実際の契約・費用情報がない
  3. **将来の拡張性（64ビット対応等）**：ロードマップや計画文書が存在しない
  4. **コード署名に関する記述**：現状のインストーラー設定に署名設定がなく、検討中という記述は推測

---

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `docs/code-to-docs/インフラ設計書/インフラ設計書.md`（既存インフラ設計書）
- E-02: `Install/InstallScript.iss`（Inno Setupインストールスクリプト）
- E-03: `_config.yml`（GitHub Pages設定ファイル）
- E-04: `Source/CorLib/CorLib.vbp`（VB6プロジェクトファイル）
- E-05: `Source/CorLib/readme.txt`（バージョン履歴・変更ログ）
- E-06: `README.md`（プロジェクトREADME）
- E-07: `TypeLibrary/CorType.tlb`（タイプライブラリ）
- E-08: `TypeLibrary/VBVM6Lib.tlb`（VB6仮想マシンタイプライブラリ）
- E-09: `Source/Tests/CorLib.Tests.vbp`（テストプロジェクト）
- E-10: `Source/Fakes/Fakes.vbp`（Fakesプロジェクト）
- E-11: `Examples/`配下のサンプルプロジェクト群

---

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibはクライアントサイドCOMコンポーネント（ActiveX DLL）である | E-01, E-04 | ○ |
| C-02 | 配布形式はVBCorLib3.dll（約1.6MB） | E-01, E-02 | ○ |
| C-03 | Inno Setupによるインストーラー（InstallScript.iss）を使用 | E-02 | ○ |
| C-04 | LZMA圧縮（ソリッド圧縮）を採用 | E-02（`Compression=lzma; SolidCompression=yes`） | ○ |
| C-05 | DLLはシステムフォルダ（{sys}）にインストールされCOM登録される | E-02（`Flags: regserver`） | ○ |
| C-06 | VB6テンプレートディレクトリへの自動配置機能あり | E-02（`GetClassTemplatesFolder`関数） | ○ |
| C-07 | GitHub Pagesをドキュメントホスティングに使用（jekyll-theme-cayman） | E-03 | ○ |
| C-08 | GitHubでソース管理・配布を行っている | E-01, E-06 | ○ |
| C-09 | kellyethridge.comでオンラインドキュメント・CHMファイルを公開 | E-01, E-06 | ○ |
| C-10 | Windows XP以降のサポート（CompareStringOrdinal API依存を除去） | E-05（Issue #93への対応記載） | ○ |
| C-11 | Windows CryptoAPIを暗号化機能に使用 | E-01, E-05 | ○ |
| C-12 | VB6ランタイム（MSVBVM60.DLL）のみ依存 | E-01, E-04 | ○ |
| C-13 | OLE Automation（stdole2.tlb）を参照 | E-04（Reference行） | ○ |
| C-14 | VBVM6Lib（VB6仮想マシン拡張）を参照 | E-04, E-08 | ○ |
| C-15 | テストプロジェクト（CorLib.Tests.vbp）が存在 | E-09 | ○ |
| C-16 | Fakesプロジェクト（Fakes.vbp）が存在 | E-10 | ○ |
| C-17 | サンプルプロジェクトがExamples配下に存在 | E-02, E-11 | ○ |
| C-18 | Git設定（autocrlf false）の要件がある | E-06（README.md記載） | ○ |
| C-19 | バージョン4.0が最新 | E-05（readme.txt冒頭） | ○ |
| C-20 | 300以上のクラスを提供 | E-04（約350クラス定義あり） | ○ |
| C-21 | BigInteger、Int64などの拡張数値型をサポート | E-05（version 3.0変更履歴） | ○ |
| C-22 | VBCultures.nlpがリソースとしてDLLに内包 | E-01, E-05 | ○ |
| C-23 | Unicode API対応で32KB超のファイル名・2GB超ファイル操作可能 | E-01, E-05, E-06 | ○ |
| C-24 | GitHub Subversionサポートへの配慮がある | E-06（README.md記載） | ○ |
| C-25 | 業務要件（BR-001〜BR-005）の存在 | **根拠なし**（コードからの類推） | △ |
| C-26 | 月額インフラ予算0円（GitHub無償プラン運用） | **根拠なし**（推測） | △ |
| C-27 | 将来的な64ビットネイティブ対応の検討 | **根拠なし**（一般的な推測） | △ |
| C-28 | コード署名の導入検討 | **根拠なし**（インストーラーに署名設定なし、推測） | △ |

---

## 4) 不足情報（Unknown / Missing）
- **業務要件定義書が存在しない**：オープンソースプロジェクトのため正式な要件定義書がなく、コードおよびREADMEから業務要件を類推した
  - 候補：GitHubのIssue / プロジェクト作者へのインタビュー / ユーザーコミュニティからのフィードバック
- **コスト・予算情報が存在しない**：個人運営のオープンソースプロジェクトのため、予算・コスト文書がない
  - 候補：GitHubプランの公開情報 / プロジェクト作者への確認
- **ロードマップ・将来計画が存在しない**：公開されたロードマップ文書がない
  - 候補：GitHub Issues（Enhancement/Feature Request） / 作者のブログ記事
- **セキュリティ方針文書が存在しない**：SECURITY.mdやセキュリティ方針文書がリポジトリに存在しない
  - 候補：SECURITY.mdの追加 / セキュリティ監査レポート

---

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク**：業務要件の記述（C-25）はコードからの類推であり、実際の利用シナリオと乖離している可能性がある。ただし、オープンソースプロジェクトという性質上、正式な要件文書が存在しないことは一般的である。

- **0: 低リスク**：技術的な記述（C-01〜C-24）はすべてコードおよび設定ファイルから直接確認可能であり、信頼性が高い。

- **1: 中リスク**：将来の拡張性に関する記述（C-27, C-28）は推測に基づいており、実際の計画と異なる可能性がある。

---

## 6) レビュアーチェックリスト（最小）
- [ ] 業務要件（BR-001〜BR-005）の記述が、VBCorLibの実際の利用目的と整合しているか確認
- [ ] GitHub Pages（_config.yml）の設定が正しく機能しているか確認（ドキュメントサイトへのアクセステスト）
- [ ] Inno Setupインストーラー（InstallScript.iss）のビルドが正常に完了するか確認
- [ ] テストプロジェクト（CorLib.Tests.vbp）が実行可能か、VB6環境で確認
- [ ] Windows XPとの互換性に関する記述が現在も有効か確認（Issue #93の対応状況）
- [ ] kellyethridge.comのドキュメントサイトが稼働しているか確認
- [ ] 将来の拡張性に関する記述について、プロジェクト作者または最新のIssue/PRを参照して妥当性を確認
