---
generated_at: 2026-01-20 21:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：セキュリティ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **業務要件BR-001〜BR-004の具体的内容**：要件定義書等からの直接根拠なし（推測ベース）
  2. **法令・規制対応の詳細**：ライブラリコードからは法令対応意図を直接確認できない
  3. **反復回数10,000回以上の推奨根拠**：セキュリティ設計書に記載あるが、コードでのデフォルト値未確認
  4. **将来の拡張性に関する予測**：推測に基づく記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md`（セキュリティ設計書）
- E-02: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls`（Rijndael実装）
- E-03: `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls`（RSA実装）
- E-04: `Source/CorLib/System.Security.Cryptography/Rfc2898DeriveBytes.cls`（PBKDF2実装）
- E-05: `Source/CorLib/System.Security.Cryptography/RNGCryptoServiceProvider.cls`（乱数生成実装）
- E-06: `Source/CorLib/System.Security.Cryptography/DESStatic.cls`（DES弱鍵検出）
- E-07: `Source/CorLib/System.Security.Cryptography/CspParameters.cls`（CSPパラメータ）
- E-08: `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls`（対称暗号基底クラス）
- E-09: `Source/CorLib/System.Security/SecurityElement.cls`（XML検証）
- E-10: `Source/CorLib/README.TXT`（プロジェクト概要）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの暗号化機能をVB6向けに実装したライブラリである | E-01, E-10 | ○ |
| C-02 | Windows CryptoAPIを活用している | E-02, E-03, E-05 | ○ |
| C-03 | 業務要件BR-001〜BR-004が存在し、対応している | **根拠なし** | △ |
| C-04 | Rijndael(AES)のデフォルトキーサイズは256ビット | E-02 | ○ |
| C-05 | Rijndaelのデフォルトブロックサイズは128ビット | E-02 | ○ |
| C-06 | デフォルト暗号モードはCBC | E-02, E-08 | ○ |
| C-07 | デフォルトパディングはPKCS7 | E-02, E-08 | ○ |
| C-08 | DES/TripleDESの弱鍵検出機能がある | E-06 | ○ |
| C-09 | 弱鍵は4種類定義されている | E-06 | ○ |
| C-10 | 準弱鍵は12種類定義されている | E-06 | ○ |
| C-11 | Rfc2898DeriveBytesはPBKDF2を実装している | E-04 | ○ |
| C-12 | ソルトは8バイト以上が必須 | E-04 | ○ |
| C-13 | HMAC-SHA1をPRFとして使用している | E-04 | ○ |
| C-14 | RNGCryptoServiceProviderはCryptGenRandomを使用 | E-05 | ○ |
| C-15 | RSAの鍵サイズは384-16384ビットをサポート | E-03 | ○ |
| C-16 | RSAのデフォルト鍵サイズは1024ビット | E-03 | ○ |
| C-17 | RSAはOAEPパディングをサポート | E-03 | ○ |
| C-18 | RSAはMD5/SHA-1/SHA-256/384/512署名をサポート | E-03, E-01 | ○ |
| C-19 | SymmetricAlgorithmBase.Clearでキー消去が可能 | E-08 | ○ |
| C-20 | RSACryptoServiceProvider.Clearでキー破棄が可能 | E-03 | ○ |
| C-21 | PersistKeyInCspでキーの永続化を制御可能 | E-03, E-07 | ○ |
| C-22 | SecurityElementでXML入力検証を行う | E-09 | ○ |
| C-23 | FIPS 140-2認証済みプロバイダが利用可能 | **根拠なし（推測）** | △ |
| C-24 | 法令・規制（個人情報保護法等）への対応が必要 | **根拠なし（推測）** | △ |
| C-25 | 反復回数10,000回以上を推奨している | E-01 | ○ |
| C-26 | SHA-1は署名用途で非推奨 | E-01 | ○ |
| C-27 | DESは64ビット鍵で現代基準で脆弱 | E-01 | ○ |
| C-28 | 将来的にSHA-1の完全廃止が見込まれる | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- **業務要件定義書**: BR-001〜BR-004の業務要件は、VBCorLibプロジェクトの想定利用シナリオから推測したものであり、実際の要件定義書が存在するか不明
  - 候補：プロジェクト内requirements.md / 外部ドキュメント / 顧客提供資料
- **法令対応の設計意図**: コードやドキュメントから法令対応の明示的意図を読み取れない
  - 候補：開発者へのヒアリング / 設計レビュー記録
- **FIPS 140-2認証確認**: Windows CryptoAPIプロバイダの認証状況はMicrosoft公式ドキュメントで確認が必要
  - 候補：Microsoft Security Documentation / NIST CMVP Database
- **反復回数のコード実装確認**: セキュリティ設計書では10,000回以上推奨とあるが、Rfc2898DeriveBytesのデフォルト反復回数はコードで確認できず（初期化時に外部から指定）
  - 候補：Constructors.cls / テストコード

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: 業務要件の記述は推測ベースであり、実際の要件との整合性を確認する必要がある
- **リスク1（低）**: 法令・規制対応の記述は一般論であり、特定の法令への厳密な準拠を保証するものではない
- **リスク0（低）**: コードから直接確認できる技術的主張は信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] C-03〜C-04（業務要件）の内容が実際のプロジェクト目的と合致しているか確認
- [ ] C-23（FIPS 140-2）の記述がMicrosoft公式ドキュメントと整合しているか確認
- [ ] C-25（反復回数10,000回）の推奨がドキュメントとして適切に周知されているか確認
- [ ] C-28（SHA-1廃止予測）の記述が現在の業界動向と整合しているか確認
- [ ] セキュリティ設計意図書全体が、既存のセキュリティ設計書と矛盾していないか確認
- [ ] 「不採用とした選択肢の理由」が技術的に妥当であるか確認
