---
generated_at: 2026-01-20 21:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 20
  claims_without_evidence: 4
confidence_derived: 0.83
---

# 根拠レポート：バッチ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：20 / 24、根拠なし：4
- 優先レビュー（高）
  1. **業務負荷の定量値（月5回、年10時間等）**：実際の開発頻度は不明
  2. **エンドユーザー数・サポートコスト**：利用状況の実データなし
  3. **将来の拡張性（CI/CD統合等）**：推測に基づく記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/バッチ設計書/1-Build.bat.md` - Build.batのバッチ設計書
- E-02: `docs/code-to-docs/バッチ設計書/2-InstallScript.iss.md` - InstallScript.issのバッチ設計書
- E-03: `docs/code-to-docs/バッチ設計書/plan.md` - バッチ設計書生成プラン（総バッチ数: 2を確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの機能をVB6環境で利用可能にするライブラリである | E-01（業務上の目的・背景） | ○ |
| C-02 | Build.batはODLファイルからTLBファイルを生成しシステムに登録する | E-01（主要な処理内容） | ○ |
| C-03 | Build.batはmktyplib、regtlibコマンドを使用する | E-01（処理シーケンス） | ○ |
| C-04 | Build.batはerrorlevelチェックでエラー検知しpauseで停止する | E-01（エラー処理、処理シーケンス） | ○ |
| C-05 | Build.batは管理者権限が必要 | E-01（前提条件） | ○ |
| C-06 | InstallScript.issはVBCorLib-3.2.0.exeインストーラーを生成する | E-02（出力ファイル仕様） | ○ |
| C-07 | InstallScript.issはVBCorLib3.dllをシステムディレクトリにコピーしCOM登録する | E-02（主要な処理内容） | ○ |
| C-08 | InstallScript.issはVB6テンプレートディレクトリを自動検出する | E-02（テンプレートディレクトリ検出ロジック） | ○ |
| C-09 | InstallScript.issはInno Setupを使用する | E-02（前提条件、処理シーケンス） | ○ |
| C-10 | プロジェクトのバージョンは3.2.0である | E-02（AppName = VBCorLib 3.2.0） | ○ |
| C-11 | タイプライブラリのUUIDは{1705040f-4494-4ab3-8a97-a9f84820636d}である | E-01（備考） | ○ |
| C-12 | mktyplib は古いツールでVisual Studio 2005以降はMIDLに置き換えられた | E-01（備考） | ○ |
| C-13 | バッチは2つ存在する（Build.bat、InstallScript.iss） | E-03（総バッチ数: 2） | ○ |
| C-14 | Build.batの処理時間は数秒である | E-01（パフォーマンス要件：目標処理時間 数秒以内） | ○ |
| C-15 | InstallScript.issのコンパイル時間は数秒〜数十秒である | E-02（パフォーマンス要件：数秒〜数十秒） | ○ |
| C-16 | 両バッチは手動実行である | E-01, E-02（実行スケジュール：随時（手動）） | ○ |
| C-17 | InstallScript.issにはLZMA圧縮が使用される | E-02（圧縮方式: LZMA） | ○ |
| C-18 | インストーラーにはアンインストール機能がある | E-02（トランザクション仕様：Inno Setupのアンインストール機能） | ○ |
| C-19 | AppIdは{CBB90C23-2F68-4770-8469-85F0B78FFF25}である | E-02（セットアップ情報） | ○ |
| C-20 | GitHubでプロジェクトが公開されている | E-02（AppURL: https://github.com/kellyethridge/VBCorLib） | ○ |
| C-21 | Build.batの実行頻度は月1〜5回程度と推定 | **根拠なし** | △ |
| C-22 | 手動でのビルド作業は1回あたり5〜10分と推定 | **根拠なし** | △ |
| C-23 | エンドユーザーの手動インストール時間は30分〜1時間と推定 | **根拠なし** | △ |
| C-24 | 年4回程度のリリースがあると推定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **開発頻度・リリース頻度に関するデータ**
  - 実際のコミット履歴やリリース履歴を確認すれば精度向上可能
  - 候補：GitHubのリリースページ / コミットログ / CHANGELOGファイル

- **エンドユーザーの利用実態**
  - ダウンロード数、Issue報告数などから間接的に推定可能
  - 候補：GitHub Insights / ダウンロード統計 / Issueトラッカー

- **手動作業時間の実測データ**
  - 実際に手動でビルド・インストールを行った場合の時間計測
  - 候補：開発者へのヒアリング / 実測データ

- **機能設計意図書**
  - ドメイン概要の参照先として記載したが、ファイルが存在しない
  - 候補：機能設計意図書の作成

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 業務負荷の定量値は推定に基づいており、実際の開発・利用実態と乖離している可能性がある
- **0: 低リスク** - 技術的な記述（バッチの処理内容、設計判断）はバッチ設計書に基づいており信頼性が高い
- **0: 低リスク** - バッチの網羅性は確認済み（plan.mdの総バッチ数2と一致）

## 6) レビュアーチェックリスト（最小）
- [ ] 業務負荷の定量値（年10時間、年16時間等）が実態と大きく乖離していないか確認
- [ ] Build.bat、InstallScript.issの2つのバッチがすべて記載されていることを確認
- [ ] 技術設計判断（9項目）がすべて記載されていることを確認
- [ ] 「手動運用を選ばなかった理由」「リアルタイム処理を選ばなかった理由」が各バッチに記載されていることを確認
- [ ] 機能設計意図書が作成された場合、ドメイン概要の参照が正しく機能するか確認
