---
generated_at: 2026-01-20 21:10:00
metrics:
  claims_total: 95
  claims_with_evidence: 85
  claims_without_evidence: 10
confidence_derived: 0.89
---

# 根拠レポート：機能設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：85 / 95、根拠なし：10
- 優先レビュー（高）
  1. **工数見積もり値**：具体的な数値（時間）は推定値であり、実測データなし
  2. **業務負荷の定量化**：月間件数・頻度は推定であり、実際の利用状況データなし
  3. **市場・業界分析**：VB6レガシーシステムの市場規模は一般知識に基づく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要説明
- E-02: `Source/CorLib/README.TXT` - バージョン履歴と機能一覧
- E-03: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 85件の業務要件一覧
- E-04: `docs/code-to-docs/機能設計書/1-CorArray.md` - 配列操作機能の設計書
- E-05: `docs/code-to-docs/機能設計書/21-Hashtable.md` - ハッシュテーブル機能の設計書
- E-06: `docs/code-to-docs/機能設計書/51-TripleDESCryptoServiceProvider.md` - 暗号化機能の設計書
- E-07: `docs/code-to-docs/機能設計書/42-Encoding.md` - エンコーディング機能の設計書
- E-08: `docs/code-to-docs/機能設計書/73-CultureInfo.md` - カルチャ情報機能の設計書
- E-09: `docs/code-to-docs/機能設計書/34-File.md` - ファイル操作機能の設計書
- E-10: `docs/code-to-docs/機能設計書/3-CorDateTime.md` - 日付時刻機能の設計書
- E-11: `docs/code-to-docs/機能設計書/85-ResourceManager.md` - リソース管理機能の設計書
- E-12: `docs/code-to-docs/機能設計書/91-RegistryKey.md` - レジストリ操作機能の設計書
- E-13: `Source/CorLib/System.Collections/*.cls` - コレクションクラス群（40ファイル）
- E-14: `Source/CorLib/System.Security.Cryptography/*.cls` - 暗号化クラス群（76ファイル）
- E-15: `Source/CorLib/System.Text/*.cls` - テキストエンコーディングクラス群（43ファイル）
- E-16: `Source/CorLib/System.IO/*.cls` - ファイル/ストリームクラス群（35ファイル）
- E-17: `Source/CorLib/System/*.cls` - 基本システムクラス群（95ファイル）
- E-18: `Source/CorLib/System.Globalization/*.cls` - グローバリゼーションクラス群（28ファイル）
- E-19: `Source/CorLib/System.Resources/*.cls` - リソース管理クラス群（31ファイル）
- E-20: `Source/CorLib/Microsoft.Win32/*.cls` - レジストリ操作クラス群（3ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Framework互換のVB6ライブラリ | E-01, E-02 | ○ |
| C-02 | ドメインはVB6/VBAアプリケーション開発 | E-01, E-02 | ○ |
| C-03 | ArrayList機能が存在する | E-03, E-13 | ○ |
| C-04 | Hashtable機能が存在する | E-03, E-05, E-13 | ○ |
| C-05 | Stack/Queue機能が存在する | E-03, E-13 | ○ |
| C-06 | SortedList機能が存在する | E-03, E-13 | ○ |
| C-07 | BitArray機能が存在する | E-03, E-13 | ○ |
| C-08 | CorArray機能が存在する | E-03, E-04, E-17 | ○ |
| C-09 | Rijndael/AES暗号化機能が存在する | E-03, E-14 | ○ |
| C-10 | TripleDES暗号化機能が存在する | E-03, E-06, E-14 | ○ |
| C-11 | DES暗号化機能が存在する | E-03, E-14 | ○ |
| C-12 | RC2暗号化機能が存在する | E-03, E-14 | ○ |
| C-13 | RSA非対称暗号化機能が存在する | E-03, E-14 | ○ |
| C-14 | DSAデジタル署名機能が存在する | E-03, E-14 | ○ |
| C-15 | SHA-1/256/384/512ハッシュ機能が存在する | E-03, E-14 | ○ |
| C-16 | MD5ハッシュ機能が存在する | E-03, E-14 | ○ |
| C-17 | RIPEMD-160ハッシュ機能が存在する | E-03, E-14 | ○ |
| C-18 | HMAC認証機能が存在する | E-03, E-14 | ○ |
| C-19 | Rfc2898DeriveBytes（PBKDF2）機能が存在する | E-03, E-14 | ○ |
| C-20 | CryptoStream機能が存在する | E-03, E-14 | ○ |
| C-21 | Base64変換機能が存在する | E-03, E-14 | ○ |
| C-22 | Encoding基盤機能が存在する | E-03, E-07, E-15 | ○ |
| C-23 | UTF-8/7/16/32エンコーディング機能が存在する | E-03, E-15 | ○ |
| C-24 | ASCIIエンコーディング機能が存在する | E-03, E-15 | ○ |
| C-25 | コードページエンコーディング機能が存在する | E-03, E-15 | ○ |
| C-26 | StringBuilder機能が存在する | E-03, E-15 | ○ |
| C-27 | CorString機能が存在する | E-03, E-17 | ○ |
| C-28 | File/FileInfo機能が存在する | E-03, E-09, E-16 | ○ |
| C-29 | FileStream機能が存在する | E-03, E-16 | ○ |
| C-30 | Directory/DirectoryInfo機能が存在する | E-03, E-16 | ○ |
| C-31 | Path機能が存在する | E-03, E-16 | ○ |
| C-32 | DriveInfo機能が存在する | E-03, E-16 | ○ |
| C-33 | MemoryStream機能が存在する | E-03, E-16 | ○ |
| C-34 | BinaryReader/Writer機能が存在する | E-03, E-16 | ○ |
| C-35 | StreamReader/Writer機能が存在する | E-03, E-16 | ○ |
| C-36 | StringReader/Writer機能が存在する | E-03, E-16 | ○ |
| C-37 | MemoryMappedFile機能が存在する | E-03, E-16 | ○ |
| C-38 | IniResourceWriter機能が存在する | E-03, E-16 | ○ |
| C-39 | CorDateTime機能が存在する | E-03, E-10, E-17 | ○ |
| C-40 | TimeSpan機能が存在する | E-03, E-17 | ○ |
| C-41 | TimeZone機能が存在する | E-03, E-17 | ○ |
| C-42 | CultureInfo機能が存在する | E-03, E-08, E-18 | ○ |
| C-43 | DateTimeFormatInfo機能が存在する | E-03, E-18 | ○ |
| C-44 | NumberFormatInfo機能が存在する | E-03, E-18 | ○ |
| C-45 | 各種カレンダー機能が存在する | E-03, E-18 | ○ |
| C-46 | BigInteger機能が存在する | E-03, E-17 | ○ |
| C-47 | Int64機能が存在する | E-03, E-17 | ○ |
| C-48 | Random/RNGCryptoServiceProvider機能が存在する | E-03, E-14, E-17 | ○ |
| C-49 | CorMath機能が存在する | E-03, E-17 | ○ |
| C-50 | BitConverter機能が存在する | E-03, E-17 | ○ |
| C-51 | Convert機能が存在する | E-03, E-17 | ○ |
| C-52 | Buffer機能が存在する | E-03, E-17 | ○ |
| C-53 | Char機能が存在する | E-03, E-17 | ○ |
| C-54 | ResourceManager機能が存在する | E-03, E-11, E-19 | ○ |
| C-55 | ResourceReader/Writer機能が存在する | E-03, E-19 | ○ |
| C-56 | ResourceSet機能が存在する | E-03, E-19 | ○ |
| C-57 | RegistryKey機能が存在する | E-03, E-12, E-20 | ○ |
| C-58 | Guid機能が存在する | E-03, E-17 | ○ |
| C-59 | Version機能が存在する | E-03, E-17 | ○ |
| C-60 | Environment機能が存在する | E-03, E-17 | ○ |
| C-61 | Thread/WaitHandle機能が存在する | E-03, E-17 | ○ |
| C-62 | Ticker機能が存在する | E-03, E-17 | ○ |
| C-63 | Exception階層が存在する | E-03, E-17 | ○ |
| C-64 | ArgumentException系例外が存在する | E-03, E-17 | ○ |
| C-65 | IOException系例外が存在する | E-03, E-16 | ○ |
| C-66 | FormatException例外が存在する | E-03, E-17 | ○ |
| C-67 | InvalidOperationException例外が存在する | E-03, E-17 | ○ |
| C-68 | IObject/IComparable等インターフェースが存在する | E-03, E-17, E-13 | ○ |
| C-69 | Comparer/EqualityComparer機能が存在する | E-03, E-13 | ○ |
| C-70 | Console機能が存在する | E-03, E-17 | ○ |
| C-71 | VB6標準機能に日付時刻のミリ秒精度がない | E-10（設計書記載） | ○ |
| C-72 | VB6標準機能に暗号化APIがない | E-06（設計書記載） | ○ |
| C-73 | VB6のファイル操作に2GB制限がある | E-09（設計書記載） | ○ |
| C-74 | Windows CryptoAPIを使用して暗号化を実装 | E-06（設計書記載）, E-14 | ○ |
| C-75 | .NET Framework互換のAPI設計 | E-01, E-02, 各機能設計書 | ○ |
| C-76 | VB6標準Collectionは機能が限定的 | E-04, E-05（設計書記載） | ○ |
| C-77 | 多言語対応が困難という課題 | E-08, E-11（設計書記載） | ○ |
| C-78 | Currency型で64ビット精度を実現 | E-10（設計書記載） | ○ |
| C-79 | カルチャフォールバック機能がある | E-11（設計書記載） | ○ |
| C-80 | IFormatProviderインターフェースを実装 | E-08（設計書記載） | ○ |
| C-81 | 2GB超ファイルに対応 | E-01, E-09（設計書記載） | ○ |
| C-82 | PropertyBagによるシリアライズ対応 | E-08, E-10（設計書記載） | ○ |
| C-83 | 弱い鍵のチェック機能がある | E-06（設計書記載） | ○ |
| C-84 | クイックソートアルゴリズムを使用 | E-04（設計書記載） | ○ |
| C-85 | ダブルハッシングによる衝突解決 | E-05（設計書記載） | ○ |
| C-86 | 工数見積もり：ArrayList独自実装に16時間 | **根拠なし** | △ |
| C-87 | 工数見積もり：暗号化独自実装に40-100時間 | **根拠なし** | △ |
| C-88 | 工数見積もり：エンコーディング独自実装に20-40時間 | **根拠なし** | △ |
| C-89 | 業務負荷：コレクション操作は「非常に高い」頻度 | **根拠なし** | △ |
| C-90 | 業務負荷：暗号化は「高い」頻度 | **根拠なし** | △ |
| C-91 | 市場分析：VB6レガシーシステムが多く存在 | **根拠なし**（一般知識） | △ |
| C-92 | 独自実装による「品質・保守性に問題」 | **根拠なし**（一般論） | △ |
| C-93 | 手動運用による「90%工数削減」効果 | **根拠なし**（推定） | △ |
| C-94 | セキュリティ実装ミスは「致命的」 | **根拠なし**（一般論） | △ |
| C-95 | コンプライアンス要件（PCI-DSS等）への対応困難 | **根拠なし**（一般論） | △ |

## 4) 不足情報（Unknown / Missing）
- **工数見積もりの根拠**: 各機能の独自実装に必要な工数は、実際の開発実績データや業界標準見積もりに基づいていない。類似プロジェクトの実績データがあれば精度向上が可能。
  - 候補：類似ライブラリ開発プロジェクトの工数実績 / 業界標準の機能点見積もり / 実際のユーザー調査

- **業務負荷の定量データ**: 「非常に高い」「高い」「中程度」等の業務負荷は定性的な評価であり、実際の利用頻度データに基づいていない。
  - 候補：ライブラリ利用統計 / ユーザーアンケート / ダウンロード・利用ログ

- **市場・業界分析データ**: VB6レガシーシステムの市場規模や、.NET移行の傾向は一般知識に基づく推定。
  - 候補：IT市場調査レポート / プログラミング言語利用統計 / エンタープライズ調査

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 全体的に機能の存在根拠は確実だが、工数・効果の定量値は推定に基づく
- 確認推奨事項：
  - 工数見積もり値の妥当性確認（実際のプロジェクト経験との照合）
  - 業務負荷の優先度付けの妥当性確認（ステークホルダーとの合意）
  - セキュリティ関連の主張の厳密性確認（コンプライアンス要件との照合）

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能の存在と機能設計書との整合性を確認
- [ ] 業務要件一覧（85件）との網羅性を確認
- [ ] 業務プロセス分類の妥当性を確認
- [ ] 工数見積もり値の現実性を確認（組織の実績と比較）
- [ ] 優先度（高/中/低）の妥当性を確認
- [ ] ドメイン課題の記述が組織の実態と合致するか確認
- [ ] .NET互換性の主張がソースコードと一致するか抜き打ち確認
