---
generated_at: 2026-01-20 21:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 38
  claims_without_evidence: 7
confidence_derived: 0.84
---

# 根拠レポート: 画面設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.84**
  - 根拠あり: 38 / 45、根拠なし: 7
- 優先レビュー（高）
  1. **業務インパクトの数値**: 学習時間の削減効果の定量的根拠が不足
  2. **ドメイン概要**: 機能設計意図書が存在しないため独自記述
  3. **将来の拡張性**: 推測に基づく記述が多い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面設計書/1-Simply VB Unit Runner.md`
- E-02: `docs/code-to-docs/画面設計書/2-Static Classes Demo.md`
- E-03: `docs/code-to-docs/画面設計書/3-Simple Ticker (Event版).md`
- E-04: `docs/code-to-docs/画面設計書/4-Base64 Encoding.md`
- E-05: `docs/code-to-docs/画面設計書/5-Simple Ticker 2 (Callback版).md`
- E-06: `docs/code-to-docs/画面設計書/6-Real-Time Decryption.md`
- E-07: `docs/code-to-docs/画面設計書/7-File Encryption.md`
- E-08: `docs/code-to-docs/画面設計書/8-Hash Codes.md`
- E-09: `docs/code-to-docs/画面設計書/9-Simple Registry Browser.md`
- E-10: `docs/code-to-docs/画面設計書/10-Resource Browser.md`
- E-11: `docs/code-to-docs/画面設計書/11-Simple INI File Browser.md`
- E-12: `docs/code-to-docs/画面設計書/12-Simple Browser 2 (Callback).md`
- E-13: `docs/code-to-docs/画面設計書/13-File Hex Viewer.md`
- E-14: `docs/code-to-docs/画面設計書/14-Simple Browser (IComparer).md`
- E-15: `docs/code-to-docs/画面設計書/15-Number Formatting.md`

## 3) Claims と根拠の対応（レビューの主戦場）

### ドメイン概要

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-01 | VBCorLibは.NET FrameworkをVB6/VBAに移植したライブラリ | E-01〜E-15（全画面設計書の業務上の目的・背景に記載） | ○ |
| C-02 | 画面群はデモンストレーション・サンプルアプリケーション | E-02〜E-15（各画面の画面種別に記載） | ○ |
| C-03 | Simply VB Unit Runnerはテストランナー | E-01（画面種別: テスト実行・結果表示） | ○ |

### 業務プロセス1: ライブラリ機能のデモンストレーション

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-04 | 14画面がデモンストレーション目的 | E-02〜E-15（14画面の画面設計書） | ○ |
| C-05 | Static Classes DemoはPath、Environment、MathExt、TimeZoneのデモ | E-02（関連機能: Path、Environment、CorMath、TimeZone） | ○ |
| C-06 | Simple Ticker (Event版)はTickerイベント通知機能のデモ | E-03（関連機能: Ticker） | ○ |
| C-07 | Simple Ticker 2 (Callback版)はTickerコールバック機能のデモ | E-05（関連機能: Ticker） | ○ |
| C-08 | Base64 EncodingはBase64変換機能のデモ | E-04（関連機能: Convert、File） | ○ |
| C-09 | Real-Time DecryptionはCryptoStream機能のデモ | E-06（関連機能: CryptoStream、RijndaelManaged） | ○ |
| C-10 | File Encryptionは複数暗号アルゴリズムのデモ | E-07（関連機能: CryptoStream、DES、TripleDES、RC2、Rijndael） | ○ |
| C-11 | Hash Codesは6種類のハッシュアルゴリズムのデモ | E-08（関連機能: SHA1、SHA256、SHA384、SHA512、MD5、RIPEMD160） | ○ |
| C-12 | Simple Registry BrowserはRegistry/RegistryKeyのデモ | E-09（関連機能: Registry、RegistryKey） | ○ |
| C-13 | Resource BrowserはResourceReader機能のデモ | E-10（関連機能: ResourceManager、ResourceReader、WinResourceReader） | ○ |
| C-14 | Simple INI File BrowserはIniFileのデモ | E-11（関連機能: IniFile） | ○ |
| C-15 | Simple Browser 2はファイルシステム操作とコールバックソートのデモ | E-12（関連機能: DirectoryInfo、FileInfo、CorArray.Sort） | ○ |
| C-16 | File Hex ViewerはMemoryMappedFileのデモ | E-13（関連機能: MemoryMappedFile） | ○ |
| C-17 | Simple BrowserはファイルシステムとIComparerのデモ | E-14（関連機能: DirectoryInfo、FileInfo、IComparer） | ○ |
| C-18 | Number FormattingはCorString.Formatのデモ | E-15（関連機能: CorString.Format） | ○ |
| C-19 | 学習時間短縮効果の定量的数値（120分→20分等） | **根拠なし** | △ |

### 業務プロセス2: ライブラリ品質保証

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-20 | Simply VB Unit Runnerはユニットテスト実行画面 | E-01（画面種別: テスト実行・結果表示） | ○ |
| C-21 | 100以上のテストケースが存在 | E-01（テストスイート一覧に多数のテストクラスが列挙） | ○ |
| C-22 | テスト実行時間が数分で完了 | **根拠なし** | △ |
| C-23 | 手動テストで4-8時間かかる | **根拠なし** | △ |

### 各画面想定意図サマリー

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-24 | 全15画面について意図を記載 | E-01〜E-15（全15画面の画面設計書を参照） | ○ |
| C-25 | 各画面の背景課題はAPIドキュメントだけでは使い方が分かりにくい | E-02〜E-15（業務上の目的・背景に記載） | ○ |
| C-26 | 手動運用を選ばなかった理由は妥当 | E-01〜E-15（各画面の機能はExcel等で代替不可能） | ○ |
| C-27 | Excel管理を選ばなかった理由は妥当 | E-01〜E-15（プログラミング機能のデモはExcelでは不可能） | ○ |

### 技術設計判断

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-28 | UIフレームワークはVB6ネイティブ+MSCOMCTL.OCX | E-01〜E-15（備考欄にMSCOMCTL.OCX、COMDLG32.OCX等の記載） | ○ |
| C-29 | 状態管理はモジュールレベル変数 | E-01〜E-15（コードリーディングガイドに変数宣言の記載） | ○ |
| C-30 | コンポーネント設計はフラット構造 | E-01〜E-15（関連ファイル一覧で単一フォーム構成を確認） | ○ |
| C-31 | スタイリングは標準コントロール | E-01〜E-15（備考欄にBorderStyle=Fixed Single等の記載） | ○ |
| C-32 | レスポンシブ対応は固定サイズ | E-01〜E-15（備考欄にBorderStyle=Fixed Single、MaxButton=False等の記載） | ○ |
| C-33 | ルーティング設計は単一フォーム | E-01〜E-15（画面遷移: 他の画面への遷移はない） | ○ |
| C-34 | フォーム設計はネイティブフォーム | E-01〜E-15（VB6標準機能のみ使用） | ○ |
| C-35 | データフェッチングは同期処理 | E-01〜E-15（コードリーディングガイドで同期処理を確認） | ○ |
| C-36 | アクセシビリティ対応は標準機能のみ | E-01（F5キー、ESCキーの対応）、他は特別な対応なし | ○ |

### 将来の拡張性

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-37 | 新機能追加時は独立したプロジェクトとして追加 | **根拠なし**（推測） | △ |
| C-38 | テストケース追加はSim.NewTestSuiteパターンに従う | E-01（コードリーディングガイドにNewTestSuiteパターンの記載） | ○ |
| C-39 | VB.NET移植時にロジックは再利用可能 | **根拠なし**（推測） | △ |

### 網羅性確認

| Claim ID | 主張 | Evidence | 状態 |
|----------|------|----------|------|
| C-40 | 画面設計書15ファイルを全て参照 | E-01〜E-15（confidence-report除く全15ファイル） | ○ |
| C-41 | 画面設計意図書に15画面全てを記載 | 画面設計意図書本文で確認 | ○ |
| C-42 | 9つの技術設計論点全てを記載 | 画面設計意図書セクション4で確認 | ○ |
| C-43 | 業務要件一覧は存在しない（参照不可） | ディレクトリ確認でconfidence-reportのみ存在 | ○ |
| C-44 | 機能設計意図書は存在しない（参照不可） | ディレクトリ確認で空ディレクトリ | ○ |
| C-45 | 工数削減効果の数値は推測に基づく | **根拠なし**（業界標準の目安を参考に推測） | △ |

## 4) 不足情報（Unknown / Missing）

- **業務インパクトの定量的数値**
  - 「学習時間が120分→20分に削減」等の数値は推測に基づく
  - 候補: ユーザー調査 / 開発者ヒアリング / 類似ライブラリの学習曲線データ

- **テスト実行時間**
  - 「数分で全テストケースを実行可能」は推測
  - 候補: 実際の実行ログ / ベンチマーク結果

- **手動テスト工数**
  - 「手動テストで4-8時間」は推測
  - 候補: 実際のテスト記録 / 開発者ヒアリング

- **機能設計意図書**
  - 本来参照すべきだが存在しない
  - 対応: ドメイン概要を画面設計意図書内で独自記述

- **業務要件一覧**
  - 本来参照すべきだが本体が存在しない（confidence-reportのみ）
  - 対応: 画面設計書から業務課題を類推

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|-----|------|
| 1: 中リスク | 工数削減効果の数値 | 定量的根拠がなく、実際の効果と乖離する可能性 |
| 1: 中リスク | 将来の拡張性に関する記述 | 推測に基づくため、実際の方針と異なる可能性 |
| 0: 低リスク | 技術設計判断 | 画面設計書から明確に読み取れる情報 |
| 0: 低リスク | 画面一覧と機能説明 | 画面設計書と完全に対応 |
| 0: 低リスク | ドメイン概要 | 各画面設計書の業務上の目的・背景から導出 |

## 6) レビュアーチェックリスト（最小）

- [ ] ドメイン概要がVBCorLibプロジェクトの実態と合致しているか
- [ ] 全15画面が業務プロセス別の画面一覧に含まれているか
- [ ] 工数削減効果の数値が妥当な範囲か（実態と大きく乖離していないか）
- [ ] 技術設計判断の根拠が画面設計書と整合しているか
- [ ] 「手動運用を選ばなかった理由」「Excel管理を選ばなかった理由」が論理的か
- [ ] 将来の拡張性に関する記述が開発方針と矛盾しないか
