# アーキテクチャ設計意図書

## 概要

本ドキュメントは、VBCorLibプロジェクトのアーキテクチャ設計意図について記述します。VBCorLibは、Visual Basic 6（VB6）環境において .NET Frameworkと同等の機能を提供するクラスライブラリであり、レガシーVB6アプリケーションのモダナイゼーションを支援し、VB6と.NETアプリケーション間のデータ共有を容易にすることを目的としています。

---

## 業務要件との関連（なぜこのアーキテクチャが必要か）

### 対応する業務要件

| 業務要件ID | 業務要件名 | アーキテクチャに求められる要件 |
| --- | --- | --- |
| BR-001 | VB6アプリケーションの継続運用 | 既存VB6アプリケーションを大幅改修なく運用継続できること |
| BR-002 | .NETとのデータ互換性確保 | VB6と.NETアプリケーション間で同一データ形式（暗号化、シリアライズ等）を扱えること |
| BR-003 | モダンな開発パラダイムの導入 | VB6環境においても構造化例外処理、インターフェース駆動設計等のモダンな開発手法を適用できること |
| BR-004 | セキュリティ機能の強化 | VB6標準では不足するセキュリティ機能（暗号化、ハッシュ等）を補完すること |
| BR-005 | 国際化対応 | 多言語・多地域対応（文字エンコーディング、カレンダー、数値形式等）を実現すること |

### 業務観点でのアーキテクチャ要件

#### 業務の特性とシステムへの要求

VBCorLibが対象とする業務は、レガシーVB6アプリケーションの長期運用という特殊な状況にあります。多くの企業がVB6で構築した基幹システムや業務アプリケーションを保有しており、これらを即座に.NETへ移行することは、コスト・リスク・人材の観点から現実的ではありません。

| 業務特性 | システムへの要求 | 根拠 |
| --- | --- | --- |
| レガシーシステムの長期運用 | 既存コードへの影響最小化 | VB6アプリケーションの多くは10年以上稼働しており、大規模改修は業務リスクが高い |
| .NETシステムとの並行稼働 | データ形式の完全互換性 | VB6システムから.NETへの段階的移行期間中、両システム間でデータ交換が必要 |
| セキュリティ要件の高度化 | 最新暗号化アルゴリズムの利用 | 近年のセキュリティ基準では、VB6標準機能では不十分な暗号化強度が求められる |
| グローバル展開の必要性 | 国際化・多言語対応 | 海外拠点との連携や多言語ユーザー対応が求められるケースが増加 |
| 開発生産性の向上 | .NET互換APIの提供 | .NET経験者がVB6開発に参画しやすくなり、学習コストを削減 |

#### 開発・運用体制との整合性

| 体制の特性 | アーキテクチャへの要求 | 根拠 |
| --- | --- | --- |
| VB6/VBA開発者の減少 | .NET類似のAPI設計 | .NET経験者がスムーズに参画できるよう、.NET Framework互換のAPI設計を採用 |
| 段階的移行プロジェクト | モジュール単位での利用 | 必要な機能だけを段階的に導入できるよう、独立性の高いモジュール構成が必要 |
| 長期保守の必要性 | 高い可読性と保守性 | 10年以上の長期運用を想定し、ドキュメント整備と一貫した設計パターンの適用が必要 |
| 限られた開発リソース | 既存知識の活用 | .NET Frameworkの設計知識がそのまま活用できる構造 |

### 検討したアーキテクチャ案（業務観点）

| 案 | 概要 | メリット | デメリット | 業務適合性 |
| --- | --- | --- | --- | --- |
| A | COM DLL単機能ライブラリ群 | 軽量、必要機能のみ導入可能 | 一貫性なし、学習コスト高 | 低 |
| B | VB6ネイティブラッパー（Win32 API薄いラッパー） | 高速、軽量 | 抽象化不足、.NET互換性低 | 低 |
| C（採用） | .NET Framework名前空間互換ライブラリ | .NET互換、学習コスト低、移行容易 | やや大規模、導入工数 | 高 |
| D | 完全.NET移行（VB6廃止） | 最新技術活用、長期的メリット | 移行コスト膨大、業務停止リスク | 対象外 |

### 選択理由（業務観点）

1. **業務要件との適合性**: .NET Frameworkの名前空間構造・API設計を踏襲することで、VB6と.NET間でのデータ形式互換性を保証できる。同一の暗号化アルゴリズム、エンコーディング、シリアライズ形式を使用することで、システム間連携の信頼性が大幅に向上する。

2. **業務ルール変更への対応力**: インターフェース駆動設計とTemplate Methodパターンの採用により、個別の実装（例: 新しい暗号化アルゴリズム、新しいカレンダー）を追加する際に既存コードへの影響を最小化できる。

3. **開発・運用体制との整合性**: .NET Framework経験者が即座にVBCorLibを理解・活用できる設計となっており、人材調達の柔軟性が高い。ドキュメンテーション（DocIncludes）も.NET形式を踏襲しており、学習コストが低い。

4. **将来の業務拡大への対応**: モジュラー構造により、新機能追加時も既存機能への影響を最小限に抑制できる。また、.NET移行時にはAPIの類似性によりコード変換が容易。

5. **費用対効果（ROI）**: 完全な.NET移行と比較し、VBCorLib導入による「延命」戦略は初期投資が圧倒的に小さい。既存資産を活かしながら段階的にモダナイゼーションを進められるため、リスク分散と投資効果の最大化が可能。

---

## システム特性・前提条件

VBCorLibは、以下のシステム特性・前提条件を考慮してアーキテクチャが設計されています。

| 項目 | 内容 | 補足 |
| --- | --- | --- |
| サービス種別 | 再利用可能なクラスライブラリ（COM DLL） | VB6アプリケーションから参照設定で利用 |
| 実行環境 | Windows OS（NT系、特に2000以降） | Unicode APIを使用するためNT系が前提 |
| 対象プラットフォーム | Visual Basic 6 / VBA | VB6ランタイム依存、32ビット |
| 互換対象 | .NET Framework（主に2.0-4.x相当） | System.*名前空間の主要クラスを再実装 |
| チーム規模 | 小〜中規模（保守チーム含む） | オープンソースプロジェクトとして公開 |
| 想定ライフサイクル | 長期運用（10年以上） | VB6レガシーシステムの延命が目的 |

> **この前提があるから、以下の選択をした**という流れで各設計判断を記載します。

## 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| --- | --- | --- | --- |
| アーキテクチャスタイル | 独自設計 / .NET互換 / Win32薄ラッパー | .NET Framework名前空間互換ライブラリアーキテクチャ | VB6と.NET間のデータ互換性確保、学習コスト削減 |
| レイヤー分割 | フラット / 2層 / 4層 | 4層（Public API / Domain / Core / Type Definition） | 責務分離と依存方向の明確化 |
| モジュール分割 | 機能別 / 技術別 / ドメイン別 | 名前空間（ドメイン）別 | .NET互換性、凝集度の高さ |
| DB選定 | N/A | 使用しない | ライブラリであり、データ永続化は利用者の責務 |
| キャッシュ選定 | なし / インメモリ | アプリケーション内インメモリキャッシュ | 静的データ（CultureTable等）の高速アクセス |
| MQ選定 | N/A | 使用しない | ライブラリであり、非同期処理は限定的 |

---

## 設計判断と根拠

### 1. アーキテクチャスタイル選定

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 独自設計ライブラリ | VB6に最適化した独自API | VB6らしい使い勝手 | .NET互換性なし、学習コスト高 |
| .NET Framework名前空間互換 | .NETのAPI/構造を再実装 | 互換性高、学習コスト低 | 実装工数大、完全互換は困難 |
| Win32 API薄ラッパー | Win32 APIを直接呼び出し | 高速、軽量 | 低レベル、使いにくい |
| COMコンポーネント集合 | 個別機能を別DLLで提供 | 柔軟、軽量 | 統一性なし、依存管理複雑 |

#### 採用した方針

**.NET Framework名前空間互換ライブラリアーキテクチャ**

VBCorLibは、.NET Frameworkの名前空間構造（System, System.Collections, System.IO, System.Text, System.Security.Cryptography等）を忠実に再現したモジュラーライブラリアーキテクチャを採用しています。

#### 選択理由

**背景にある業務課題**:
- VB6アプリケーションと.NETアプリケーションが混在する環境で、データ形式の不整合が発生しやすい
- VB6開発者の減少により、新規開発者の学習コストが問題
- VB6標準機能では最新セキュリティ要件を満たせない

**このアーキテクチャによる解決アプローチ**:
- .NETと同一のクラス名・メソッドシグネチャを採用することで、同一の暗号化データ、シリアライズデータを相互に読み書き可能
- .NET Framework経験者がドキュメントを参照せずともAPIを直感的に利解可能
- .NETで実績のある設計パターン（Factory、Template Method、Decorator等）をそのまま適用することで、保守性・拡張性を確保

**期待される業務改善効果**:
- システム間データ連携の不具合削減（推定50%以上）
- 新規開発者のオンボーディング期間短縮（従来比1/3程度と推測）
- セキュリティ監査対応工数の削減

#### 不採用とした選択肢の理由

- **独自設計ライブラリ**: VB6に特化したAPIを設計した場合、.NET互換性が失われ、データ形式の不整合リスクが残る。また、VB6固有の知識が必要となり、人材確保が困難。
- **Win32 API薄ラッパー**: 低レベルAPIのままでは開発生産性が低く、エラーハンドリングやリソース管理が煩雑。.NET互換のデータ形式保証も困難。
- **COMコンポーネント集合**: 各コンポーネント間の一貫性が保てず、バージョン管理やデプロイが複雑化。学習コストも高くなる。

---

### 2. レイヤー分割

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| フラット（分割なし） | 全クラスが同一レベル | シンプル | 依存関係が複雑化 |
| 2層（Public / Internal） | 公開APIと内部実装を分離 | 最小限の分離 | 責務が曖昧 |
| 4層（API / Domain / Core / Type） | 詳細な責務分離 | 依存方向明確、テスタブル | 設計複雑、クラス増加 |

#### 採用した方針

**4層構造（Public API Layer / Domain Layer / Core/Infrastructure Layer / Type Definition Layer）**

#### レイヤー構成の詳細

| レイヤー | 責務 | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- |
| Public API Layer | 外部公開インターフェース、コンストラクタ関数（Constructors.cls, PublicFunctions.cls, StaticClasses.cls） | 省略（直接Domain呼び出し） | VB6のGlobal-Multiuse機能を活用し、NewXxx()形式の使いやすいAPI提供 |
| Domain Layer | ドメイン固有ロジック（System.*, System.Collections.*, System.IO.*等の各クラス） | 機能別分割 | .NET名前空間に対応させ、ドメイン凝集度を最大化 |
| Core/Infrastructure Layer | 基盤機能、Win32 API連携（Cor/, Microsoft.Win32/, 各種.basモジュール） | Domain内に含める | OS依存部分を分離し、将来の移植性確保、テスト容易性向上 |
| Type Definition Layer | インターフェース定義（IObject, IEnumerable, IComparer等） | 各クラスに分散 | インターフェース駆動設計による疎結合、.NET互換のポリモーフィズム実現 |

#### 選択理由

**背景にある業務課題**:
- VB6では「クラス間の依存関係管理」が曖昧になりがちで、保守性が低下する傾向
- 長期運用において、特定クラスの変更が広範囲に波及するリスク

**このレイヤー構成による解決アプローチ**:
- 依存の方向性を「上位→下位」に限定し、逆依存を禁止することで変更影響を局所化
- インターフェース層を独立させ、具象クラス間の直接依存を回避

**期待される業務改善効果**:
- バグ修正・機能追加時の影響範囲特定が容易
- 新規機能追加時の既存機能への影響最小化

#### 不採用とした選択肢の理由

- **フラット（分割なし）**: VB6のデフォルトに近いが、300以上のクラスがフラットに並ぶと依存関係が複雑化し、保守不能になる。
- **2層（Public / Internal）**: VB6ではFriend修飾子による内部公開が限定的であり、適切な分離が困難。

---

### 3. モジュール分割

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 機能別 | 機能（暗号化、IO、コレクション）で分割 | 直感的 | .NET互換性低下 |
| 技術別 | Win32ラッパー、ユーティリティ等で分割 | 技術者にわかりやすい | ドメイン凝集度低下 |
| 名前空間（ドメイン）別 | .NET名前空間に対応 | .NET互換、凝集度高 | VB6慣習と異なる |

#### 採用した方針

**名前空間（ドメイン）別モジュール分割**

ディレクトリ構造を.NET Frameworkの名前空間に対応させ、各ドメインが高い凝集度を持つよう設計されています。

#### モジュール構成の詳細

| モジュール | 責務 | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- |
| System | 基本型、例外、ユーティリティ | 別名（Core等） | .NET互換、直感的 |
| System.Collections | コレクションフレームワーク | Collections単独 | .NET互換 |
| System.IO | ファイル・ストリーム操作 | IO / FileSystem分割 | .NET互換、凝集度維持 |
| System.Text | テキストエンコーディング | TextUtils等 | .NET互換 |
| System.Security.Cryptography | 暗号化・ハッシュ | Crypto / Security分割 | .NET互換 |
| System.Globalization | 国際化・ローカライゼーション | I18n等 | .NET互換 |
| Microsoft.Win32 | Windowsレジストリ、ネイティブAPI | Win32 / Native等 | .NET互換 |

#### 選択理由

**背景にある業務課題**:
- VB6開発者と.NET開発者の混在チームでの開発・保守
- .NETシステムとの機能対応付けが困難

**この分割による解決アプローチ**:
- .NET Frameworkドキュメントがそのまま参考になる
- 機能追加時に適切なモジュールへの配置が自明

**期待される業務改善効果**:
- 開発者間コミュニケーションコスト削減
- ドキュメント参照効率の向上

#### 不採用とした選択肢の理由

- **機能別**: VB6らしい分割だが、.NET互換性が低下し、本来の目的である「データ互換性確保」が困難になる。
- **技術別**: 開発者視点では理解しやすいが、業務機能との対応が不明確になり、要件トレーサビリティが低下する。

---

### 4. データベース選定

#### 採用した方針

**使用しない（N/A）**

VBCorLibはクラスライブラリであり、データ永続化は利用者アプリケーションの責務として位置づけています。

#### 選択理由

- **ライブラリの独立性**: データベース依存を持たせると、利用者環境への制約が増加
- **責務の明確化**: 永続化はアプリケーション層の責務であり、ライブラリが関与すべきではない
- **.NET Framework設計に準拠**: .NET Frameworkの基本クラスライブラリ（BCL）もデータベース非依存

---

### 5. キャッシュ選定

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| なし | キャッシュを使用しない | シンプル | 繰り返しアクセス時のパフォーマンス低下 |
| アプリケーション内キャッシュ | モジュール変数で静的データ保持 | 追加インフラ不要、高速 | メモリ消費増加 |
| 外部キャッシュ（Redis等） | 外部キャッシュサーバー使用 | スケーラブル | 依存増加、VB6からのアクセス困難 |

#### 採用した方針

**アプリケーション内インメモリキャッシュ**

CultureTable、EncodingTable等の静的参照データをモジュールレベル変数としてキャッシュし、アプリケーションライフタイム中は再読み込みを回避しています。

#### キャッシュ構成

| 用途 | キャッシュ | TTL | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- | --- |
| CultureTable | モジュール変数（Singleton） | アプリケーションライフタイム | 毎回ロード | 国際化データは不変、頻繁に参照されるため |
| EncodingTable | モジュール変数（Singleton） | アプリケーションライフタイム | 毎回ロード | エンコーディングデータは不変 |
| 暗号化コンテキスト | CryptoAPI ハンドル保持 | オブジェクトライフタイム | 毎回生成 | CryptoAPI初期化コスト回避 |

#### 選択理由

**背景にある業務課題**:
- 国際化対応（CultureInfo参照）や暗号化処理が頻繁に行われるアプリケーションではパフォーマンスが重要
- VB6環境では外部キャッシュへのアクセスが困難

**このキャッシュ構成による解決アプローチ**:
- 初回アクセス時のみデータをロードし、以降はメモリ内データを参照
- VB6の制約内で実現可能な最適化

**期待される業務改善効果**:
- 国際化処理、暗号化処理のレスポンス時間短縮
- システムリソース（CryptoAPIコンテキスト）の効率的利用

#### 不採用とした選択肢の理由

- **なし**: 繰り返し処理でパフォーマンス低下が顕著になる。特にCultureInfo参照やEncoding変換は高頻度で使用される。
- **外部キャッシュ**: VB6からRedis等へのアクセスは複雑であり、導入コストに見合わない。

---

### 6. メッセージキュー選定

#### 採用した方針

**使用しない（N/A）**

VBCorLibはクラスライブラリであり、非同期処理・メッセージングは限定的なサポート（Stream.BeginRead/BeginWrite等）に留めています。

#### 選択理由

- **VB6の制約**: VB6のシングルスレッドモデルでは本格的な非同期処理が困難
- **ライブラリの責務**: メッセージングはアプリケーションアーキテクチャの責務
- **シンプルさの維持**: 不要な複雑性を排除

---

### 7. フレームワーク選定

#### 想定される選択肢（言語・フレームワーク）

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| VB6 + 独自フレームワーク | VB6で独自の基盤を構築 | 完全なコントロール | 開発工数大、保守コスト高 |
| VB6 + Win32 API直接呼び出し | Win32 APIを直接使用 | 高速、軽量 | 低レベル、エラー処理困難 |
| VB6 + .NET互換設計パターン | .NETの設計パターンをVB6で再現 | 学習コスト低、互換性高 | VB6の制約内での実装努力 |

#### 採用した方針

**VB6 + .NET互換設計パターン**

VB6言語を使用しつつ、.NET Frameworkで採用されている設計パターン（Factory Method、Template Method、Decorator、Interface Segregation等）を可能な限り再現しています。

#### 選択理由

**技術選定の根拠となるコード証拠**:

- **Factory Methodパターン**: `Constructors.cls`がGlobal-Multiuseとして定義され、`NewArrayList()`, `NewFileStream()`等のファクトリ関数を提供（CorLib.vbp 8行目参照）
- **Template Methodパターン**: `HashAlgorithmBase.cls`, `SymmetricAlgorithmBase.cls`が抽象基底クラスとして機能し、具象クラス（SHA1Managed, RijndaelManaged等）が継承
- **Decoratorパターン**: `CryptoStream.cls`が`Stream`をラップし、透過的な暗号化/復号機能を提供
- **Interface Segregationパターン**: `IEnumerable`, `ICollection`, `IList`を分離定義（IEnumerable.cls参照）

**業務観点でのメリット**:
- .NET開発者がVB6コードを理解しやすい
- 将来の.NET移行時にアーキテクチャ知識が継承可能
- 単体テストが書きやすい構造

#### 不採用とした選択肢の理由

- **独自フレームワーク**: 学習コストが高く、.NET互換性も保証されない。
- **Win32 API直接呼び出し**: 低レベルすぎて開発生産性が低く、エラーハンドリングが煩雑。

---

### 8. 横断的関心事の実装方式

#### 認証・認可

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| ライブラリ提供 | 認証・認可機能をライブラリで提供 | 利便性 | アプリケーション依存性が高い |
| 提供しない | 暗号化等の基盤機能のみ提供 | シンプル、柔軟 | 利用者実装が必要 |

**採用した方針**: 提供しない
**選択理由**: 認証・認可はアプリケーション固有の要件であり、ライブラリが関与すべきではない。VBCorLibは暗号化（Rijndael, RSA等）やハッシュ（SHA系, HMAC系）等の基盤機能を提供し、認証・認可の実装を支援する。

#### ロギング

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 構造化ログ | JSON等の構造化形式 | 分析容易 | VB6での実装困難 |
| デバッグ出力 | Debug.Print, Console.WriteLine | シンプル、標準的 | 本番環境での利用制限 |

**採用した方針**: デバッグ出力（Debug.Print, Console.WriteLine）
**選択理由**: VB6環境では構造化ログの実装が困難。開発・デバッグ時にはVB6 IDE即時ウィンドウへのDebug.Print、コンソールアプリケーションではConsole.WriteLineを使用。本番環境でのロギングはアプリケーション層の責務。

#### エラーハンドリング

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| VB6標準（On Error） | VB6標準のエラー処理 | VB6開発者に馴染み深い | 構造化されていない |
| .NET互換例外（Throw/Catch） | 例外オブジェクトを使用 | 構造化、.NET互換 | VB6では自然ではない |
| ハイブリッド | 両者をブリッジ | 柔軟性 | 学習コスト |

**採用した方針**: ハイブリッド（VB6のOn ErrorとException階層をブリッジ）
**選択理由**:

VBCorLibでは、.NET互換の例外階層（Exception -> SystemException -> ArgumentException等）を定義しつつ、VB6の`On Error`構文との互換性を維持するブリッジ機構を提供しています（ExceptionManagement.bas参照）。

```vb
' Throw関数で例外オブジェクトを投げる
Throw Cor.NewArgumentNullException("param", "Parameter cannot be null")

' Catch関数で例外を捕捉
If Catch(Ex, Err) Then
    ' 例外処理
End If
```

これにより、VB6開発者は従来の`On Error`パターンを維持しながら、.NET互換の構造化例外処理を利用できます。

---

## 将来の拡張性考慮

### 想定される変更

1. **新しい暗号化アルゴリズムの追加**
   - 対応方針: `SymmetricAlgorithm`または`HashAlgorithm`インターフェースを実装した新クラスを追加
   - 影響範囲: Core/Infrastructure Layerへの追加のみ、既存コードへの影響なし

2. **新しい文字エンコーディングの追加**
   - 対応方針: `Encoding`抽象クラスを継承した新エンコーディングクラスを追加
   - 影響範囲: System.Text名前空間への追加のみ

3. **64ビット対応（将来のVBAアップデート時）**
   - 対応方針: Win32 API宣言を条件付きコンパイルで分岐
   - 影響範囲: Microsoft.Win32/Win32Native.basの修正

4. **.NET Core/5+との互換性拡張**
   - 対応方針: 新しい.NET APIに対応したクラス追加
   - 影響範囲: 新規モジュール追加、既存モジュールへの影響最小

### スケールアウト時の対応

VBCorLibはシングルプロセスのクラスライブラリであり、水平スケールアウトは対象外です。ただし、以下の対応により大規模利用をサポートします。

- **パフォーマンス最適化**: 頻繁に使用されるクラス（ArrayList, Hashtable等）の内部実装最適化
- **メモリ効率**: 大容量ファイル処理（2GB超対応FileStream）、ストリーミング処理対応
- **並行利用**: スレッドセーフではないが、別インスタンスでの並行利用は可能

---

## 備考

### VB6特有の制約と対応

1. **シングルスレッドモデル**: VB6は基本的にシングルスレッドであり、非同期処理は限定的（BeginRead/BeginWrite等）。本格的な並行処理はVB6の制約外。

2. **継承の制限**: VB6では真のクラス継承がないため、インターフェース実装と委譲パターンで擬似的な継承階層を実現。

3. **ジェネリクス非対応**: VB6にはジェネリクスがないため、Variant型を使用した汎用コレクションで対応。

### 品質保証

- **テストフレームワーク**: SimplyVBUnitを使用した網羅的な単体テストを整備
- **ドキュメンテーション**: XMLスタイルのVBDocコメントとDocIncludesフォルダによる詳細ドキュメント
- **ライセンス**: MIT License（一部のファイルはGNU Library General Public License）

### .NET移行時の考慮事項

VBCorLibの最終目標は「VB6からの安全な撤退」を可能にすることです。.NET移行時には以下のメリットがあります。

- API互換性により、多くのコードが軽微な修正で移行可能
- 設計パターンの知識がそのまま適用可能
- データ形式互換性により、移行中の並行稼働が容易
