# インフラ設計意図書

## 概要

本ドキュメントは、VBCorLib（Visual Basic 6向け.NETフレームワーク互換クラスライブラリ）のインフラ構成に関する設計意図を記載したものです。VBCorLibはサーバーサイドアプリケーションではなく、クライアントPC上で動作するCOMコンポーネント（ActiveX DLL）であるため、従来のクラウドベースWebシステムとは根本的に異なるインフラ設計アプローチが採用されています。

---

## 業務要件との関連（なぜこのインフラ構成が必要か）

### 対応する業務要件
| 業務要件ID | 業務要件名 | インフラに求められる要件 |
| --- | --- | --- |
| BR-001 | VB6アプリケーションの.NET互換機能提供 | VB6ランタイム環境で安定稼働するCOMコンポーネントとして配布可能であること |
| BR-002 | レガシーシステムとの共存 | Windows XP以降のクライアントPCで動作し、既存VB6アプリケーションと統合できること |
| BR-003 | オフライン環境での動作 | サーバー接続なしでクライアント単体で全機能が利用できること |
| BR-004 | 長期保守・運用 | GitHubを通じたソース管理・配布により、継続的なメンテナンスが可能であること |
| BR-005 | 容易な配布・インストール | Inno Setupによる自動インストーラーで、技術者以外でも導入できること |

### 業務観点でのインフラ要件

#### 可用性・信頼性への業務要求
VBCorLibを利用するVB6アプリケーションは、企業の基幹業務システムやレガシーシステムとして長期間運用されることが想定されます。そのため、サーバー障害の影響を受けず、クライアント単体で安定稼働することが最優先要件となります。

| 項目 | 業務要求 | 根拠 |
| --- | --- | --- |
| 許容ダウンタイム | クライアント障害時のみ影響（サーバー依存なし） | クライアントサイドライブラリのため、サーバー障害の影響を受けない設計が求められる |
| 稼働時間帯 | 24時間365日（クライアントPC稼働時） | 業務時間外でもバッチ処理等で使用される可能性があるため |
| 災害時の業務継続 | ローカル環境で継続可能 | ネットワーク障害時もクライアント単体で業務継続できることが重要 |

#### 性能・処理能力への業務要求
暗号化処理、大規模データ操作、BigInteger演算など、計算負荷の高い処理をクライアントPC上で高速に実行する必要があります。

| 項目 | 業務要求 | 根拠 |
| --- | --- | --- |
| 応答時間 | クライアントPCスペック依存（通常1秒以内） | VB6アプリケーションのUI応答性を損なわないことが求められる |
| 同時利用者数 | N/A（クライアント単体動作） | 各クライアントが独立して動作するため、同時接続の概念がない |
| ピーク時処理量 | クライアントPCリソース上限まで | メモリマップドファイルや2GB超ファイル操作など、大規模データ処理に対応 |

#### コスト・予算への業務制約
オープンソースプロジェクトとして無償で提供されているため、インフラコストは最小化されています。

| 項目 | 制約 | 根拠 |
| --- | --- | --- |
| 月額インフラ予算 | 0円（GitHub無償プランで運用） | オープンソースプロジェクトとして持続可能な運用を実現 |
| 初期投資上限 | 0円（開発者ボランティアベース） | コミュニティ主導の開発・メンテナンス |
| コスト最適化の優先度 | 高 | 無償で提供し続けるため、運用コストを最小限に抑える必要がある |

### 検討した構成案（業務観点）

| 案 | 概要 | メリット | デメリット | 業務適合性 |
| --- | --- | --- | --- | --- |
| A | サーバーベースライブラリ（DLL配布+API連携） | 一元管理可能、機能更新が容易 | ネットワーク依存、サーバーコスト発生、VB6との親和性低い | 低 |
| B | NuGet/パッケージマネージャー配布 | 依存関係管理が容易 | VB6はNuGet非対応、.NET専用 | 低 |
| C（採用） | COMコンポーネント+インストーラー配布 | VB6ネイティブ対応、オフライン動作、ランタイム依存なし | 手動更新が必要 | 高 |
| D | .NETへの完全移行推奨 | 最新技術活用可能 | 既存VB6資産の廃棄が必要、移行コスト膨大 | 対象外 |

### 選択理由（業務観点）

1. **業務要件との適合性**: VBCorLibの主目的は「VB6アプリケーションに.NET互換機能を提供すること」です。COMコンポーネントとしての配布は、VB6 IDEからの参照設定という標準的なワークフローに完全に適合し、開発者の学習コストを最小化します。

2. **業務継続性の観点**: クライアントサイド完結型のアーキテクチャにより、サーバー障害・ネットワーク障害の影響を完全に排除しています。レガシーシステムを支えるVB6アプリケーションにとって、この独立性は業務継続上極めて重要です。

3. **将来の業務拡大への対応**: 新機能追加はDLLの更新で対応可能であり、Inno Setupインストーラーによる配布で既存環境への影響を最小限に抑えながらアップグレードできます。

4. **費用対効果（ROI）**: GitHubの無償ホスティングを活用することで、インフラコストゼロで世界中の開発者にライブラリを提供できています。VB6からの.NET移行が困難な企業にとって、無償でこれほど包括的な.NET互換機能を得られることの価値は計り知れません。

---

## 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| --- | --- | --- | --- |
| プラットフォーム選定 | クラウド(AWS/GCP/Azure) / オンプレミス / クライアントサイド | クライアントサイド（Windows COM） | VB6との親和性、オフライン動作要件 |
| 配布・ホスティング | 自社サーバー / CDN / GitHub | GitHub + GitHub Pages | 無償、信頼性高、バージョン管理統合 |
| インストール方式 | MSI / ClickOnce / Inno Setup / 手動 | Inno Setup | 軽量、カスタマイズ性、VB6テンプレート配置対応 |
| ドキュメント公開 | 自社サイト / GitHub Pages / ReadTheDocs | GitHub Pages + kellyethridge.com | 静的サイト生成、低運用負荷 |

---

## 設計判断と根拠

### 1. プラットフォーム選定（クラウド vs クライアントサイド）

#### 背景にあると推察される業務課題

1990年代から2000年代前半にかけて開発されたVB6アプリケーションは、多くの企業で基幹システムとして現在も稼働しています。しかし、VB6は.NETフレームワークの豊富なクラスライブラリを直接利用できず、現代的な暗号化、Unicode対応、高度なコレクション操作などの機能実装に多大な工数を要していました。この技術的ギャップが、VB6システムの保守・拡張における深刻なボトルネックとなっていたと推察されます。

#### 業務課題に対するアプローチ方針

「VB6アプリケーションの動作環境（クライアントPC）上で、.NET互換のクラスライブラリを直接利用可能にする」というアプローチが採用されています。これにより、VB6開発者は馴染みのあるCOM参照設定の仕組みを使い、.NET風のAPIを呼び出せるようになります。

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| クラウドAPI提供 | AWSやAzureでAPIサーバーを運用し、VB6からREST/SOAP呼び出し | 一元管理、機能更新容易 | ネットワーク依存、レイテンシ、コスト発生、VB6でのHTTP実装複雑 |
| .NETラッパーDLL | .NETで実装しCOM Interopで公開 | .NETの全機能利用可能 | .NETランタイム必須、配布複雑化、バージョン競合リスク |
| ネイティブVB6 COM | VB6でネイティブ実装したCOMコンポーネント | VB6環境のみで完結、軽量、高互換性 | 実装工数大、機能限定の可能性 |
| サードパーティ製品購入 | 商用ライブラリの採用 | 即座に利用可能、サポートあり | ライセンス費用、ベンダーロックイン |

#### 採用した方針
**ネイティブVB6 COMコンポーネント（クライアントサイド完結型）**

#### 選択理由

1. **VB6エコシステムとの完全な親和性**: VB6 IDEから「参照設定」で追加するだけで利用開始でき、既存の開発ワークフローを一切変更する必要がありません。

2. **追加ランタイム不要**: .NETランタイムや追加フレームワークのインストールが不要であり、配布・展開が極めてシンプルです。これは、IT部門のリソースが限られた中小企業や、厳格な変更管理プロセスを持つ大企業にとって大きな利点です。

3. **オフライン動作の完全保証**: クラウドAPIと異なり、インターネット接続の有無に関わらず全機能が利用可能です。製造現場や物流倉庫など、ネットワーク環境が不安定な場所でも安定稼働します。

4. **セキュリティリスクの最小化**: データを外部サーバーに送信しないため、機密データを扱うアプリケーションでも安心して暗号化機能などを利用できます。

#### 不採用とした選択肢の理由
- **クラウドAPI提供**: ネットワーク依存が発生し、VB6からのHTTP通信実装が複雑。レイテンシによるユーザー体験劣化と運用コストが課題。
- **.NETラッパーDLL**: .NETランタイムが必須となり、既存のVB6のみ環境への導入障壁が高い。バージョン競合（DLL Hell）のリスクも増大。
- **サードパーティ製品購入**: オープンソースとして広く無償提供するという方針と相反。

---

### 2. ソースコード管理・配布インフラ選定

#### 背景にあると推察される業務課題

オープンソースプロジェクトとして世界中の開発者にライブラリを提供しつつ、継続的なメンテナンスを行うには、堅牢なソースコード管理と効率的な配布インフラが不可欠です。自前でサーバーを運用するコストと手間を回避しつつ、信頼性の高いサービスを利用する必要がありました。

#### 業務課題に対するアプローチ方針

GitHubをソースコード管理・Issue管理・リリース配布のプラットフォームとして全面採用し、インフラ運用コストをゼロに抑えながらグローバルな配布を実現するアプローチが取られています。

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 自社サーバー運用 | 自前のGitサーバー・Webサーバー | 完全な制御 | 運用コスト、メンテナンス負荷、可用性確保が課題 |
| GitHub | Git SaaS | 無償、高可用性、CI/CD統合、コミュニティ形成 | ベンダー依存 |
| GitLab | Git SaaS/オンプレ | CI/CD内蔵、自己ホスト可能 | GitHub比でコミュニティ小さい |
| Bitbucket | Git SaaS | Atlassian統合 | オープンソースコミュニティ小さい |

#### 採用した方針
**GitHub（ソース管理・Issue管理・Releases配布・Pages）**

#### 選択理由

1. **ゼロコスト運用**: パブリックリポジトリは無料で、ストレージ・転送量・CI/CDも無償枠内で運用可能です。

2. **高い可用性と信頼性**: GitHubはMicrosoftが運営する大規模サービスであり、99.9%以上の可用性を提供します。自前運用では到達困難な信頼性を享受できます。

3. **オープンソースコミュニティの標準**: GitHubはオープンソース開発のデファクトスタンダードであり、コントリビューターの参加障壁が最も低いプラットフォームです。

4. **統合されたエコシステム**: Issues（バグ・機能要望管理）、Releases（バイナリ配布）、Pages（ドキュメントホスティング）が単一プラットフォームで完結し、管理効率が高い。

5. **Subversionサポート**: VB6開発者の中にはGitに不慣れな方も多いため、GitHubのSubversionチェックアウトサポートは重要な配慮です（README.mdに明記）。

#### 不採用とした選択肢の理由
- **自社サーバー運用**: 個人/小規模チームでの継続的な運用・保守が困難。コスト・労力が見合わない。
- **GitLab/Bitbucket**: オープンソースコミュニティでの認知度・参加しやすさでGitHubに劣る。

---

### 3. インストーラー・配布方式選定

#### 背景にあると推察される業務課題

COMコンポーネントの配布には、DLLの適切なフォルダへの配置とWindowsレジストリへのCOM登録が必要です。これを手動で行わせると、技術的な知識のないエンドユーザーにとってハードルが高く、導入失敗や誤操作によるシステム障害のリスクがあります。

#### 業務課題に対するアプローチ方針

Inno Setupによる自動インストーラーを提供し、インストール・アンインストール・VB6テンプレート配置までを自動化するアプローチが採用されています。

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 手動配置（regsvr32） | ユーザーがコマンドで登録 | 配布ファイル最小 | 技術知識必要、ミス発生率高 |
| MSI（Windows Installer） | Microsoft標準インストーラー | 標準、グループポリシー配布可能 | 作成ツール高額、学習コスト高 |
| Inno Setup | 無償インストーラービルダー | 無償、軽量、スクリプトでカスタマイズ自在 | 企業展開機能が限定的 |
| NSIS | 無償インストーラービルダー | 無償、高いカスタマイズ性 | スクリプト複雑 |
| ClickOnce | .NET自動更新 | 自動更新対応 | .NET専用、VB6非対応 |

#### 採用した方針
**Inno Setup（InstallScript.iss）**

#### 配布内容と設計意図

| コンポーネント | インストール先 | 設計意図 |
| --- | --- | --- |
| VBCorLib3.dll | `{sys}`（SysWOW64） | システムフォルダ配置で全アプリケーションから参照可能。regserverフラグでCOM登録自動化 |
| VB6テンプレート | VB6テンプレートディレクトリ | 新規クラス作成時にVBCorLibパターンを即座に利用可能 |
| サンプルプロジェクト | `{app}\Examples`（オプション） | 学習リソースとして任意インストール可能 |
| ドキュメント | `{app}` | readme.txt、LICENSE.txtを配置 |

#### 選択理由

1. **無償かつ高機能**: Inno Setupは商用利用も無償で、MSI並みの機能を提供します。オープンソースプロジェクトの理念に合致。

2. **VB6テンプレート統合**: `{code:GetClassTemplatesFolder}`によるカスタム関数で、VB6のテンプレートディレクトリを自動検出し、クラステンプレートを配置できます。これはMSIでは難しいカスタマイズ。

3. **COM登録の自動化**: `Flags: regserver`指定で、DLLのCOM登録をインストーラーが自動実行します。

4. **軽量な配布ファイル**: LZMA圧縮（`Compression=lzma; SolidCompression=yes`）により、約1.6MBのDLLを含む配布パッケージが極めてコンパクトになります。

5. **多言語対応の基盤**: 現在は英語のみですが、Inno Setupの言語ファイル機構により、将来的な多言語化が容易です。

#### 不採用とした選択肢の理由
- **手動配置**: エンドユーザーにregsvr32を実行させるのは非現実的。
- **MSI**: 作成ツールが高額で、オープンソースプロジェクトには不向き。
- **ClickOnce**: VB6 COMコンポーネントでは使用不可。

---

### 4. ドキュメントインフラ選定

#### 背景にあると推察される業務課題

ライブラリを効果的に活用してもらうには、包括的なAPIドキュメントとサンプルコードが必要です。しかし、ドキュメント専用サーバーの運用は追加コストとなり、更新の手間も発生します。

#### 業務課題に対するアプローチ方針

GitHub Pagesによる静的サイトホスティングと、kellyethridge.comでのCHMファイル公開を組み合わせ、オンライン・オフライン両方のドキュメント利用を可能にしています。

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 自社Webサーバー | ドキュメント専用サーバー | 完全制御 | 運用コスト・手間 |
| GitHub Pages | 静的サイトホスティング | 無償、GitHub統合、自動デプロイ | 動的機能なし |
| ReadTheDocs | ドキュメント特化SaaS | バージョン管理、検索機能 | Sphinx/MkDocs前提 |
| Confluence | Wiki SaaS | リッチな編集機能 | 有償、オープンソース向きでない |

#### 採用した方針
**GitHub Pages（jekyll-theme-cayman）+ kellyethridge.com**

#### 選択理由

1. **ゼロコスト**: GitHub Pagesは無料でSSL対応の静的サイトをホスティング可能です。

2. **シンプルな設定**: `_config.yml`に`theme: jekyll-theme-cayman`の1行のみで、見栄えの良いドキュメントサイトを構築できます。

3. **オフラインドキュメント対応**: CHMファイル（Windows Help形式）を提供し、ネットワークがない環境でもドキュメント参照可能です。これはVB6開発者の作業環境（オフライン開発機など）を考慮した配慮と推察されます。

4. **二重の冗長性**: GitHub Pagesに加えてkellyethridge.comでもドキュメントを公開し、どちらかが利用不能でも参照可能にしています。

#### 不採用とした選択肢の理由
- **自社Webサーバー**: 継続的な運用・保守が困難。
- **ReadTheDocs**: VB6向けドキュメントをSphinx/MkDocsで生成する仕組みがない。

---

### 5. クライアント環境要件

#### 設計意図
Windows XP以降のできるだけ広範なWindows環境で動作することを重視しています。

| 要件項目 | 設定値 | 設計意図 |
| --- | --- | --- |
| OS | Windows NT系（XP以降推奨） | レガシーシステムとの互換性を最大限確保 |
| ランタイム | VB6ランタイム（MSVBVM60.DLL） | VB6アプリケーションが動作する環境であれば追加インストール不要 |
| アーキテクチャ | 32ビット / WoW64 | 64ビットOSでもWoW64経由で動作可能 |
| 特別な要件 | Windows CryptoAPI | 暗号化機能はOS標準APIを利用し、追加依存を回避 |

#### 選択理由

1. **最大限の互換性**: バージョン3.2ではCompareStringOrdinal API依存を除去し、Windows XPとの互換性を維持しています（Issue #93）。これは、古いOSで稼働し続けるレガシーシステムへの配慮です。

2. **追加依存の最小化**: 暗号化機能はOpenSSLなどの外部ライブラリではなく、Windows標準のCryptoAPIを使用します。これにより、追加DLLの配布が不要になり、配布・管理が簡素化されます。

---

### 6. 品質保証インフラ

#### 設計意図
クラウドCI/CDではなく、開発者のローカル環境でテストを実行する方式が採用されています。

| 項目 | 内容 | 設計意図 |
| --- | --- | --- |
| テストフレームワーク | VB6ネイティブテスト | VB6環境でテストを完結させ、外部ツール依存を回避 |
| テストプロジェクト | CorLib.Tests.vbp | 単一のテストプロジェクトで全機能をカバー |
| サンプルプロジェクト | Examples配下 | 実際の使用例を通じた動作確認と学習リソース |

#### 選択理由

1. **VB6環境完結**: GitHub ActionsなどのクラウドCI/CDは、VB6の開発環境（Visual Basic 6.0 IDE）を実行する環境構築が極めて困難です。そのため、開発者のローカル環境でテストを実行する方式が現実的な選択となります。

2. **Fakesプロジェクト**: `Source/Fakes/Fakes.vbp`の存在から、依存関係のモック化によるユニットテストが行われていることが推察されます。

---

### 7. バックアップ・災害復旧

#### 設計意図
Gitの分散型特性を活用し、追加のバックアップインフラなしで高い耐障害性を実現しています。

| 対象 | バックアップ方式 | 設計意図 |
| --- | --- | --- |
| ソースコード | Git（GitHub） | 全コミット履歴を保持、複数開発者のローカルクローンが暗黙的なバックアップに |
| リリースバイナリ | GitHub Releases | 各バージョンのバイナリを永続的に保存 |
| ドキュメント | GitHub Pages + kellyethridge.com | 二重化による冗長性 |

#### 選択理由

1. **Git分散型の活用**: リポジトリをクローンした全開発者が、完全なソース履歴のコピーを保持します。これは追加コストなしで達成される自然な冗長化です。

2. **GitHub Releasesの永続性**: 過去のすべてのリリースバイナリがGitHub上に保存され、ユーザーは任意のバージョンをいつでもダウンロード可能です。

---

### 8. セキュリティ設計

#### 設計意図
クライアントサイドライブラリとして、データを外部に送信しない設計でプライバシーを保護しています。

| セキュリティ観点 | 対応方針 | 設計意図 |
| --- | --- | --- |
| データ送信 | なし（完全ローカル動作） | ユーザーデータの漏洩リスクを排除 |
| 暗号化機能 | Windows CryptoAPI利用 | OS標準の検証済みセキュリティ機能を活用 |
| コード署名 | なし（検討事項） | 将来的な配布信頼性向上の余地あり |

#### 選択理由

1. **プライバシー重視**: 暗号化対象のデータや処理内容が外部サーバーに一切送信されないため、機密データを扱うアプリケーションでも安心して利用可能です。

2. **検証済みAPIの活用**: 暗号化機能はWindows CryptoAPIを使用し、自前実装による脆弱性リスクを回避しています。Rijndael、RSA、DES、TripleDES、各種ハッシュアルゴリズムなど、広範な暗号機能を提供しています。

---

### 9. コスト最適化

#### 設計意図
オープンソースプロジェクトとして持続可能な運用を実現するため、インフラコストをゼロに抑えています。

| コスト項目 | 方針 | 削減効果 |
| --- | --- | --- |
| ソース管理 | GitHub無償プラン | 月額0円 |
| CI/CD | ローカル実行 | 月額0円 |
| ドキュメントホスティング | GitHub Pages | 月額0円 |
| バイナリ配布 | GitHub Releases | 月額0円 |
| ドメイン | kellyethridge.com（個人所有） | 年間数千円程度（推定） |

#### 選択理由

1. **持続可能性**: 商用利用でも無償で提供し続けるため、固定のインフラ費用を発生させない設計が不可欠です。

2. **コミュニティ依存**: 開発・メンテナンスは開発者Kelly Ethridge氏を中心としたボランティアベースで行われており、金銭的な持ち出しを最小化することで長期継続が可能になっています。

---

## 将来の拡張性考慮

### 想定される変更

1. **64ビットネイティブ対応**: 現在は32ビットCOMコンポーネントとしてWoW64で動作していますが、将来的に64ビットネイティブビルドの需要が生じる可能性があります。VB6自体が32ビットのみのため、実現には根本的なアーキテクチャ変更（VBA 64ビット対応など別プラットフォームへの移植）が必要になります。

2. **GitHub Actions CI/CD導入**: 現在はローカルでのテスト実行ですが、Windows環境でVB6テストを自動実行するGitHub Actionsワークフローの構築により、品質保証の自動化が可能になる余地があります。ただし、VB6 IDEのライセンス・入手性が課題となります。

3. **コード署名の導入**: 配布時の信頼性向上のため、インストーラーおよびDLLへのコード署名の導入が検討される可能性があります。

### マルチリージョン対応
本プロジェクトはクライアントサイドライブラリであり、サーバーサイドのマルチリージョン展開は適用されません。GitHubのグローバルCDNにより、世界中どこからでも高速にソースコードおよびリリースバイナリにアクセス可能です。

---

## 備考

- VBCorLibはバージョン4.0が最新であり、300以上のクラスを含む包括的な.NET互換クラスライブラリです。
- 暗号化機能（Rijndael、RSA、DES、TripleDES、各種ハッシュアルゴリズム）はWindows CryptoAPIを利用しており、外部依存なしで動作します。
- Unicode APIサポートにより、32KB以上の長いファイル名に対応し、2GB超のファイル操作も可能です。
- BigInteger、Int64などの拡張数値型をサポートし、VB6の数値型の制限を超えた計算が可能です。
- VBCultures.nlpファイルはリソースとしてDLLに内包され、単一ファイルでの配布を実現しています。
- Git設定（`core.autocrlf false`）の要件は、VB6 IDEがCRLF改行を要求するためです。GitHubのSubversionサポートを利用するユーザーへの配慮が文書化されています。
