# バッチ設計意図書

## 概要

本書は、VBCorLibプロジェクトの各バッチが**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各バッチが存在する業務上の理由**を明らかにすることを目的とし、併せて技術設計判断の根拠も記載する。

VBCorLibは、.NET Frameworkの機能をVB6環境で利用可能にするオープンソースライブラリである。本プロジェクトのバッチ処理は、主にソフトウェアのビルド・配布プロセスを自動化するために存在する。

## 1. ドメイン概要

> ドメイン概要（業界・業種、主なステークホルダー、システムの位置づけ、ドメイン共通課題等）は **[機能設計意図書](./機能設計意図書.md)** を参照してください。
>
> **注記**: 機能設計意図書が未作成の場合は、本章に補足を記載する。

### 補足：プロジェクト概要

- **プロジェクト種別**: オープンソースライブラリ開発
- **対象技術**: VB6（Visual Basic 6.0）向けCOMライブラリ
- **主な利用者**: VB6で開発を行うエンジニア、レガシーシステムの保守担当者
- **プロジェクトの位置づけ**: .NET Framework相当の機能（コレクション、IO、暗号化、テキスト処理等）をVB6環境で利用可能にする

## 2. 業務プロセス別のバッチと想定価値

### 業務プロセス1: ライブラリビルドプロセス

#### プロセス概要

**業務フロー**

1. 開発者がタイプライブラリ定義（ODLファイル）を編集
2. ODLファイルからタイプライブラリ（TLB）ファイルを生成
3. TLBファイルをWindowsシステムに登録
4. VBCorLib3.dllをビルド（VB6 IDEで実施）

**関係者**

- VBCorLibの開発者・コントリビューター
- VB6環境で開発を行うエンジニア（ライブラリ利用者として間接的に関係）

**発生頻度**

- タイプライブラリ定義変更時（新しい型定義の追加、構造体・列挙型・インターフェースの変更時）
- 推定：月1〜5回程度（活発な開発時）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| COMコンポーネントのビルド手順の複雑さ | mktyplib、regtlibといった専門ツールの実行順序を覚える必要がある |
| 手動操作によるミス | コマンド引数の誤り、実行順序の間違いによりビルド失敗が発生 |
| 環境依存性 | 各開発者の環境で同一のビルド結果を再現する必要がある |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**

- 手動でコマンドを実行する場合：1回あたり約5〜10分
- コマンド引数を確認・入力する時間、エラー発生時の原因調査時間を含む
- 月5回の変更で月25〜50分、年間5〜10時間程度

**品質リスク**

- コマンド引数の誤りによるビルド失敗
- 実行順序の誤り（TLB生成前に登録を試みる等）
- 生成されるTLBファイルの一貫性が保証されない

**知識の属人化リスク**

- mktyplib、regtlibの使用方法が特定の開発者にしか分からなくなる
- 新規コントリビューターの参入障壁が高くなる

#### 本業務をシステム化することの想定効果

**工数削減効果**

- 1回のビルド：手動5〜10分 → バッチ実行数秒（ほぼ自動）
- 年間5〜10時間 → 年間1時間未満（約90%削減）

**品質向上効果**

- コマンド引数・実行順序が固定化され、ミスが防止される
- エラーハンドリング（errorlevelチェック）により、失敗時は処理が停止
- 再現性の高いビルドプロセスが確立される

**知識共有効果**

- バッチファイルがビルド手順のドキュメントとして機能
- 新規開発者でもバッチを実行するだけでビルド可能

#### 主な関連バッチと業務インパクト

| バッチ名 | 何をするバッチか | バッチがない場合の運用工数 | バッチがあることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| Build.bat | ODLファイルからTLBファイルを生成し、Windowsシステムに登録 | 月5回×10分=年10時間 | 月5回×数秒=年1時間未満（約9時間削減） |

---

### 業務プロセス2: リリース・配布プロセス

#### プロセス概要

**業務フロー**

1. VBCorLib3.dllのビルド完了を確認
2. サンプルプロジェクト、ドキュメント、テンプレートを準備
3. インストーラーを生成
4. インストーラーをリリース（GitHub等で配布）

**関係者**

- VBCorLibの開発者・メンテナー（インストーラー作成者）
- VBCorLibの利用者（エンドユーザー）

**発生頻度**

- 新バージョンリリース時
- 推定：年2〜4回程度（メジャー・マイナーリリース）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 配布ファイルの多さと複雑さ | DLL、サンプルプロジェクト（複数）、テンプレート（複数）、ドキュメントなど多数のファイルを適切に配置する必要がある |
| COMコンポーネント登録の複雑さ | エンドユーザーがDLLをシステムに登録する手順は複雑で、技術的知識を要する |
| VB6テンプレートディレクトリの特定 | VB6のテンプレートディレクトリはOSやインストール状況により異なり、手動特定は困難 |
| 手動インストールによるミス | ファイルの配置場所の誤り、COM登録の失敗などが発生しやすい |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**

- 手動配布パッケージ作成：1回あたり2〜4時間
  - 必要ファイルの収集・整理：30分〜1時間
  - ZIPファイル等のパッケージ作成：30分
  - インストール手順書の作成・更新：1〜2時間
- 年4回のリリースで年8〜16時間

**エンドユーザー側のコスト**

- 手動インストール：1ユーザーあたり30分〜1時間
- COM登録の手順理解・実行：15〜30分
- トラブルシューティング（失敗時）：1〜2時間

**品質リスク**

- 配布漏れ（必要なファイルがパッケージに含まれない）
- バージョン不整合（古いファイルが混在）
- インストール手順の誤りによるユーザー環境の破損

**サポートコスト**

- インストール失敗に関する問い合わせ対応
- 環境依存の問題への個別対応

#### 本業務をシステム化することの想定効果

**開発者側の工数削減効果**

- インストーラー作成：手動2〜4時間 → Inno Setup実行数分
- 年4回のリリースで年8〜16時間 → 年1時間未満（約95%削減）

**エンドユーザー側の効果**

- インストール：手動30分〜1時間 → ウィザード形式で5分程度
- COM登録：手動15〜30分 → 自動（意識不要）
- VB6テンプレート配置：手動15〜30分 → 自動（ディレクトリ自動検出）

**品質向上効果**

- 配布内容がスクリプトで定義され、一貫性が保証される
- アンインストール機能により、クリーンな削除が可能
- インストールエラー時のロールバック機能

**サポートコスト削減**

- 標準的なインストーラーUIによりユーザーの混乱を防止
- インストールログによる問題調査の効率化

#### 主な関連バッチと業務インパクト

| バッチ名 | 何をするバッチか | バッチがない場合の運用工数 | バッチがあることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| InstallScript.iss | VBCorLibのWindowsインストーラー（exe）を生成。DLL登録、ファイル配置、テンプレートインストール、ショートカット作成を自動化 | 年4回×4時間=年16時間（開発者）+ユーザー1人あたり1時間 | 年4回×数分=年1時間未満（約15時間削減）+ユーザー側も大幅削減 |

---

## 3. 各バッチ想定意図サマリー

| バッチ名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 | リアルタイム処理を選ばなかった理由 |
| -------- | ------------------ | ---------------- | ------------------ | -------------------------- | ---------------------------------- |
| Build.bat | COMタイプライブラリのビルド手順の複雑さ・属人化 | 中（年10時間程度） | mktyplib、regtlibコマンドを順次実行しエラーチェック | コマンド引数・実行順序のミスが発生しやすく、知識の属人化を防ぐため | バッチ処理の性質（一括コンパイル）であり、リアルタイム性の要件がないため |
| InstallScript.iss | 配布ファイルの多さ、COMコンポーネント登録の複雑さ、手動インストールの困難さ | 高（年16時間以上+ユーザー側負担） | Inno Setupによるインストーラー自動生成、COM登録・テンプレート配置の自動化 | 多数のファイルを正確に配置しCOM登録を行う作業は手動では複雑すぎ、エンドユーザーには技術的ハードルが高いため | インストーラー生成・配布は一括処理の性質であり、リリース時に実行すれば十分なため |

---

## 4. 技術設計判断と根拠

### 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| -------- | ---------------- | ------------ | ------------ |
| 実行基盤 | cron / ジョブスケジューラ / 手動実行 | 手動実行（開発者がコマンドラインまたはIDEから実行） | 開発プロセスの一部であり、自動スケジュール実行の必要がないため |
| リカバリ戦略 | 全件再実行 / 差分再実行 / 手動復旧 | 全件再実行（バッチを再度実行） | 処理時間が短く（数秒〜数分）、全件再実行で問題ないため |
| 並列処理 | シングル / マルチスレッド / 分散 | シングルスレッド（順次処理） | 処理量が少なく、並列化のメリットがないため |
| 冪等性 | 必須 / 一部 / 不要 | 実質的に冪等（同じ入力から同じ出力を生成） | 同一ODL/ソースから同一TLB/インストーラーが生成される設計 |

---

### 4-1. バッチ実行基盤

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| cron | OS標準スケジューラ | シンプル、軽量 | 開発プロセスには不適切 |
| CI/CDパイプライン | GitHub Actions等 | 自動化、再現性 | 設定の複雑さ |
| 手動実行 | 開発者がコマンドラインから実行 | シンプル、即時実行 | 自動化なし |
| IDEから実行 | Inno Setup IDEから実行 | GUI操作、エラー確認容易 | IDE必須 |

#### 採用した方針

手動実行（コマンドラインまたはIDE経由）

#### 選択理由

- 両バッチとも開発プロセスの一部であり、「タイプライブラリ定義変更時」「リリース時」という不定期なタイミングで実行される
- 自動スケジュール実行の必要性がなく、開発者の判断で実行するのが適切
- 処理時間が短いため、手動実行でも負担にならない

#### 不採用とした選択肢の理由

- **cron/ジョブスケジューラ**: 定期実行の必要性がないため不採用
- **CI/CDパイプライン**: オープンソースプロジェクトとして将来的に導入可能だが、現状の開発規模では過剰

---

### 4-2. 実行スケジュール設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 定期実行 | 固定間隔で実行 | 予測可能 | 無駄な実行あり |
| イベント駆動 | 変更検知時に実行 | 最適タイミング | 検知機構必要 |
| 手動実行 | 開発者の判断で実行 | シンプル、柔軟 | 自動化なし |

#### 採用した方針

手動実行（開発者の判断で必要時に実行）

#### スケジュール一覧

| バッチ | スケジュール | 他の選択肢 | 選択理由 |
| ------ | ------------ | ---------- | -------- |
| Build.bat | 手動（ODLファイル変更後） | Git hookでの自動実行 | 変更頻度が低く、開発者の判断で実行するのが適切 |
| InstallScript.iss | 手動（リリース時） | CI/CDでの自動ビルド | リリース判断は人間が行うため、手動実行が適切 |

#### 選択理由

- 開発プロセスの特性上、「変更があったら実行」というイベント駆動的な性質を持つ
- ただし、変更検知の自動化機構を導入するほどの頻度ではない
- 開発者が明示的に実行することで、意図しない実行を防止できる

---

### 4-3. リカバリ戦略

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 全件再実行 | 最初からやり直し | シンプル | 時間かかる |
| 差分再実行 | 失敗分のみ再実行 | 効率的 | 実装複雑 |
| 手動復旧 | 運用者が判断して復旧 | 柔軟 | 属人化リスク |

#### 採用した方針

全件再実行（エラー原因を修正後、バッチを再度実行）

#### リカバリパターン

| 失敗パターン | リカバリ方法 | 自動/手動 | 選択理由 |
| ------------ | ------------ | --------- | -------- |
| ODL構文エラー（Build.bat） | ODLファイルを修正後、Build.batを再実行 | 手動 | 構文エラーの自動修正は不可能 |
| 権限不足（regtlib） | 管理者権限で再実行 | 手動 | 権限昇格は手動判断が必要 |
| ファイル不在（InstallScript.iss） | 必要ファイルを準備後、再コンパイル | 手動 | ファイル準備は手動作業 |

#### 選択理由

- 両バッチとも処理時間が短い（数秒〜数十秒）ため、全件再実行のコストが低い
- エラーの原因は主に入力（ODLファイル、ソースファイル）の問題であり、自動リカバリは不適切
- Build.batはerrorlevelチェックでエラー検知し、pauseで停止する実装になっている

---

### 4-4. 並列処理設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| シングルスレッド | 順次処理 | シンプル、デバッグ容易 | 時間かかる |
| マルチスレッド | スレッド並列 | 高速 | 競合リスク |
| マルチプロセス | プロセス並列 | 分離性高い | リソース消費大 |

#### 採用した方針

シングルスレッド（順次処理）

#### 並列化対象

| バッチ | 並列度 | 分割単位 | 選択理由 |
| ------ | ------ | -------- | -------- |
| Build.bat | 1（シングル） | 該当なし | 処理対象が1ファイル（CorType.odl）のみ |
| InstallScript.iss | 1（シングル） | 該当なし | Inno Setupの仕様でシングルスレッド |

#### 選択理由

- Build.bat: 単一のODLファイルを処理するため、並列化の余地がない
- InstallScript.iss: Inno Setupコンパイラの仕様に依存。インストーラー生成は単一プロセスで実行
- 両バッチとも処理時間が十分に短く、並列化による高速化のメリットがない

---

### 4-5. 冪等性設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 完全冪等 | 何度実行しても同じ結果 | 安全、リトライ容易 | 実装複雑 |
| 条件付き冪等 | 特定条件下で冪等 | バランス | 条件理解必要 |
| 非冪等 | 実行ごとに結果変わりうる | シンプル | リトライ困難 |

#### 採用した方針

実質的に冪等（同じ入力から同じ出力を生成）

#### 冪等性確保方法

| バッチ | 方法 | 確認ポイント | 選択理由 |
| ------ | ---- | ------------ | -------- |
| Build.bat | 出力ファイル上書き | 同一ODLから同一TLBが生成されるか | コンパイラの決定論的動作に依存 |
| InstallScript.iss | 出力ファイル上書き | 同一ソースから同一インストーラーが生成されるか | Inno Setupの決定論的動作に依存 |

#### 選択理由

- 両バッチとも「入力ファイル → 出力ファイル」の変換処理であり、同じ入力からは同じ出力が生成される
- 出力ファイルは上書きされるため、複数回実行しても問題ない
- 明示的な冪等性保証機構は不要

---

### 4-6. チェックポイント/再開機能

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| チェックポイントなし | 常に最初から | シンプル | 長時間バッチで非効率 |
| 行単位チェックポイント | 処理行ごとに保存 | きめ細かい | オーバーヘッド大 |
| ブロック単位 | N件ごとに保存 | バランス | 一部再処理発生 |
| フェーズ単位 | 処理フェーズごとに保存 | 粗粒度 | フェーズ内は再処理 |

#### 採用した方針

チェックポイントなし

#### チェックポイント設計

| バッチ | 保存間隔 | 保存内容 | 選択理由 |
| ------ | -------- | -------- | -------- |
| Build.bat | なし | なし | 処理時間が数秒のため不要 |
| InstallScript.iss | なし | なし | 処理時間が数十秒のため不要 |

#### 選択理由

- 両バッチとも処理時間が非常に短い（数秒〜数十秒）
- チェックポイント機構を導入するオーバーヘッドに見合わない
- 失敗時は最初から再実行しても問題ない

---

### 4-7. 排他制御

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| ロックファイル | ファイルで排他 | シンプル | 分散環境で不可 |
| DBロック | DBでロック管理 | 分散対応 | DB負荷 |
| OSレベルロック | ファイルハンドルで排他 | 自動 | 明示的でない |
| 排他制御なし | 同時実行許可 | シンプル | 競合リスク |

#### 採用した方針

OSレベルの暗黙的排他（ファイル使用中のロック）

#### 排他制御

| バッチ | 制御方式 | タイムアウト | 選択理由 |
| ------ | -------- | ------------ | -------- |
| Build.bat | ファイル書き込みロック | なし | TLBファイル書き込み時にOS がロック |
| InstallScript.iss | ファイル書き込みロック | なし | インストーラー書き込み時にOSがロック |

#### 選択理由

- 開発プロセスの一部であり、同時に複数の開発者が同じファイルをビルドすることは想定しにくい
- OSレベルのファイルロックにより、同一ファイルへの同時書き込みは防止される
- 明示的なロック機構は過剰

---

### 4-8. 監視・アラート

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| ログ監視のみ | ログから異常検知 | シンプル | リアルタイム性低い |
| メトリクス監視 | 処理時間・件数等を監視 | 定量的 | 設定必要 |
| ジョブ管理ツール | 専用ツールで監視 | 包括的 | コスト |
| 監視なし | 異常時にのみ確認 | コスト低 | 発見遅れ |

#### 採用した方針

監視なし（手動実行時に結果を確認）

#### 監視項目

| 項目 | 閾値 | アラート先 | 選択理由 |
| ---- | ---- | ---------- | -------- |
| 該当なし | - | - | 手動実行のため、実行者が結果を直接確認 |

#### 選択理由

- 両バッチとも手動実行であり、実行者がその場で結果を確認できる
- Build.batはエラー時にpauseで停止し、実行者に通知する
- 自動監視システムを導入するほどの運用頻度・重要度ではない

---

### 4-9. ログ・監査証跡

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 詳細ログ | 全処理をログ出力 | 追跡容易 | ログ量大 |
| サマリーログ | 開始/終了/件数のみ | 軽量 | 詳細不明 |
| 構造化ログ | JSON等で出力 | 解析容易 | 可読性低い |
| 最小限ログ | エラー時のみ出力 | シンプル | 正常時の確認困難 |

#### 採用した方針

最小限ログ（標準出力/エラー出力のみ）

#### ログ出力

| 種別 | 出力内容 | 保持期間 | 選択理由 |
| ---- | -------- | -------- | -------- |
| 標準出力 | コマンド実行結果（echo offで抑制） | 保持しない | ターミナルで即時確認 |
| エラー出力 | コンパイルエラー詳細 | 保持しない | ターミナルで即時確認 |
| インストールログ | Inno Setupの/LOGオプション使用時のみ | 任意 | トラブルシューティング用 |

#### 選択理由

- 開発プロセスの一部であり、ログファイルへの永続化は不要
- 実行者がターミナルで直接結果を確認する運用
- 必要に応じてInno Setupの/LOGオプションでログを取得可能

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **CI/CDパイプラインへの統合**
   - GitHub Actionsなどでビルド・リリースを自動化する場合、両バッチをパイプラインから呼び出す形で統合可能
   - バッチ自体の変更は最小限で済むよう、コマンドライン引数を受け付ける拡張を検討

2. **クロスプラットフォーム対応**
   - 現状はWindows専用だが、将来的にMono/Wine環境でのビルドを検討する場合、シェルスクリプト版の作成を検討
   - ただし、VB6自体がWindows専用のため、優先度は低い

3. **バージョン自動インクリメント**
   - インストーラーのバージョン（現在3.2.0）を自動的にインクリメントする機能の追加
   - Git tagやバージョンファイルからバージョン情報を取得する仕組みの検討

### バッチ追加時の指針

新バッチ追加時に従うべき設計指針：

1. **シンプルさの維持**: 開発プロセスの一部として、手動実行を前提とした簡潔な実装を心がける
2. **エラーハンドリング**: errorlevelチェックなど、失敗時の検知機構を必ず含める
3. **ドキュメント性**: バッチファイル自体がビルド/デプロイ手順のドキュメントとなるよう、コメントを適切に記載
4. **冪等性**: 複数回実行しても安全な設計とする

---

## 備考

- VBCorLibはオープンソースプロジェクト（MITライセンス）であり、GitHubで公開されている
- 現在のバージョンは3.2.0（InstallScript.issより）
- mktyplib は古いツール（Visual Studio 2005以前）だが、VB6環境との互換性のために使用されている
- タイプライブラリのUUID: {1705040f-4494-4ab3-8a97-a9f84820636d}
