# 帳票設計意図書

## 概要

本書は、VBCorLibにおける帳票機能の設計意図を記述することを目的とする。

**結論：VBCorLibは.NET FrameworkのCorLibをVB6で実装したユーティリティライブラリであり、帳票出力機能は設計上含まれていない。**

本プロジェクトの目的は、VB6環境に.NET互換の基盤機能（コレクション、暗号化、ファイルIO、テキストエンコーディング等）を提供することであり、帳票出力は提供機能の範囲外である。

## 1. ドメイン概要

> ドメイン概要（業界・業種、主なステークホルダー、システムの位置づけ、ドメイン共通課題等）は **機能設計意図書** を参照してください。
>
> ※注：本プロジェクトは機能設計意図書が未作成のため、以下に概要を記載する。

### VBCorLibの位置づけ

| 項目 | 説明 |
| --- | --- |
| プロジェクト種別 | オープンソースユーティリティライブラリ |
| 対象プラットフォーム | Visual Basic 6（VB6） |
| 主な目的 | .NET FrameworkのSystem名前空間クラスのVB6移植 |
| 想定利用者 | VB6アプリケーション開発者 |
| ライセンス | MIT License |

### 提供機能の範囲

VBCorLibは以下の基盤機能を提供する：

- **System.Collections**: ArrayList、Hashtable、Queue、Stack等のコレクション
- **System.Security.Cryptography**: 暗号化・ハッシュ・デジタル署名
- **System.IO**: ファイル・ストリーム操作
- **System.Text**: 文字列操作・エンコーディング
- **System.Globalization**: カルチャー・カレンダー
- **System.Resources**: リソースファイル管理
- **Microsoft.Win32**: レジストリ操作

## 2. 業務プロセス別の帳票と想定価値

### 帳票機能が存在しない理由

VBCorLibに帳票機能が含まれない理由は以下の通りと推測される：

#### 1. プロジェクトの設計思想

VBCorLibは.NET FrameworkのCorLib（mscorlib.dll）相当の機能をVB6に移植することを目的としている。

.NET FrameworkのCorLibには帳票出力機能は含まれておらず、帳票機能は別のライブラリ（例：System.Drawing、サードパーティ製品）で提供される設計となっている。VBCorLibもこの設計思想に従い、帳票機能を範囲外としていると推測される。

#### 2. VB6環境における帳票の代替手段

VB6環境では、以下の帳票ソリューションが一般的に利用される：

| 方法 | 説明 | 用途 |
| --- | --- | --- |
| Crystal Reports | サードパーティ製帳票ツール | 本格的な帳票システム |
| Data Report | VB6標準の帳票機能 | 簡易的な帳票 |
| ActiveReports | サードパーティ製帳票ツール | 高機能帳票 |
| Excel自動化 | OLE経由でExcel操作 | Excel形式の帳票 |
| Printer Object | VB6標準の印刷機能 | 直接印刷 |

VBCorLibはこれらの既存ソリューションと競合するのではなく、**基盤機能を補完する位置づけ**として設計されていると推測される。

#### 3. 機能の独立性

帳票機能は通常、以下の依存性を持つ：

- グラフィックスライブラリ（描画処理）
- プリンタドライバとの連携
- プレビュー機能のためのGUI
- テンプレートエンジン

これらはCorLib（基盤ライブラリ）の範囲を超えるため、VBCorLibの対象外とするのは合理的な設計判断と推測される。

### 帳票関連で利用可能なVBCorLib機能

VBCorLibは帳票機能を直接提供しないが、帳票システムの構築に活用できる基盤機能を提供している：

| 機能カテゴリ | 関連クラス | 帳票システムでの活用例 |
| --- | --- | --- |
| テキストエンコーディング | UTF8Encoding, Encoding | 帳票データの文字コード変換 |
| ファイル操作 | FileStream, StreamWriter | 帳票データのファイル出力 |
| 文字列操作 | StringBuilder, CorString | 帳票内容の文字列構築 |
| 日付フォーマット | CorDateTime, DateTimeFormatInfo | 帳票内の日付書式設定 |
| 数値フォーマット | NumberFormatInfo | 帳票内の数値・金額書式設定 |
| 暗号化 | CryptoStream, 各種暗号クラス | 帳票データの暗号化保存 |
| Base64変換 | ToBase64Transform | 帳票データのエンコード |

## 3. 各帳票想定意図サマリー

**該当なし**

帳票設計書が存在しないため、帳票個別の意図は記載対象外である。

| 帳票名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動作成を選ばなかった理由 | 画面表示で代用を選ばなかった理由 |
| --- | --- | --- | --- | --- | --- |
| （なし） | - | - | - | - | - |

## 4. 技術設計判断と根拠

### 設計意図サマリー

VBCorLibには帳票機能が含まれないため、帳票固有の技術設計判断は存在しない。

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| --- | --- | --- | --- |
| 帳票機能の有無 | 帳票機能を含む / 含まない | **含まない** | プロジェクトスコープが.NET CorLib相当機能に限定されているため |

---

### 4-1. 帳票機能を含まない理由

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 帳票機能を含む | VBCorLib内で帳票出力を実装 | ワンストップで利用可能 | 開発・保守コスト増大、既存ツールとの競合 |
| **帳票機能を含まない** | 帳票は外部ツールに委ねる | 本来の目的に集中、既存ツールと共存 | 帳票出力には別途ツールが必要 |

#### 採用した方針

**帳票機能を含まない**

#### 選択理由

1. **.NET CorLibとの整合性**: .NET FrameworkのCorLib（mscorlib.dll）に帳票機能が含まれないため、VBCorLibも同様の設計とすることで.NET互換性を維持
2. **既存ソリューションとの共存**: VB6環境にはCrystal Reports、Data Report等の成熟した帳票ソリューションが存在し、競合する必要がない
3. **開発リソースの集中**: 基盤機能の充実に開発リソースを集中することで、ライブラリとしての価値を最大化

#### 不採用とした選択肢の理由

- **帳票機能を含む**: プロジェクトの目的（.NET CorLib互換）から逸脱し、開発・保守コストが増大するため

---

### 4-2. 出力形式選択

**該当なし**（帳票機能が存在しないため）

---

### 4-3. 帳票生成ライブラリ/サービス

**該当なし**（帳票機能が存在しないため）

---

### 4-4. テンプレート管理

**該当なし**（帳票機能が存在しないため）

---

### 4-5. パフォーマンス対策

**該当なし**（帳票機能が存在しないため）

---

### 4-6. 非同期生成

**該当なし**（帳票機能が存在しないため）

---

### 4-7. 保存・配信方式

**該当なし**（帳票機能が存在しないため）

---

### 4-8. アクセス制御

**該当なし**（帳票機能が存在しないため）

---

### 4-9. 監査証跡

**該当なし**（帳票機能が存在しないため）

---

### 4-10. 多言語・地域化対応

**該当なし**（帳票機能が存在しないため）

ただし、VBCorLibは以下のグローバリゼーション機能を提供しており、帳票システム構築時の多言語対応に活用可能：

| 機能 | 関連クラス | 説明 |
| --- | --- | --- |
| カルチャー情報 | CultureInfo | ロケール設定の取得・適用 |
| 数値書式 | NumberFormatInfo | 通貨・数値の書式設定 |
| 日時書式 | DateTimeFormatInfo | 日付・時刻の書式設定 |
| 各種カレンダー | GregorianCalendar, JapaneseCalendar, HebrewCalendar等 | 各地域のカレンダー体系 |
| 文字エンコーディング | UTF8Encoding, Encoding等 | 各言語の文字コード対応 |

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **帳票機能の追加要望**: VBCorLibユーザーから帳票機能の要望があった場合でも、プロジェクトの設計思想（.NET CorLib互換）に基づき、別プロジェクトとして分離することが推奨される
2. **外部帳票ツールとの連携強化**: 帳票ツール（Crystal Reports等）との連携を容易にするヘルパークラスの追加は、プロジェクトスコープ内と判断される可能性がある

### 帳票追加時の指針

VBCorLibプロジェクトとして帳票機能を追加する場合の指針：

1. **別プロジェクトとして実装**: VBCorLib本体とは別のプロジェクト（例：VBCorLib.Reporting）として実装
2. **VBCorLib基盤機能の活用**: エンコーディング、ファイルIO、日付・数値フォーマット等のVBCorLib機能を活用
3. **既存ツールとの差別化**: Crystal Reports等との明確な差別化ポイントを定義

---

## 備考

- 本書は、帳票機能が存在しないプロジェクトに対して、その設計意図を明示するために作成されたものである
- VBCorLibの帳票機能に関する今後の方針変更があった場合は、本書を更新すること
- VBCorLibを利用した帳票システムを構築する場合は、「帳票関連で利用可能なVBCorLib機能」セクションを参照すること
