# 画面設計意図書

## 概要

本書は、VBCorLibプロジェクトの各画面が**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各画面が存在する業務上の理由**を明らかにすることを目的とし、併せて技術設計判断の根拠も記載する。

## 1. ドメイン概要

> **注記**: VBCorLibプロジェクトには機能設計意図書が存在しないため、本節でドメイン概要を記述する。

### 1.1 業界・業種

- **対象領域**: ソフトウェア開発（特にVisual Basic 6.0/VBA開発）
- **業種**: 開発者向けライブラリ・フレームワーク

### 1.2 ステークホルダー

| ステークホルダー | 役割 | 関心事 |
|----------------|------|--------|
| VB6/VBA開発者 | エンドユーザー | ライブラリの機能理解と学習 |
| ライブラリ開発者 | メンテナー | 品質保証とテスト実行 |

### 1.3 システムの位置づけ

VBCorLibは.NET FrameworkのクラスライブラリをVB6/VBAに移植したライブラリである。本プロジェクトの画面群は、ライブラリの機能をデモンストレーションするサンプルアプリケーション、およびライブラリの品質を保証するためのテストランナーで構成される。

### 1.4 ドメイン共通課題

| 課題 | 影響 |
|-----|------|
| VB6/VBAの標準機能の不足 | .NET Framework相当の機能がないため、開発者は自前で実装する必要がある |
| ライブラリの使用方法の学習コスト | APIだけでは使い方が分かりにくい |
| ライブラリの品質保証 | 回帰テストなしでは機能変更時に不具合が混入するリスクがある |

---

## 2. 業務プロセス別の画面と想定価値

### 業務プロセス1: ライブラリ機能のデモンストレーション

#### プロセス概要

**業務フロー**

開発者がVBCorLibの機能を学習 → サンプルアプリケーションを実行 → 機能の動作を確認 → 自身のプロジェクトに適用

**関係者**

- VB6/VBA開発者

**発生頻度**

随時（新機能の学習時、実装参考時）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
|---------|--------------------------------|
| APIドキュメントだけでは使い方が分かりにくい | 開発者が機能を誤解して使用する、または使用を諦める |
| コードサンプルなしでは実装パターンが分からない | 開発者が非効率な実装をしてしまう |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **学習コストの増大**: APIドキュメントのみでは、開発者1人あたり機能理解に1-2時間余分にかかると推測される
- **採用率の低下**: 使い方が分からないライブラリは採用されない
- **誤用リスク**: 正しい使用方法が示されないと、バグや非効率な実装が発生する

#### 本業務をシステム化することの想定効果

- **学習時間の短縮**: サンプルアプリケーションにより、機能理解が10-15分程度で可能になると推測される
- **正しい使用パターンの普及**: ベストプラクティスを示すことで、品質の高い実装を促進
- **ライブラリ採用率の向上**: 動作確認が容易になることで、採用の意思決定が促進される

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
|--------|--------------|--------------------------|-------------------------------|
| Static Classes Demo | Path、Environment、MathExt、TimeZoneの静的クラス機能デモ | ドキュメント読解で機能あたり30分×4=120分 | サンプル実行で機能あたり5分×4=20分（100分削減） |
| Simple Ticker (Event版) | Tickerオブジェクトのイベント通知機能デモ | ドキュメント+試行錯誤で60分 | サンプル実行+コード参照で15分（45分削減） |
| Simple Ticker 2 (Callback版) | Tickerオブジェクトのコールバック通知機能デモ | ドキュメント+試行錯誤で60分 | サンプル実行+コード参照で15分（45分削減） |
| Base64 Encoding | ファイルのBase64エンコード/デコード機能デモ | ドキュメント+試行錯誤で45分 | サンプル実行+コード参照で10分（35分削減） |
| Real-Time Decryption | CryptoStreamによるリアルタイム復号機能デモ | ドキュメント+試行錯誤で90分 | サンプル実行+コード参照で20分（70分削減） |
| File Encryption | 複数暗号アルゴリズムによるファイル暗号化デモ | ドキュメント+試行錯誤で120分 | サンプル実行+コード参照で25分（95分削減） |
| Hash Codes | 6種類のハッシュアルゴリズムのデモ | ドキュメント+試行錯誤で60分 | サンプル実行+コード参照で10分（50分削減） |
| Simple Registry Browser | Registry/RegistryKeyクラスのデモ | ドキュメント+試行錯誤で60分 | サンプル実行+コード参照で15分（45分削減） |
| Resource Browser | ResourceReader/WinResourceReaderクラスのデモ | ドキュメント+試行錯誤で75分 | サンプル実行+コード参照で15分（60分削減） |
| Simple INI File Browser | IniFileクラスのデモ | ドキュメント+試行錯誤で45分 | サンプル実行+コード参照で10分（35分削減） |
| Simple Browser 2 (Callback) | ファイルシステム操作+コールバックソートのデモ | ドキュメント+試行錯誤で90分 | サンプル実行+コード参照で20分（70分削減） |
| File Hex Viewer | MemoryMappedFileクラスのデモ | ドキュメント+試行錯誤で90分 | サンプル実行+コード参照で20分（70分削減） |
| Simple Browser (IComparer) | ファイルシステム操作+IComparerソートのデモ | ドキュメント+試行錯誤で90分 | サンプル実行+コード参照で20分（70分削減） |
| Number Formatting | CorString.Formatによる数値フォーマット機能デモ | ドキュメント+試行錯誤で60分 | サンプル実行+コード参照で10分（50分削減） |

---

### 業務プロセス2: ライブラリ品質保証

#### プロセス概要

**業務フロー**

ライブラリ開発・修正 → テストスイート実行 → 結果確認 → 不具合修正（必要時）→ リリース

**関係者**

- ライブラリ開発者

**発生頻度**

開発時随時、リリース前必須

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
|---------|--------------------------------|
| 回帰テストの手動実行は非現実的 | 100以上のテストケースを手動で確認することは時間的に困難 |
| テスト結果の一元管理 | 分散したテストでは全体の品質状況が把握できない |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **手動テスト工数**: 全機能を手動で確認する場合、1回あたり数時間〜1日を要すると推測される
- **不具合見逃しリスク**: 手動テストでは網羅性が担保できず、リリース後に不具合が発覚するリスク
- **開発効率の低下**: 変更のたびに手動テストが必要になると、開発サイクルが長期化

#### 本業務をシステム化することの想定効果

- **テスト実行時間の短縮**: 自動テストにより、数分で全テストケースを実行可能
- **品質の安定化**: 回帰テストにより、既存機能の破壊を早期検出
- **開発サイクルの高速化**: 迅速なフィードバックにより、開発効率が向上

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
|--------|--------------|--------------------------|-------------------------------|
| Simply VB Unit Runner | VBCorLibの全ユニットテスト実行・結果表示 | 手動テストで1回あたり4-8時間（推測） | 自動テストで5-15分（3時間以上削減） |

---

## 3. 各画面想定意図サマリー

| 画面名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 | Excel管理を選ばなかった理由 |
|--------|-------------------|------------------|-------------------|---------------------------|----------------------------|
| Simply VB Unit Runner | ライブラリ品質保証のための回帰テスト | 高（手動4-8時間/回） | 自動テストフレームワーク | 100以上のテストケースを手動で実行・確認することは現実的でないため | テストケースの実行はExcelでは代替できないため |
| Static Classes Demo | 静的クラス機能の使い方が分かりにくい | 中（120分/学習） | 機能デモと実行コードの提示 | 開発者がAPIドキュメントのみで理解するには時間がかかるため | 動作するサンプルコードはExcelでは提供できないため |
| Simple Ticker (Event版) | Tickerイベントの使い方が分かりにくい | 中（60分/学習） | イベント駆動パターンのデモ | VBのWithEventsパターンは実際のコードなしでは理解が難しいため | プログラミングパターンはExcelでは示せないため |
| Simple Ticker 2 (Callback版) | Tickerコールバックの使い方が分かりにくい | 中（60分/学習） | コールバック関数パターンのデモ | AddressOf演算子の使用方法は実際のコードで示すのが最適なため | プログラミングパターンはExcelでは示せないため |
| Base64 Encoding | Base64変換機能の使い方が分かりにくい | 中（45分/学習） | ファイル変換デモと処理時間計測 | 実際のファイル変換を体験することで理解が深まるため | ファイル変換機能はExcelでは代替できないため |
| Real-Time Decryption | CryptoStreamの使い方が分かりにくい | 高（90分/学習） | ストリーム暗号化のオンザフライ処理デモ | 暗号化ストリームの概念は実動作なしでは理解が困難なため | 暗号化処理はExcelでは代替できないため |
| File Encryption | 対称暗号の使い方とパラメータ選択が分かりにくい | 高（120分/学習） | 複数アルゴリズム・パラメータの選択と実行 | 4種類の暗号アルゴリズムとパラメータの効果は実行しないと分からないため | 暗号化処理はExcelでは代替できないため |
| Hash Codes | ハッシュアルゴリズムの使い方と出力の違いが分かりにくい | 中（60分/学習） | 6種類のハッシュ値のリアルタイム比較表示 | 各アルゴリズムの出力長の違いは実際に見ないと実感できないため | ハッシュ計算はExcelでは代替できないため |
| Simple Registry Browser | Registry/RegistryKeyクラスの使い方が分かりにくい | 中（60分/学習） | レジストリの階層表示とAPI使用例 | レジストリ操作は実際のシステムとの連携を見ないと理解が難しいため | レジストリアクセスはExcelでは代替できないため |
| Resource Browser | リソース読み込み機能の使い方が分かりにくい | 高（75分/学習） | RES/EXE/DLLからのリソース読み込みと表示 | リソース形式の違いとAPIの使い分けは実動作で示すのが最適なため | リソース読み込みはExcelでは代替できないため |
| Simple INI File Browser | IniFileクラスの使い方が分かりにくい | 中（45分/学習） | INIファイルのセクション・キー表示とソート | INIファイル操作とカスタムソートの組み合わせは実例で示すのが最適なため | INIファイル操作はExcelでは代替できないため |
| Simple Browser 2 (Callback) | ファイルシステム操作とコールバックソートの使い方が分かりにくい | 高（90分/学習） | エクスプローラー風UIとコールバックソート | コールバック関数によるソートは実動作するコードで示すのが最適なため | ファイルシステム操作はExcelでは代替できないため |
| File Hex Viewer | MemoryMappedFileの使い方が分かりにくい | 高（90分/学習） | 16進数ダンプ表示とメモリマップドファイル操作 | メモリマップドファイルの効率性は大容量ファイルで実感できるため | メモリマップ操作はExcelでは代替できないため |
| Simple Browser (IComparer) | ファイルシステム操作とIComparerの使い方が分かりにくい | 高（90分/学習） | エクスプローラー風UIとIComparerソート | IComparerインターフェース実装は実動作するコードで示すのが最適なため | ファイルシステム操作はExcelでは代替できないため |
| Number Formatting | CorString.Formatの書式指定子の使い方が分かりにくい | 中（60分/学習） | 7種類の書式指定子のリアルタイムプレビュー | 各書式指定子の出力の違いは実際に見ないと理解が難しいため | 動的なフォーマットプレビューはExcelでは困難なため |

---

## 4. 技術設計判断と根拠

### 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
|---------|-----------------|-------------|-------------|
| UIフレームワーク | VB6ネイティブ / 外部OCX | VB6ネイティブ + MSCOMCTL.OCX | ライブラリの対象プラットフォームに合わせるため |
| 状態管理 | グローバル変数 / モジュールレベル変数 | モジュールレベル変数（フォーム内） | シンプルなデモアプリのため、フォーム完結の設計 |
| コンポーネント設計 | フラット構造 / クラス分割 | フラット構造（単一フォーム） | 学習用サンプルとして、コードの見通しを良くするため |
| スタイリング | 標準コントロール / カスタム描画 | 標準コントロール | VB6標準機能のデモに注力するため |

---

### 4-1. UIフレームワーク/ライブラリ選定

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| VB6ネイティブ | VB6標準コントロールのみ | 追加依存なし | 機能制限あり |
| MSCOMCTL.OCX | Windows共通コントロール | TreeView/ListView等の高機能コントロール | OCXの配布が必要 |
| サードパーティOCX | 外部製コントロール | 高機能 | ライセンス、配布の複雑さ |

#### 採用した方針

VB6ネイティブ + MSCOMCTL.OCX（一部画面でCOMDLG32.OCX、RICHTX32.OCX併用）

#### 選択理由

- VBCorLibはVB6/VBA開発者向けライブラリであり、対象プラットフォームに合わせたUI技術を採用することで、サンプルコードの再利用性を高める
- MSCOMCTL.OCXはWindows標準で広く利用されており、ほとんどの環境で利用可能
- 学習用サンプルとして、VB6開発者が馴染みのある技術を使用

#### 不採用とした選択肢の理由

- **サードパーティOCX**: 配布の複雑さとライセンス問題を避けるため

---

### 4-2. 状態管理方式

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| グローバル変数 | 標準モジュールで管理 | どこからでもアクセス可能 | 状態の追跡が困難 |
| モジュールレベル変数 | フォーム/クラス内で管理 | カプセル化 | アクセス範囲制限 |
| Property Let/Get | プロパティとして公開 | インターフェース明確 | コード量増加 |

#### 採用した方針

モジュールレベル変数（フォーム内のPrivate変数）

#### 状態の分類

| 状態種別 | 管理場所 | 例 | 選択理由 |
|---------|---------|---|---------|
| UI状態 | フォームモジュール | mTicker, mCounter, mCipher | 各画面で完結するため |
| ソート設定 | 標準モジュール（一部） | SortColumn, SortOrder | コールバック関数からアクセスするため |
| アプリケーション状態 | フォームモジュール | mResources, mFile | 画面単位で管理するため |

#### 選択理由

- 各画面が独立したデモアプリケーションであり、画面間での状態共有が不要
- 学習用サンプルとして、シンプルな状態管理が望ましい
- フォーム内で完結することで、コードの理解が容易になる

#### 不採用とした選択肢の理由

- **グローバル変数**: 学習用サンプルとして推奨されない実装パターンとなるため

---

### 4-3. コンポーネント設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| フラット構造 | 単一フォームに全処理 | シンプル、一覧性 | 大規模で保守困難 |
| クラス分割 | 機能ごとにクラス作成 | 再利用性、テスト容易 | 複雑さ増加 |
| ユーザーコントロール | 共通UIをコントロール化 | UI再利用 | 開発コスト増 |

#### 採用した方針

フラット構造（単一フォームに全処理を実装）

#### コンポーネント階層

| 階層 | 責務 | 例 | 選択理由 |
|-----|-----|---|---------|
| フォーム | UI + ビジネスロジック | Form1.frm | 学習用サンプルとしてコードの見通しを良くするため |
| 補助クラス | カスタムロジック | FileComparer.cls, INIEntryComparer.cls | IComparer実装など、分離が必要な場合のみ |
| 標準モジュール | コールバック関数 | Module1.bas | AddressOf制約により必要な場合のみ |

#### 選択理由

- 学習用サンプルとして、1ファイルで全体の処理フローを把握できることが重要
- 各画面が小規模（1画面あたり100-400行程度）であり、分割の必要性が低い
- VBCorLibの使い方を示すことが目的であり、画面設計パターンの教示は目的外

#### 不採用とした選択肢の理由

- **クラス分割**: 学習時にファイル間を行き来する必要が生じ、理解の妨げになるため
- **ユーザーコントロール**: 画面間で共通のUIパターンがなく、作成コストに見合わないため

---

### 4-4. スタイリング方式

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| 標準コントロール | VB6/OCXのデフォルト外観 | 開発コスト低 | カスタマイズ性低 |
| カスタム描画 | PictureBox等で独自描画 | 自由なデザイン | 開発コスト高 |
| サードパーティスキン | 外部ライブラリでテーマ適用 | 統一的な外観 | 依存関係増加 |

#### 採用した方針

標準コントロール（VB6/OCXのデフォルト外観）

#### スタイル構成

| 種別 | 方式 | 用途 | 選択理由 |
|-----|-----|-----|---------|
| コントロール外観 | デフォルト | 全画面 | Windows標準の外観で統一 |
| フォント | 固定 | Courier 9.75pt（一部画面） | 等幅フォントが必要な16進数表示等 |
| サイズ変更 | 無効 | BorderStyle=Fixed Single | デモアプリとしてシンプルに保つため |

#### 選択理由

- VBCorLibの機能デモが目的であり、UIデザインは主要な関心事ではない
- Windows標準の外観により、VB6開発者が馴染みやすい
- 開発コストを抑え、ライブラリ本体の開発にリソースを集中

#### 不採用とした選択肢の理由

- **カスタム描画**: 開発コストが高く、デモアプリの目的に合わないため
- **サードパーティスキン**: 依存関係が増え、配布が複雑になるため

---

### 4-5. レスポンシブ対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| 固定サイズ | ウィンドウサイズ変更不可 | シンプル | 柔軟性なし |
| リサイズ対応 | ウィンドウサイズに追従 | 柔軟 | 実装コスト増 |
| 自動レイアウト | コントロール自動配置 | 最適化 | VB6では困難 |

#### 採用した方針

固定サイズ（BorderStyle = Fixed Single、MaxButton = False）

#### ブレークポイント

| 名称 | サイズ | 対象デバイス | 選択理由 |
|-----|-------|-------------|---------|
| 固定 | 画面ごとに設計 | デスクトップ | VB6の制約とデモアプリの性質上 |

#### 選択理由

- VB6のリサイズ対応は手動実装が必要で開発コストが高い
- デモアプリケーションとして、必要最低限のUI機能に留める
- 対象環境がデスクトップPCのみであり、レスポンシブ対応の必要性が低い

#### 不採用とした選択肢の理由

- **リサイズ対応**: 開発コストがデモアプリの目的に見合わないため

---

### 4-6. ルーティング設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| 単一フォーム | 1画面完結 | シンプル | 機能拡張困難 |
| MDI形式 | 複数フォームを親フォームで管理 | 複数文書対応 | 複雑 |
| SDI形式 | 各フォームが独立 | 分離 | 統一感なし |

#### 採用した方針

単一フォーム（各デモアプリが独立した単一フォーム）

#### ルート構造

| パターン | 用途 | 例 | 選択理由 |
|---------|-----|---|---------|
| 単一フォーム | デモアプリ | 全15画面 | 各デモが独立した機能を示すため |

#### 選択理由

- 各デモアプリケーションは特定のVBCorLib機能を示す独立した存在
- 画面間の遷移や連携が不要
- 開発者は興味のある機能のデモだけを実行できる

#### 不採用とした選択肢の理由

- **MDI形式**: デモアプリ間に関連性がなく、統合の必要性がないため

---

### 4-7. フォーム設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| ネイティブフォーム | VB6標準機能のみ | シンプル | バリデーション手動 |
| 独自フレームワーク | 入力検証・バインディング等 | 高機能 | 開発コスト |
| データバインド | データソースと連携 | 自動更新 | VB6では制限あり |

#### 採用した方針

ネイティブフォーム（VB6標準機能のみ）

#### フォーム構成

| 要素 | 実装方式 | 他の選択肢 | 選択理由 |
|-----|---------|-----------|---------|
| 状態管理 | モジュールレベル変数 | グローバル変数 | フォーム内で完結するため |
| バリデーション | On Error Resume Next | 事前検証 | デモアプリとしてシンプルに |
| エラー表示 | MsgBox | カスタムダイアログ | VB6標準機能 |

#### 選択理由

- VBCorLibの機能デモが目的であり、フォーム入力の高度な機能は不要
- 学習用サンプルとして、VB6標準のパターンを使用
- 入力は主に数値やファイル選択であり、複雑なバリデーションは不要

#### 不採用とした選択肢の理由

- **独自フレームワーク**: デモアプリの目的に対してオーバーエンジニアリングとなるため

---

### 4-8. データフェッチング

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| 同期処理 | 処理完了まで待機 | シンプル | UI凍結の可能性 |
| 非同期処理 | バックグラウンド実行 | UI応答性維持 | 複雑 |
| イベント駆動 | タイマー等で定期実行 | 柔軟 | 状態管理複雑 |

#### 採用した方針

同期処理（処理完了まで待機）

#### フェッチング戦略

| シナリオ | 方式 | キャッシュ | 選択理由 |
|---------|-----|----------|---------|
| ファイル読み込み | 同期 | なし | 小規模ファイルのデモのため |
| レジストリ読み込み | 同期 | Hashtable | 表示データのローカル保持 |
| ディレクトリ読み込み | 同期 | TreeViewノード | 階層表示のため |

#### 選択理由

- デモアプリケーションで扱うデータは小規模であり、同期処理で問題ない
- VB6での非同期処理は複雑であり、学習用サンプルとして不適切
- UI凍結が問題になる場合は、DoEventsで対応可能

#### 不採用とした選択肢の理由

- **非同期処理**: VB6での実装が複雑であり、学習用サンプルには不適切なため

---

### 4-9. アクセシビリティ対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
|-------|-----|---------|-----------|
| 標準機能 | OS/コントロールの標準機能 | 追加実装不要 | 限定的 |
| 拡張対応 | キーボード操作等の強化 | 使いやすさ向上 | 開発コスト |
| WCAG準拠 | アクセシビリティガイドライン準拠 | 幅広いユーザー対応 | 高コスト |

#### 採用した方針

標準機能（VB6/OCXの標準アクセシビリティ機能に依存）

#### 対応項目

| 項目 | 対応内容 | 選択理由 |
|-----|---------|---------|
| キーボード操作 | F5（テスト実行）、ESC（終了） | テストランナーの操作性向上 |
| タブ順序 | TabIndex設定 | 標準的なフォーム操作 |
| ラベル | 入力フィールドへのラベル表示 | 視認性確保 |

#### 選択理由

- VB6標準コントロールはOSレベルのアクセシビリティ機能をサポート
- 開発者向けデモアプリであり、特別なアクセシビリティ要件は想定されない
- 追加の対応コストは、デモアプリの目的に見合わない

#### 不採用とした選択肢の理由

- **WCAG準拠**: 開発者向けツールとして、費用対効果が低いため

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **新機能追加時のデモ画面追加**
   - 対応方針: 新しいVBCorLib機能に対応するデモ画面を独立したプロジェクトとして追加
   - 既存画面への影響なし

2. **テストケースの追加**
   - 対応方針: frmSimplyVBUnitRunner.frmのForm_Loadに新しいテストスイートを追加
   - Sim.NewTestSuiteパターンに従う

3. **VB.NET移植時のUI変更**
   - 対応方針: 各デモの処理ロジックはVBCorLib APIの使用例として再利用可能
   - UIはWindows Forms等に置き換え

### 画面追加時の指針

1. **独立性の維持**: 新画面は既存画面に依存しない独立したプロジェクトとして作成
2. **シンプルさの維持**: 1画面1機能の原則を守り、学習の障壁を低く保つ
3. **VBCorLib APIの使用例として**: 画面の目的はVBCorLib機能のデモであり、UIは最小限に
4. **画面設計書の作成**: 新画面には対応する画面設計書を作成

---

## 備考

- 本プロジェクトの画面群は、業務システムの画面ではなく、開発者向けのデモンストレーション・テストツールである
- 「業務インパクト」は、開発者の学習時間短縮効果として推算している
- VBCorLib 3.0以降への対応を想定しており、vbcorlib3.dllへの参照が必要
