# 通知設計書 10-Console.Beep

## 概要

本ドキュメントは、VBCorLibライブラリにおけるConsole.Beepビープ音通知の設計を定義する。Console.Beepメソッドはコンソールスピーカーを通じてビープ音を鳴らす音声通知機能を提供する。

### 本通知の処理概要

Console.Beepは、Windows Beep APIを使用してコンソールスピーカーから指定した周波数と時間のビープ音を発生させる通知機能である。ユーザーへの聴覚的なフィードバックや、処理完了・エラー発生の通知に使用される。

**業務上の目的・背景**：バッチ処理やコンソールアプリケーションにおいて、画面を常時監視していないユーザーに対して処理状況を通知する必要がある。Console.Beepは、処理完了、エラー発生、ユーザー入力待ちなどの状況を音で知らせることで、ユーザーの利便性を向上させる。異なる周波数や長さのビープ音を使い分けることで、複数の状態を区別して通知できる。

**通知の送信タイミング**：Console.Beepメソッドが呼び出された時点で即座にビープ音が発生する。指定した時間（Duration）が経過するまでメソッドはブロックされる。

**通知の受信者**：コンソールスピーカーを聴取可能な範囲にいるユーザー。

**通知内容の概要**：指定された周波数（Hz）で指定された時間（ミリ秒）のビープ音を発生させる。デフォルトは800Hz、200ms。

**期待されるアクション**：ユーザーはビープ音を聞いて処理状況を認識し、必要に応じてアプリケーションを確認する。

## 通知種別

コンソール通知（音声通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Duration時間ブロック） |
| 優先度 | 中（即時音声出力） |
| リトライ | 無 |

### 送信先決定ロジック

1. Console.Beep(Frequency, Duration)メソッド呼び出し
2. パラメータバリデーション
3. Windows Beep API呼び出し
4. Duration時間経過後に制御を返す

## 通知テンプレート

### Beepメソッドシグネチャ

| 項目 | 内容 |
|-----|------|
| メソッド名 | Beep |
| 引数1 | Optional ByVal Frequency As Long = 800（周波数Hz） |
| 引数2 | Optional ByVal Duration As Long = 200（時間ms） |
| 戻り値 | なし（Sub） |

### パラメータ制約

| パラメータ | 最小値 | 最大値 | デフォルト |
|-----------|-------|-------|----------|
| Frequency | 37 | 32767 | 800 |
| Duration | 1 | - | 200 |

### 使用例

```vb
Sub Main()
    ' デフォルトのビープ音（800Hz, 200ms）
    Console.Beep

    ' 高い音で長めのビープ（処理完了通知など）
    Console.Beep 1000, 500

    ' 低い音で短いビープ（警告音など）
    Console.Beep 440, 100

    ' 異なるパターンで通知（エラー音など）
    Console.Beep 200, 100
    Console.Beep 200, 100
    Console.Beep 200, 100
End Sub
```

### 用途別ビープパターン例

| 用途 | 周波数(Hz) | 時間(ms) | 回数 |
|-----|----------|---------|-----|
| 処理完了 | 1000 | 200 | 1 |
| 警告 | 440 | 100 | 2 |
| エラー | 200 | 150 | 3 |
| 入力待ち | 600 | 50 | 1 |

### 添付ファイル

該当なし（音声出力機能）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Frequency | 周波数（Hz） | メソッド引数 | No（デフォルト800） |
| Duration | 時間（ミリ秒） | メソッド引数 | No（デフォルト200） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メソッド呼び出し | Console.Beep() | パラメータが有効範囲内 | 即時ビープ音発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Frequency < 37 または > 32767 | ArgumentOutOfRangeException |
| Duration < 1 | ArgumentOutOfRangeException |
| Beep API失敗 | SystemException |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Console.Beep Frequency, Duration 呼び出し] --> B{Frequency 範囲チェック}
    B -->|範囲外| C[ArgumentOutOfRangeException]
    B -->|OK| D{Duration 範囲チェック}
    D -->|範囲外| E[ArgumentOutOfRangeException]
    D -->|OK| F[BeepAPI Frequency, Duration 呼び出し]
    F --> G{API成功?}
    G -->|No| H[SystemException]
    G -->|Yes| I[Duration時間待機]
    I --> J[制御を返す]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（音声出力のみ）

### 更新テーブル一覧

該当なし（音声出力のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ArgumentOutOfRangeException | Frequency < 37 または > 32767 | 有効範囲内の値を指定 |
| ArgumentOutOfRangeException | Duration < 1 | 正の値を指定 |
| SystemException | Beep API失敗 | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（連続呼び出し可能） |

### 配信時間帯

制限なし（ただし深夜のビープ音は控えめに）

## セキュリティ考慮事項

- ビープ音に機密情報は含まれない
- 過剰なビープ音はユーザーの迷惑になる可能性がある

## 備考

- Duration時間中はメソッドがブロックされる
- 同期呼び出しのため、長時間のDurationはUIをフリーズさせる
- コンソールスピーカーが無効な環境では音が出ない場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: API宣言を理解する

Windows Beep APIの宣言を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Console.cls | `Source/CorLib/System/Console.cls` | BeepAPI宣言（73行目） |

**読解のコツ**: BeepAPIはkernel32.dllのBeep関数をAlias指定で呼び出している。

#### Step 2: Beepメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Console.cls | `Source/CorLib/System/Console.cls` | Beep Sub（491-502行目） |

**主要処理フロー**:
- **492-493行目**: MinFrequency = 37, MaxFrequency = 32767 定数
- **494行目**: MinDuration = 1 定数
- **496-497行目**: Frequency範囲チェック
- **498-499行目**: Duration範囲チェック
- **500-501行目**: BeepAPI呼び出しとエラーチェック

#### Step 3: エラー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Console.cls | `Source/CorLib/System/Console.cls` | 例外スロー処理（496-501行目） |

**主要処理フロー**:
- **496-497行目**: ArgumentOutOfRange_BeepFrequency リソース文字列使用
- **498-499行目**: ArgumentOutOfRange_NeedPosNum リソース文字列使用
- **500-501行目**: GetMessage(Err.LastDllError) でシステムエラーメッセージ取得

### プログラム呼び出し階層図

```
[アプリケーション]
    │
    └─ Console.Beep(Frequency, Duration)
           │
           ├─ パラメータバリデーション
           │      │
           │      ├─ Frequency 37-32767 チェック
           │      │      │
           │      │      └─ 範囲外: ArgumentOutOfRangeException
           │      │
           │      └─ Duration >= 1 チェック
           │             │
           │             └─ 範囲外: ArgumentOutOfRangeException
           │
           └─ BeepAPI(Frequency, Duration)
                  │
                  ├─ 成功: ビープ音発生 + Duration待機
                  │
                  └─ 失敗: SystemException
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Frequency        ───▶ Console.Beep         ───▶ ビープ音
(Hz: 37-32767)         │                         (指定周波数)
                       │
Duration         ───▶ BeepAPI              ───▶ Duration時間
(ms: 1以上)            (kernel32.dll)            の音声出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Console.cls | `Source/CorLib/System/Console.cls` | ソース | Beepメソッド実装、API宣言 |
| Environment.cls | `Source/CorLib/System/Environment.cls` | ソース | リソース文字列取得 |
