# 通知設計書 11-ExceptionManagement.Throw

## 概要

本ドキュメントは、VBCorLibライブラリにおけるExceptionManagement.Throw通知機構の設計仕様を定義する。この通知は、例外発生時にシステム全体へエラー状態を伝播させるための中核的な機能である。

### 本通知の処理概要

ExceptionManagement.Throwは、VB6/VBAにおける構造化例外処理を実現するための例外発火（スロー）機構である。.NET Frameworkの例外処理モデルを模倣し、型付き例外オブジェクトをErr.Raiseを介してシステムに通知する。

**業務上の目的・背景**：VB6/VBAは本来、構造化例外処理をサポートしていないが、VBCorLibではExceptionクラス階層とThrow/Catch機構を導入することで、.NETライクな例外処理パターンを実現している。これにより、エラーの原因特定、例外の連鎖追跡、型による例外分類が可能となり、堅牢なエラーハンドリングを実現する。

**通知の送信タイミング**：例外オブジェクトがThrowプロシージャに渡された時点、または既にモジュールレベル変数mExceptionに格納された例外オブジェクトが存在する場合に、Err.Raiseを通じて例外が発火される。

**通知の受信者**：呼び出し元のプロシージャがOn Error文でエラーハンドラを設定している場合、そのハンドラが受信者となる。設定されていない場合は、コールスタックを遡り、最終的にVBランタイムがエラーダイアログを表示する。

**通知内容の概要**：例外オブジェクトに含まれるErrorNumber（VBエラー番号）、Source（発生元）、Message（エラーメッセージ）がErr.Raiseを介して通知される。例外オブジェクト自体はモジュールレベル変数に保持され、Catch関数で取得可能。

**期待されるアクション**：受信者は、On Error GoToで指定されたエラーハンドラにおいてCatch関数を呼び出し、例外オブジェクトを取得して適切なエラー処理を行う。必要に応じて例外を再スローするか、エラーから回復する。

## 通知種別

システム例外通知（VBランタイムのErr.Raiseを介したプログラマティック通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（即時処理） |
| リトライ | 無（例外は一度のみ発火） |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構により自動決定される。On Error GoToで設定された最寄りのエラーハンドラ、またはコールスタック上位のハンドラへ伝播する。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | Exception.ErrorNumber |
| 発生元 | Exception.Source |
| メッセージ | Exception.Message |

### 本文テンプレート

```
エラー番号: {ErrorNumber}
発生元: {Source}
メッセージ: {Message}
```

### 添付ファイル

該当なし（例外通知にはファイル添付機能なし）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ErrorNumber | VBエラー番号 | mException.ErrorNumber | Yes |
| Source | 例外発生元 | mException.Source | Yes |
| Message | エラーメッセージ | mException.Message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | Throw(Ex)呼び出し | ExがExceptionまたはErrObjectの場合 | 明示的な例外スロー |
| API呼び出し | ThrowOrErr(Ex)呼び出し | mExceptionがNothing以外、またはEx.Numberが0以外 | 条件付き例外スロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ExがNothing かつ mExceptionがNothing | スローする例外が存在しない場合は何も行わない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Throw呼び出し] --> B{Exが指定されているか}
    B -->|Yes| C{ExはExceptionか}
    B -->|No| D{mExceptionは存在するか}
    C -->|Yes| E[mException = Ex]
    C -->|No| F{ExはErrObjectか}
    F -->|Yes| G[ErrObjectからException生成]
    F -->|No| H[ArgumentException生成]
    G --> E
    H --> E
    D -->|Yes| I[Err.Raise実行]
    D -->|No| J[終了]
    E --> I
    I --> K[VBランタイムがエラーハンドラへ伝播]
    K --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内例外オブジェクトのみ使用）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ArgumentException | ExがException/ErrObject以外の型 | 新規ArgumentExceptionを生成してスロー |
| 伝播失敗 | On Errorハンドラ未設定 | VBランタイムがエラーダイアログ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（例外は発生時点で即座に通知される）

## セキュリティ考慮事項

- 例外メッセージには機密情報を含めないこと
- スタックトレース情報は内部デバッグ用途に限定
- 本番環境では詳細なエラー情報をユーザーに露出しない設計を推奨

## 備考

- ExceptionManagement.Throwは、VBCorLibの例外処理フレームワークの中核機能
- .NET FrameworkのSystem.Exception.Throwメソッドに相当
- モジュールレベル変数mExceptionにより、Throw後もCatch関数で例外オブジェクトを取得可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外オブジェクトの基底クラスと例外階層を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | 例外の基底ヘルパークラス。Message, Source, ErrorNumber, InnerExceptionなどのプロパティ管理 |

**読解のコツ**: ExceptionBaseはすべての例外クラスが内部的に使用するヘルパークラス。mBase変数として各例外クラスに保持される。

#### Step 2: エントリーポイントを理解する

処理の起点となるThrowプロシージャを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | Throw/Catch機構の実装。モジュールレベル変数mExceptionの管理 |

**主要処理フロー**:
1. **行55-71**: Throwプロシージャ - 例外オブジェクトの型判定とErr.Raise呼び出し
2. **行47-53**: ThrowOrErrプロシージャ - mException有無による条件分岐
3. **行31**: mException変数宣言 - 例外オブジェクトの一時保持
4. **行68-70**: Err.Raise実行部分 - VBランタイムへの例外通知

#### Step 3: 例外クラスの実装を理解する

Throwされる例外クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Exception.cls | `Source/CorLib/System/Exception.cls` | 基底Exceptionインターフェース |
| 3-2 | ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | 引数例外の実装例 |

**主要処理フロー**:
- **行118-120**: ErrorNumberプロパティ - VBエラー番号の取得
- **行164-172**: Messageプロパティ - エラーメッセージ生成

### プログラム呼び出し階層図

```
Throw(Ex)
    │
    ├─ TypeOf Ex Is Exception
    │      └─ mException = Ex
    │
    ├─ TypeOf Ex Is ErrObject
    │      └─ CreateException(...)
    │             └─ Cor.NewException(...)
    │
    └─ Err.Raise(mException.ErrorNumber, mException.Source, mException.Message)
           └─ VBランタイムエラーハンドラ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Exception/ErrObject ───▶ ExceptionManagement.Throw ───▶ Err.Raise
                               │
                               ├─ mException格納
                               │
                               └─ エラー番号/ソース/メッセージ抽出
                                        │
                                        ▼
                                   VBランタイム
                                        │
                                        ▼
                                   エラーハンドラ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | Throw/Catch機構の中核実装 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外の基底ヘルパークラス |
| Exception.cls | `Source/CorLib/System/Exception.cls` | ソース | 基底例外クラス |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | 例外コンストラクタ群 |
