# 通知設計書 13-ArgumentException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるArgumentException例外通知の設計仕様を定義する。この例外は、メソッドに渡された引数が不正な場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

ArgumentExceptionは、メソッドに渡された引数の値が不正である場合にスローされる例外クラスである。.NET FrameworkのSystem.ArgumentExceptionに相当し、引数に関連するエラーの基底例外として機能する。

**業務上の目的・背景**：メソッドの引数検証において、不正な引数が検出された場合に明確なエラーメッセージと問題のあるパラメータ名を提供することで、デバッグと問題解決を容易にする。単純なエラー番号のみでなく、構造化された例外情報により、呼び出し元は問題の原因を特定しやすくなる。

**通知の送信タイミング**：メソッドの引数検証処理において、引数の値が仕様に違反していることが検出された時点でスローされる。通常はメソッドの先頭部分で引数検証が行われ、検証失敗時に即座に例外が発火される。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラ、またはCatchArgument関数を使用した例外ハンドリングコードが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、問題のあるパラメータ名（ParamName）、VBエラー番号（ErrorNumber = vbInvalidProcedureCall = 5）、HResult（COR_E_ARGUMENT = &H5）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、例外情報を参照して不正な引数を修正するか、エラーメッセージをユーザーに表示する。ParamNameプロパティにより、どの引数が問題かを特定し、適切な対処を行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。On Error GoToで設定された最寄りのエラーハンドラへ伝播する。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbInvalidProcedureCall (5) |
| HResult | COR_E_ARGUMENT (&H5) |
| メッセージ形式 | {Message}\r\nParameter name: {ParamName} |

### 本文テンプレート

```
{エラーメッセージ}
Parameter name: {パラメータ名}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ParamName | 問題のパラメータ名 | mBase.GetValue("ParamName") | No |
| ErrorNumber | VBエラー番号 | vbInvalidProcedureCall (固定値) | Yes |
| HResult | HRESULTコード | COR_E_ARGUMENT (固定値) | Yes |
| Source | 発生元 | mBase.Source | No |
| InnerException | 原因例外 | mBase.InnerException | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | メソッド引数検証 | 引数値が不正 | 引数検証失敗時にスロー |
| API呼び出し | Throw(ArgumentException) | ArgumentExceptionインスタンス生成後 | 明示的な例外スロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 引数検証成功 | 正常な引数が渡された場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B[引数検証]
    B --> C{引数は有効か}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[Cor.NewArgumentException生成]
    E --> F[Init呼び出し - Message, ParamName, InnerException設定]
    F --> G[Throw ArgumentException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 引数不正 | 引数値がメソッド仕様に違反 | ParamNameを参照して該当引数を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージに機密情報（パスワード、個人情報等）を含めないこと
- ParamNameには変数名のみを設定し、値は含めない
- ログ出力時は引数値のマスキングを検討

## 備考

- ArgumentExceptionは引数例外の基底クラス
- ArgumentNullException、ArgumentOutOfRangeExceptionはArgumentExceptionを継承
- CatchArgument関数で型別捕捉が可能
- IObject、Exception、SystemExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ArgumentExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | クラス定義、mBase変数、プロパティ実装 |

**読解のコツ**: mBaseはExceptionBase型で、共通の例外プロパティを管理する。ParamNameはmBase.GetValue/SetValueで管理される。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewArgumentException関数 |
| 2-2 | ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **Constructors.cls 行131-134**: NewArgumentException - 新規インスタンス生成とInit呼び出し
2. **ArgumentException.cls 行241-243**: Class_InitProperties - mBase初期化
3. **ArgumentException.cls 行245-249**: Init - Message, ParamName, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | Message, ParamName, ErrorNumber, HResult |

**主要処理フロー**:
- **行84-86**: ParamNameプロパティ - mBase.GetValueで取得
- **行118-119**: HResultプロパティ - COR_E_ARGUMENT固定値
- **行126-128**: ErrorNumberプロパティ - vbInvalidProcedureCall固定値
- **行164-172**: Messageプロパティ - 基底メッセージ + ParamName付加

### プログラム呼び出し階層図

```
Cor.NewArgumentException(Message, ParamName, InnerException)
    │
    └─ New ArgumentException
           │
           ├─ Class_InitProperties()
           │      └─ Cor.NewExceptionBase(Me, App)
           │
           └─ Init(Message, ParamName, InnerException)
                  ├─ mBase.Message = Message
                  ├─ mBase.SetValue("ParamName", ParamName)
                  └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                      [処理]                        [出力]

Message ─────────────┐
                     │
ParamName ───────────┼──▶ ArgumentException.Init ──▶ mBase設定完了
                     │           │
InnerException ──────┘           │
                                 ▼
                          Throw ArgumentException
                                 │
                                 ▼
                          ExceptionManagement.Throw
                                 │
                                 ▼
                          Err.Raise(5, Source, FormattedMessage)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | ソース | 引数例外クラス本体 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewArgumentExceptionコンストラクタ |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | Throw/Catch機構 |
| ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | ソース | 派生例外クラス |
| ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | ソース | 派生例外クラス |
