# 通知設計書 14-ArgumentNullException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるArgumentNullException例外通知の設計仕様を定義する。この例外は、Null参照（Nothing）が不正な引数として渡された場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

ArgumentNullExceptionは、メソッドに渡されたオブジェクト参照がNothingである場合、または配列が初期化されていない場合にスローされる例外クラスである。ArgumentExceptionの派生クラスとして、Null参照に特化したエラー通知を提供する。

**業務上の目的・背景**：VB6/VBAではNull参照によるエラーは一般的に「オブジェクト変数またはWithブロック変数が設定されていません」（エラー91）として発生するが、ArgumentNullExceptionを使用することで、どの引数がNullであったかを明確に通知できる。これにより、デバッグ効率が向上し、問題の原因特定が容易になる。

**通知の送信タイミング**：メソッドの引数検証処理において、必須のオブジェクト参照がNothingであることが検出された時点、または必須の配列が未初期化であることが検出された時点でスローされる。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラ、またはCatchArgumentNull関数を使用した例外ハンドリングコードが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、問題のあるパラメータ名（ParamName）、VBエラー番号（ErrorNumber = vbObjectNotSet = 91）、HResult（E_POINTER = &H5B）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、例外情報を参照してNullオブジェクトを適切に初期化するか、呼び出し元に対してエラーメッセージを表示する。ParamNameプロパティにより、どの引数がNullかを特定し、適切な対処を行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbObjectNotSet (91) |
| HResult | E_POINTER (&H5B) |
| メッセージ形式 | {Message}\r\nParameter name: {ParamName} |

### 本文テンプレート

```
{エラーメッセージ}
Parameter name: {パラメータ名}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ParamName | 問題のパラメータ名 | mBase.GetValue("ParamName") | No |
| ErrorNumber | VBエラー番号 | vbObjectNotSet (固定値) | Yes |
| HResult | HRESULTコード | E_POINTER (固定値) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | メソッド引数検証 | オブジェクト参照がNothing | Null参照検出時にスロー |
| API呼び出し | メソッド引数検証 | 配列が未初期化 | 未初期化配列検出時にスロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| オブジェクト参照が有効 | Nothingでない場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B[引数検証]
    B --> C{オブジェクト/配列は有効か}
    C -->|Yes| D[正常処理継続]
    C -->|No - Nothing/未初期化| E[Cor.NewArgumentNullException生成]
    E --> F[Init呼び出し - ParamName, Message, InnerException設定]
    F --> G[Throw ArgumentNullException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Null参照 | オブジェクト参照がNothing | 該当引数を初期化して再呼び出し |
| 未初期化配列 | 配列がReDimされていない | 配列を初期化して再呼び出し |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージに機密情報を含めないこと
- ParamNameには変数名のみを設定

## 備考

- ArgumentNullExceptionはArgumentExceptionの派生クラス
- CatchArgumentNull関数で型別捕捉が可能
- IObject、Exception、SystemException、ArgumentExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）
- vbObjectNotSet (91) は「オブジェクト変数またはWithブロック変数が設定されていません」に対応

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ArgumentNullExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | クラス定義、mBase変数、プロパティ実装 |

**読解のコツ**: ArgumentExceptionインターフェースを実装しており、ParamNameプロパティを継承。HResult/ErrorNumberが異なる点に注目。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewArgumentNullException関数 |
| 2-2 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **Constructors.cls 行161-164**: NewArgumentNullException - 新規インスタンス生成とInit呼び出し
2. **ArgumentNullException.cls 行243-245**: Class_InitProperties - mBase初期化
3. **ArgumentNullException.cls 行247-251**: Init - ParamName, Message, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | Message, ParamName, ErrorNumber, HResult |

**主要処理フロー**:
- **行85-87**: ParamNameプロパティ - mBase.GetValueで取得
- **行119-121**: HResultプロパティ - E_POINTER固定値
- **行128-130**: ErrorNumberプロパティ - vbObjectNotSet固定値
- **行166-174**: Messageプロパティ - 基底メッセージ + ParamName付加

### プログラム呼び出し階層図

```
Cor.NewArgumentNullException(ParamName, Message, InnerException)
    │
    └─ New ArgumentNullException
           │
           ├─ Class_InitProperties()
           │      └─ Cor.NewExceptionBase(Me, App)
           │
           └─ Init(ParamName, Message, InnerException)
                  ├─ mBase.SetValue("ParamName", ParamName)
                  ├─ mBase.Message = Message
                  └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                      [処理]                        [出力]

ParamName ───────────┐
                     │
Message ─────────────┼──▶ ArgumentNullException.Init ──▶ mBase設定完了
                     │           │
InnerException ──────┘           │
                                 ▼
                          Throw ArgumentNullException
                                 │
                                 ▼
                          Err.Raise(91, Source, FormattedMessage)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArgumentNullException.cls | `Source/CorLib/System/ArgumentNullException.cls` | ソース | Null引数例外クラス本体 |
| ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | ソース | 基底インターフェース |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewArgumentNullExceptionコンストラクタ |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | CatchArgumentNull関数 |
