# 通知設計書 15-ArgumentOutOfRangeException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるArgumentOutOfRangeException例外通知の設計仕様を定義する。この例外は、引数の値が許容範囲外である場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

ArgumentOutOfRangeExceptionは、メソッドに渡された引数の値が許容される範囲外である場合にスローされる例外クラスである。ArgumentExceptionの派生クラスとして、範囲外エラーに特化した詳細情報（実際の値）を提供する。

**業務上の目的・背景**：配列インデックス、カウント、オフセット等の数値引数が有効範囲外である場合に、単なるエラー番号ではなく、「どのパラメータが」「どの値で」「なぜ範囲外か」を明確に通知する。これにより、開発者は問題の特定と修正を迅速に行える。

**通知の送信タイミング**：メソッドの引数検証処理において、数値引数が許容範囲（例：0以上、配列長未満）に違反していることが検出された時点でスローされる。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラ、またはCatchArgumentOutOfRange関数を使用した例外ハンドリングコードが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、問題のあるパラメータ名（ParamName）、実際に渡された値（ActualValue）、VBエラー番号（ErrorNumber - 呼び出し方法により変動）、HResult（COR_E_ARGUMENTOUTOFRANGE）、発生元（Source）が通知される。

**期待されるアクション**：呼び出し元は、ActualValueプロパティで不正な値を確認し、ParamNameで該当パラメータを特定して、有効な範囲内の値で再呼び出しを行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbInvalidProcedureCall(5) / vbSubscriptOutOfRange(9) / vbInvalidPropertyValue(380) |
| HResult | COR_E_ARGUMENTOUTOFRANGE |
| メッセージ形式 | {Message}\r\nParameter name: {ParamName}\r\nActual value was {ActualValue}. |

### 本文テンプレート

```
{エラーメッセージ}
Parameter name: {パラメータ名}
Actual value was {実際の値}.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ParamName | 問題のパラメータ名 | mBase.GetValue("ParamName") | No |
| ActualValue | 実際に渡された値 | mBase.GetValue("ActualValue") | No |
| ErrorNumber | VBエラー番号 | InvocationMethodに依存 | Yes |
| HResult | HRESULTコード | COR_E_ARGUMENTOUTOFRANGE (固定値) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | 配列インデックス検証 | インデックスが範囲外 | vbSubscriptOutOfRange(9) |
| API呼び出し | 一般メソッド引数検証 | 値が許容範囲外 | vbInvalidProcedureCall(5) |
| API呼び出し | プロパティ値検証 | 値が不正 | vbInvalidPropertyValue(380) |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 値が許容範囲内 | 正常な値が渡された場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B[引数検証]
    B --> C{値は許容範囲内か}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[Cor.NewArgumentOutOfRangeException生成]
    E --> F[Init呼び出し - ParamName, Message, ActualValue, InnerException, Method設定]
    F --> G[GetErrorNumber - Methodに基づきエラー番号決定]
    G --> H[Throw ArgumentOutOfRangeException]
    H --> I[ExceptionManagement.Throw]
    I --> J[Err.Raise実行]
    J --> K[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| インデックス範囲外 | 配列/コレクションインデックス超過 | ActualValueを参照し有効範囲内の値を使用 |
| 数値範囲外 | カウント/オフセット等が負数または上限超過 | ActualValueを参照し有効範囲内の値を使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ActualValueに機密情報が含まれないよう注意
- ログ出力時はActualValueのマスキングを検討

## 備考

- ArgumentOutOfRangeExceptionはArgumentExceptionの派生クラス
- CatchArgumentOutOfRange関数で型別捕捉が可能
- InvocationMethod列挙型によりエラー番号が動的に決定される
  - GenericInvocation: vbInvalidProcedureCall (5)
  - ArrayInvocation: vbSubscriptOutOfRange (9)
  - PropertyInvocation: vbInvalidPropertyValue (380)
- PropertyBagによるシリアライズ対応（Persistable = True）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ArgumentOutOfRangeExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | クラス定義、InvocationMethod列挙型、ActualValueプロパティ |

**読解のコツ**: InvocationMethod列挙型により、エラー番号が動的に決定される点に注目。ActualValueは呼び出し元に実際の値を通知するための追加プロパティ。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewArgumentOutOfRangeException関数 |
| 2-2 | ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | Initメソッド、GetErrorNumber関数 |

**主要処理フロー**:
1. **Constructors.cls 行176-179**: NewArgumentOutOfRangeException - 新規インスタンス生成とInit呼び出し
2. **ArgumentOutOfRangeException.cls 行263-266**: Class_InitProperties - mBase初期化とデフォルトエラー番号設定
3. **ArgumentOutOfRangeException.cls 行268-274**: Init - ParamName, Message, ActualValue, InnerException, Method設定
4. **ArgumentOutOfRangeException.cls 行276-287**: GetErrorNumber - Methodに基づくエラー番号決定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | Message, ParamName, ActualValue, ErrorNumber, HResult |

**主要処理フロー**:
- **行87-89**: ActualValueプロパティ - mBase.GetValueで取得
- **行99-101**: ParamNameプロパティ - mBase.GetValueで取得
- **行133-135**: HResultプロパティ - COR_E_ARGUMENTOUTOFRANGE固定値
- **行142-144**: ErrorNumberプロパティ - mBase.ErrorNumber（動的）
- **行180-194**: Messageプロパティ - 基底メッセージ + ParamName + ActualValue付加

### プログラム呼び出し階層図

```
Cor.NewArgumentOutOfRangeException(ParamName, Message, ActualValue, InnerException, Method)
    │
    └─ New ArgumentOutOfRangeException
           │
           ├─ Class_InitProperties()
           │      ├─ Cor.NewExceptionBase(Me, App)
           │      └─ mBase.ErrorNumber = vbInvalidProcedureCall
           │
           └─ Init(ParamName, Message, ActualValue, InnerException, Method)
                  ├─ mBase.SetValue("ParamName", ParamName)
                  ├─ mBase.SetValue("ActualValue", ActualValue)
                  ├─ mBase.Message = Message
                  ├─ mBase.ErrorNumber = GetErrorNumber(Method)
                  └─ Set mBase.InnerException = InnerException

GetErrorNumber(Method)
    │
    ├─ GenericInvocation ──▶ vbInvalidProcedureCall (5)
    ├─ ArrayInvocation ──▶ vbSubscriptOutOfRange (9)
    └─ PropertyInvocation ──▶ vbInvalidPropertyValue (380)
```

### データフロー図

```
[入力]                        [処理]                          [出力]

ParamName ───────────┐
                     │
Message ─────────────┤
                     │
ActualValue ─────────┼──▶ ArgumentOutOfRangeException.Init ──▶ mBase設定完了
                     │           │
InnerException ──────┤           │
                     │           ▼
Method ──────────────┘    GetErrorNumber(Method)
                                 │
                                 ▼
                          Throw ArgumentOutOfRangeException
                                 │
                                 ▼
                          Err.Raise(ErrorNumber, Source, FormattedMessage)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArgumentOutOfRangeException.cls | `Source/CorLib/System/ArgumentOutOfRangeException.cls` | ソース | 範囲外引数例外クラス本体 |
| ArgumentException.cls | `Source/CorLib/System/ArgumentException.cls` | ソース | 基底インターフェース |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewArgumentOutOfRangeExceptionコンストラクタ |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | CatchArgumentOutOfRange関数 |
