# 通知設計書 17-DirectoryNotFoundException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるDirectoryNotFoundException例外通知の設計仕様を定義する。この例外は、指定されたディレクトリが存在しない場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

DirectoryNotFoundExceptionは、ディレクトリ操作またはファイル操作において指定されたディレクトリ（パス）が見つからない場合にスローされる例外クラスである。IOExceptionの派生クラスとして、ディレクトリ未検出に特化したエラー通知を提供する。

**業務上の目的・背景**：ファイル/ディレクトリ操作において、対象ディレクトリが存在しないことを明確に通知する。FileNotFoundExceptionとの区別により、問題がファイル自体なのかディレクトリパスなのかを明確に識別できる。

**通知の送信タイミング**：ディレクトリのオープン、一覧取得、ファイル操作においてディレクトリパスが存在しないことが検出された時点でスローされる。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラ、またはCatchDirectoryNotFound関数を使用した例外ハンドリングコードが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、VBエラー番号（ErrorNumber = vbPathNotFound = 76）、HResult（COR_E_DIRECTORYNOTFOUND）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、エラーメッセージでパス情報を確認し、ディレクトリの存在確認、パスの修正、またはディレクトリの作成を行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbPathNotFound (76) |
| HResult | COR_E_DIRECTORYNOTFOUND |
| メッセージ形式 | {Message} |

### 本文テンプレート

```
{エラーメッセージ - 通常ディレクトリパスを含む}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ErrorNumber | VBエラー番号 | vbPathNotFound (固定値) | Yes |
| HResult | HRESULTコード | COR_E_DIRECTORYNOTFOUND (固定値) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ディレクトリ操作 | ディレクトリ一覧取得 | ディレクトリが存在しない | Directory.GetFiles等 |
| ファイル操作 | ファイルパス操作 | 親ディレクトリが存在しない | パスの一部が無効 |
| ディレクトリ操作 | ディレクトリ情報取得 | ディレクトリが存在しない | DirectoryInfo等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ディレクトリが存在 | ディレクトリが見つかった場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ディレクトリ操作要求] --> B[ディレクトリ存在確認]
    B --> C{ディレクトリは存在するか}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[Cor.NewDirectoryNotFoundException生成]
    E --> F[Init呼び出し - Message, InnerException設定]
    F --> G[Throw DirectoryNotFoundException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディレクトリ未検出 | 指定パスにディレクトリが存在しない | パス確認/修正、またはディレクトリ作成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージに含まれるパス情報が機密情報を露出しないよう注意
- サーバーサイドでは詳細なディレクトリパスをユーザーに公開しない

## 備考

- DirectoryNotFoundExceptionはIOExceptionの派生クラス
- CatchDirectoryNotFound関数で型別捕捉が可能
- FileNotFoundExceptionとは異なり、ディレクトリ名専用プロパティは持たない
- IObject、Exception、SystemException、IOExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DirectoryNotFoundExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | クラス定義、mBase変数、基本プロパティ |

**読解のコツ**: FileNotFoundExceptionと比較してシンプルな構造。ディレクトリ名専用プロパティがない点に注目。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewDirectoryNotFoundException関数 |
| 2-2 | DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **Constructors.cls 行661-664**: NewDirectoryNotFoundException - 新規インスタンス生成とInit呼び出し
2. **DirectoryNotFoundException.cls 行211-213**: Class_InitProperties - mBase初期化
3. **DirectoryNotFoundException.cls 行215-218**: Init - Message, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | Message, ErrorNumber, HResult |

**主要処理フロー**:
- **行93-95**: HResultプロパティ - COR_E_DIRECTORYNOTFOUND固定値
- **行102-104**: ErrorNumberプロパティ - vbPathNotFound固定値
- **行140-142**: Messageプロパティ - GetExceptionMessageでメッセージ取得

### プログラム呼び出し階層図

```
Cor.NewDirectoryNotFoundException(Message, InnerException)
    │
    └─ New DirectoryNotFoundException
           │
           ├─ Class_InitProperties()
           │      └─ Cor.NewExceptionBase(Me, App)
           │
           └─ Init(Message, InnerException)
                  ├─ mBase.Message = Message
                  └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                      [処理]                          [出力]

Message ─────────────┐
                     │
InnerException ──────┼──▶ DirectoryNotFoundException.Init ──▶ mBase設定完了
                     │           │
                                 ▼
                          Throw DirectoryNotFoundException
                                 │
                                 ▼
                          Err.Raise(76, Source, Message)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | ソース | ディレクトリ未検出例外クラス本体 |
| IOException.cls | `Source/CorLib/System.IO/IOException.cls` | ソース | 基底インターフェース |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewDirectoryNotFoundExceptionコンストラクタ |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | CatchDirectoryNotFound関数 |
