# 通知設計書 18-IOException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるIOException例外通知の設計仕様を定義する。この例外は、入出力（I/O）操作でエラーが発生した場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

IOExceptionは、ファイル、ストリーム、ディレクトリ等のI/O操作においてエラーが発生した場合にスローされる例外クラスである。I/O関連例外の基底クラスとして機能し、FileNotFoundException、DirectoryNotFoundExceptionなどの派生クラスの共通インターフェースを提供する。

**業務上の目的・背景**：ファイルシステム操作やストリーム操作において発生する様々なエラーを統一的に捕捉し処理するための基盤を提供する。汎用的なI/Oエラーの場合はIOExceptionが直接スローされ、より具体的なエラー（ファイル未検出等）の場合は派生クラスがスローされる。

**通知の送信タイミング**：ファイル読み書き、ストリーム操作、ディスクアクセス等のI/O操作においてエラーが検出された時点でスローされる。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラが受信者となる。IOExceptionをキャッチすると派生クラスも含めて捕捉できる。

**通知内容の概要**：エラーメッセージ（Message）、VBエラー番号（ErrorNumber - 動的設定可能）、HResult（動的設定可能）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、エラーメッセージとErrorNumberを参照してエラーの原因を特定し、ファイル/ストリームのクローズ、リトライ、またはユーザーへのエラー通知を行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbDeviceIOError (57) - デフォルト、または指定値 |
| HResult | COR_E_IO - デフォルト、または指定値 |
| メッセージ形式 | {Message} |

### 本文テンプレート

```
{エラーメッセージ}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ErrorNumber | VBエラー番号 | mBase.ErrorNumber（動的） | Yes |
| HResult | HRESULTコード | mBase.HResult（動的） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイル操作 | ファイル読み書き | I/Oエラー発生 | 読み書き失敗時 |
| ストリーム操作 | ストリーム読み書き | I/Oエラー発生 | ストリーム操作失敗時 |
| ディスク操作 | ディスクアクセス | ディスクエラー発生 | デバイスエラー時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 操作成功 | I/O操作が正常完了した場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[I/O操作要求] --> B[操作実行]
    B --> C{操作は成功したか}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[Cor.NewIOException生成]
    E --> F[Init呼び出し - Message, HResult, ErrorNumber, InnerException設定]
    F --> G[Throw IOException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| デバイスI/Oエラー | ディスク/デバイス障害 | リトライまたはデバイス確認 |
| ファイルロック | ファイルが他プロセスで使用中 | 待機後リトライ |
| 容量不足 | ディスク容量不足 | 空き容量確保 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（例外レベルでは実装なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにファイルパス等の機密情報が含まれる可能性
- サーバーサイドでは詳細なI/Oエラー情報をユーザーに公開しない

## 備考

- IOExceptionはI/O例外の基底クラス
- FileNotFoundException、DirectoryNotFoundException、PathTooLongExceptionなどの派生クラスが存在
- ErrorNumberとHResultは動的に設定可能（コンストラクタで指定）
- デフォルトではvbDeviceIOError (57)、COR_E_IOが設定される
- IObject、Exception、SystemExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IOExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOException.cls | `Source/CorLib/System.IO/IOException.cls` | クラス定義、mBase変数、動的プロパティ |

**読解のコツ**: ErrorNumberとHResultが動的に設定可能な点に注目。Class_InitPropertiesでデフォルト値が設定される。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewIOException関数 |
| 2-2 | IOException.cls | `Source/CorLib/System.IO/IOException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **Constructors.cls 行396-399**: NewIOException - 新規インスタンス生成とInit呼び出し（HResult, ErrorCode引数あり）
2. **IOException.cls 行214-218**: Class_InitProperties - mBase初期化とデフォルト値設定
3. **IOException.cls 行220-225**: Init - Message, HResult, ErrorNumber, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOException.cls | `Source/CorLib/System.IO/IOException.cls` | Message, ErrorNumber, HResult |

**主要処理フロー**:
- **行96-98**: HResultプロパティ - mBase.HResult（動的）
- **行105-107**: ErrorNumberプロパティ - mBase.ErrorNumber（動的）
- **行143-145**: Messageプロパティ - GetExceptionMessageでメッセージ取得

### プログラム呼び出し階層図

```
Cor.NewIOException(Message, HResult, ErrorCode, InnerException)
    │
    └─ New IOException
           │
           ├─ Class_InitProperties()
           │      ├─ Cor.NewExceptionBase(Me, App)
           │      ├─ mBase.HResult = COR_E_IO
           │      └─ mBase.ErrorNumber = vbDeviceIOError
           │
           └─ Init(Message, HResult, ErrorNumber, InnerException)
                  ├─ mBase.Message = Message
                  ├─ mBase.HResult = HResult
                  ├─ mBase.ErrorNumber = ErrorNumber
                  └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                        [処理]                        [出力]

Message ─────────────┐
                     │
HResult ─────────────┤
                     │
ErrorNumber ─────────┼──▶ IOException.Init ──▶ mBase設定完了
                     │           │
InnerException ──────┘           │
                                 ▼
                          Throw IOException
                                 │
                                 ▼
                          Err.Raise(ErrorNumber, Source, Message)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOException.cls | `Source/CorLib/System.IO/IOException.cls` | ソース | I/O例外クラス本体 |
| FileNotFoundException.cls | `Source/CorLib/System.IO/FileNotFoundException.cls` | ソース | 派生クラス |
| DirectoryNotFoundException.cls | `Source/CorLib/System.IO/DirectoryNotFoundException.cls` | ソース | 派生クラス |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewIOExceptionコンストラクタ |
