# 通知設計書 19-InvalidOperationException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるInvalidOperationException例外通知の設計仕様を定義する。この例外は、オブジェクトの現在の状態ではメソッド呼び出しが無効である場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

InvalidOperationExceptionは、メソッドの呼び出し自体は有効だが、オブジェクトの現在の状態がその操作を許可しない場合にスローされる例外クラスである。引数エラー（ArgumentException）とは異なり、引数以外の理由でメソッド呼び出しが失敗する場合に使用される。

**業務上の目的・背景**：オブジェクトの状態管理において、無効な状態でのメソッド呼び出しを検出し、明確なエラーメッセージを提供する。例えば、既にクローズされたストリームへの書き込み、初期化されていないオブジェクトの使用、列挙中のコレクション変更などの場合にスローされる。

**通知の送信タイミング**：オブジェクトの状態検証において、現在の状態が要求された操作を許可しないことが検出された時点でスローされる。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、VBエラー番号（ErrorNumber = vbInvalidProcedureCall = 5）、HResult（COR_E_INVALIDOPERATION）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、オブジェクトの状態を確認し、適切な状態に遷移させてから再度操作を試みるか、操作をスキップする。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（即時処理） |
| リトライ | 無 |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbInvalidProcedureCall (5) |
| HResult | COR_E_INVALIDOPERATION |
| メッセージ形式 | {Message} |

### 本文テンプレート

```
{エラーメッセージ - 無効な操作の理由を説明}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ErrorNumber | VBエラー番号 | vbInvalidProcedureCall (固定値) | Yes |
| HResult | HRESULTコード | COR_E_INVALIDOPERATION (固定値) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 状態検証 | クローズ済みオブジェクト操作 | オブジェクトがクローズ状態 | ストリーム操作等 |
| 状態検証 | 未初期化オブジェクト操作 | オブジェクトが初期化前 | 初期化必須操作 |
| 状態検証 | 列挙中コレクション変更 | 列挙中に変更操作 | For Each中の変更 |
| 状態検証 | 読み取り専用オブジェクト変更 | 読み取り専用状態 | ReadOnly設定時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 操作が有効な状態 | オブジェクトの状態が操作を許可する場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メソッド呼び出し] --> B[オブジェクト状態確認]
    B --> C{現在の状態で操作は有効か}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[Cor.NewInvalidOperationException生成]
    E --> F[Init呼び出し - Message, InnerException設定]
    F --> G[Throw InvalidOperationException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効な状態 | オブジェクトの状態が操作を許可しない | 状態遷移後に再試行 |
| 初期化前操作 | 初期化されていないオブジェクト | 初期化後に再試行 |
| クローズ後操作 | クローズ済みオブジェクト | 新規オブジェクト作成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにオブジェクトの内部状態詳細を含めすぎないこと
- セキュリティ上重要な状態情報は露出しない

## 備考

- InvalidOperationExceptionはSystemExceptionの派生クラス
- 引数エラー以外の理由でメソッド呼び出しが失敗する場合に使用
- IObject、Exception、SystemExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）
- .NET FrameworkのSystem.InvalidOperationExceptionに相当

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

InvalidOperationExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InvalidOperationException.cls | `Source/CorLib/System/InvalidOperationException.cls` | クラス定義、mBase変数、基本プロパティ |

**読解のコツ**: ArgumentExceptionとの違いに注目。ParamNameプロパティがなく、状態エラーに特化している。

#### Step 2: エントリーポイントを理解する

コンストラクタとInit処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Constructors.cls | `Source/CorLib/System/Constructors.cls` | NewInvalidOperationException関数 |
| 2-2 | InvalidOperationException.cls | `Source/CorLib/System/InvalidOperationException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **Constructors.cls 行220-223**: NewInvalidOperationException - 新規インスタンス生成とInit呼び出し
2. **InvalidOperationException.cls 行217-219**: Class_InitProperties - mBase初期化
3. **InvalidOperationException.cls 行221-224**: Init - Message, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | InvalidOperationException.cls | `Source/CorLib/System/InvalidOperationException.cls` | Message, ErrorNumber, HResult |

**主要処理フロー**:
- **行99-101**: HResultプロパティ - COR_E_INVALIDOPERATION固定値
- **行108-110**: ErrorNumberプロパティ - vbInvalidProcedureCall固定値
- **行146-148**: Messageプロパティ - GetExceptionMessageでメッセージ取得

### プログラム呼び出し階層図

```
Cor.NewInvalidOperationException(Message, InnerException)
    │
    └─ New InvalidOperationException
           │
           ├─ Class_InitProperties()
           │      └─ Cor.NewExceptionBase(Me, App)
           │
           └─ Init(Message, InnerException)
                  ├─ mBase.Message = Message
                  └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                      [処理]                          [出力]

Message ─────────────┐
                     │
InnerException ──────┼──▶ InvalidOperationException.Init ──▶ mBase設定完了
                                 │
                                 ▼
                          Throw InvalidOperationException
                                 │
                                 ▼
                          Err.Raise(5, Source, Message)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InvalidOperationException.cls | `Source/CorLib/System/InvalidOperationException.cls` | ソース | 無効操作例外クラス本体 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| Constructors.cls | `Source/CorLib/System/Constructors.cls` | ソース | NewInvalidOperationExceptionコンストラクタ |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | Throw/Catch機構 |
