# 通知設計書 20-OutOfMemoryException

## 概要

本ドキュメントは、VBCorLibライブラリにおけるOutOfMemoryException例外通知の設計仕様を定義する。この例外は、メモリ不足エラーが発生した場合にスローされ、呼び出し元にエラー状態を通知する。

### 本通知の処理概要

OutOfMemoryExceptionは、プログラムの実行に必要なメモリを確保できない場合にスローされる例外クラスである。大規模な配列確保、大量のオブジェクト生成、メモリリークの蓄積などにより利用可能メモリが不足した場合に発生する。

**業務上の目的・背景**：メモリ不足はシステムの安定性に影響する重大なエラーである。OutOfMemoryExceptionを適切にスローすることで、呼び出し元はメモリ不足の状況を検知し、不要なリソースの解放、処理の中断、またはユーザーへの警告を行うことができる。

**通知の送信タイミング**：メモリ確保操作（配列のReDim、オブジェクトのNew等）においてメモリ不足が検出された時点でスローされる。VBランタイムのエラー7（メモリが不足しています）が発生した場合にも使用される。

**通知の受信者**：呼び出し元のメソッド。On Error GoToで設定されたエラーハンドラが受信者となる。

**通知内容の概要**：エラーメッセージ（Message）、VBエラー番号（ErrorNumber = vbOutOfMemory = 7）、HResult（COR_E_OUTOFMEMORY）、発生元（Source）、原因となった内部例外（InnerException）が通知される。

**期待されるアクション**：呼び出し元は、不要なオブジェクトの解放、処理の中断、または処理を小分けにして再試行する。メモリリークの可能性がある場合は、コードの見直しを行う。

## 通知種別

プログラム例外通知（VBランタイムのErr.Raiseを介したエラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Throw経由でErr.Raise） |
| 優先度 | 高（重大エラー） |
| リトライ | 無（メモリ不足はリトライ困難） |

### 送信先決定ロジック

VBランタイムのエラーハンドリング機構による自動決定。

## 通知テンプレート

### 例外通知の場合

| 項目 | 内容 |
|-----|------|
| エラー番号 | vbOutOfMemory (7) |
| HResult | COR_E_OUTOFMEMORY |
| メッセージ形式 | {Message} |

### 本文テンプレート

```
{エラーメッセージ - 通常「メモリが不足しています」}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Message | エラーメッセージ | mBase.Message または デフォルトメッセージ | Yes |
| ErrorNumber | VBエラー番号 | vbOutOfMemory (固定値) | Yes |
| HResult | HRESULTコード | COR_E_OUTOFMEMORY (固定値) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メモリ確保 | 配列ReDim | メモリ確保失敗 | 大規模配列確保時 |
| メモリ確保 | オブジェクトNew | メモリ確保失敗 | オブジェクト生成時 |
| メモリ確保 | 文字列連結 | メモリ確保失敗 | 大量文字列操作時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| メモリ確保成功 | メモリが正常に確保できた場合は例外なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メモリ確保要求] --> B[メモリ確保試行]
    B --> C{メモリは確保できたか}
    C -->|Yes| D[正常処理継続]
    C -->|No| E[OutOfMemoryException生成]
    E --> F[Init呼び出し - Message, InnerException設定]
    F --> G[Throw OutOfMemoryException]
    G --> H[ExceptionManagement.Throw]
    H --> I[Err.Raise実行]
    I --> J[エラーハンドラへ伝播]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メモリ不足 | 使用可能メモリ枯渇 | 不要オブジェクト解放、処理中断 |
| 連続確保失敗 | フラグメンテーション | 処理を小分けに実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（メモリ解放後に手動リトライ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メモリ不足攻撃（DoS）の可能性を考慮
- リソース制限の実装を検討
- エラーメッセージにシステム情報を含めすぎない

## 備考

- OutOfMemoryExceptionはSystemExceptionの派生クラス
- Dataプロパティは常にNothingを返す（メモリ節約のため）
- VBランタイムのエラー7（Out of memory）に対応
- IObject、Exception、SystemExceptionインターフェースを実装
- PropertyBagによるシリアライズ対応（Persistable = True）
- .NET FrameworkのSystem.OutOfMemoryExceptionに相当
- GNU Library General Public Licenseの下でライセンス

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OutOfMemoryExceptionクラスの構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OutOfMemoryException.cls | `Source/CorLib/System/OutOfMemoryException.cls` | クラス定義、mBase変数、基本プロパティ |

**読解のコツ**: DataプロパティがNothingを返す点に注目。これはメモリ節約のための設計判断。

#### Step 2: エントリーポイントを理解する

Initメソッドを理解する（コンストラクタ関数はConstructors.clsに定義されていない）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OutOfMemoryException.cls | `Source/CorLib/System/OutOfMemoryException.cls` | Initメソッド、Class_InitProperties |

**主要処理フロー**:
1. **OutOfMemoryException.cls 行212-214**: Class_InitProperties - mBase初期化
2. **OutOfMemoryException.cls 行216-219**: Init - Message, InnerException設定

#### Step 3: プロパティ実装を理解する

例外情報のプロパティ取得ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OutOfMemoryException.cls | `Source/CorLib/System/OutOfMemoryException.cls` | Message, ErrorNumber, HResult, Data |

**主要処理フロー**:
- **行60-62**: Dataプロパティ - Nothing固定（メモリ節約）
- **行94-96**: HResultプロパティ - COR_E_OUTOFMEMORY固定値
- **行103-105**: ErrorNumberプロパティ - vbOutOfMemory固定値
- **行141-143**: Messageプロパティ - GetExceptionMessageでメッセージ取得

### プログラム呼び出し階層図

```
New OutOfMemoryException
    │
    ├─ Class_InitProperties()
    │      └─ Cor.NewExceptionBase(Me, App)
    │
    └─ Init(Message, InnerException) [Optional]
           ├─ mBase.Message = Message
           └─ Set mBase.InnerException = InnerException
```

### データフロー図

```
[入力]                      [処理]                          [出力]

Message ─────────────┐
                     │
InnerException ──────┼──▶ OutOfMemoryException.Init ──▶ mBase設定完了
                                 │
                                 ▼
                          Throw OutOfMemoryException
                                 │
                                 ▼
                          Err.Raise(7, Source, Message)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OutOfMemoryException.cls | `Source/CorLib/System/OutOfMemoryException.cls` | ソース | メモリ不足例外クラス本体 |
| ExceptionBase.cls | `Source/CorLib/System/ExceptionBase.cls` | ソース | 例外基底ヘルパー |
| ExceptionManagement.bas | `Source/CorLib/System/ExceptionManagement.bas` | ソース | Throw/Catch機構 |
