# 通知設計書 8-Console.Break

## 概要

本ドキュメントは、VBCorLibライブラリにおけるConsole.Breakコンソールブレーク通知の設計を定義する。Console.Breakプロパティはコンソールでブレーク（Ctrl+C等）が発生したことを検出する通知機構を提供する。

### 本通知の処理概要

Console.Breakは、コンソールアプリケーションにおいてユーザーがCtrl+C、Ctrl+Break、ウィンドウを閉じる、ログオフ、シャットダウンなどの操作を行った際に、その発生を通知するプロパティである。Windows SetConsoleCtrlHandler APIを使用してブレークイベントを検出する。

**業務上の目的・背景**：コンソールアプリケーションでは、ユーザーが処理を中断したい場合にCtrl+Cを押すことが一般的である。しかし、中断時にリソースの解放やデータの保存が必要な場合がある。Console.Breakは、中断イベントを検出してアプリケーションに通知し、適切なクリーンアップ処理を実行できるようにする。

**通知の送信タイミング**：以下のイベントが発生した時点でBreakプロパティがTrueに設定される：
- Ctrl+C押下
- Ctrl+Break押下
- コンソールウィンドウの閉じるボタンクリック
- ユーザーログオフ
- システムシャットダウン

**通知の受信者**：Consoleオブジェクトを使用するアプリケーションコード。ポーリングによりBreakプロパティをチェックする。

**通知内容の概要**：Breakプロパティは単純なBooleanフラグで、ブレークが発生したかどうかを示す。詳細なブレーク種別はBreakTypeプロパティで取得できる。

**期待されるアクション**：アプリケーションは定期的にConsole.Breakをチェックし、Trueの場合は適切なクリーンアップ処理を実行してから終了する。処理後はBreakプロパティをFalseにリセットすることで、次のブレークを検出可能にする。

## 通知種別

コンソール通知（Windows APIコールバック経由のフラグ通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Windows OSからのコールバック） |
| 優先度 | 高（割り込み処理） |
| リトライ | 該当なし（ポーリングベース） |

### 送信先決定ロジック

1. SetConsoleCtrlHandlerでControlBreakHandlerを登録
2. ブレークイベント発生時にOSがコールバック呼び出し
3. ConsoleCallbacksモジュールのフラグ更新
4. アプリケーションがConsole.Breakプロパティをポーリング

## 通知テンプレート

### Breakプロパティ

| 項目 | 内容 |
|-----|------|
| プロパティ名 | Break |
| 型 | Boolean |
| 読み取り | 可能（Get） |
| 書き込み | 可能（Let） |

### 使用例

```vb
Sub Main()
    Dim running As Boolean
    running = True

    Do While running
        ' メイン処理
        ProcessData

        ' ブレークチェック
        If Console.Break Then
            Console.WriteLine "Break detected, cleaning up..."

            ' クリーンアップ処理
            CleanupResources

            ' ブレークフラグをリセット
            Console.Break = False

            ' ループ終了
            running = False
        End If

        DoEvents
    Loop
End Sub
```

### 添付ファイル

該当なし（プログラム内部機能）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Break | ブレーク発生フラグ | Console.Break | Yes |
| BreakType | ブレーク種別 | Console.BreakType | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| キーボード | Ctrl+C | コンソールがアクティブ | ControlC (0) |
| キーボード | Ctrl+Break | コンソールがアクティブ | ControlBreak (1) |
| GUI | ウィンドウ閉じる | コンソールウィンドウ存在 | CloseWindow (2) |
| システム | ログオフ | ユーザーセッション終了 | LogOffUser (5) |
| システム | シャットダウン | システム終了開始 | ShutDownSystem (6) |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| TreatControlCAsInput = True | Ctrl+Cを入力として扱う場合 |
| コンソール未初期化 | Consoleオブジェクト未使用 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Consoleクラス初期化] --> B[SetConsoleCtrlHandler登録]
    B --> C[アプリケーション実行]
    C --> D{ブレークイベント発生?}
    D -->|No| C
    D -->|Yes| E[ControlBreakHandler呼び出し]
    E --> F[mBreak = True]
    F --> G[mBreakType = dwCtrlType]
    G --> H[ControlBreakHandler = True 返却]
    H --> I[アプリケーション継続]
    I --> J{Console.Break チェック}
    J -->|False| C
    J -->|True| K[クリーンアップ処理]
    K --> L[Console.Break = False]
    L --> M{継続?}
    M -->|Yes| C
    M -->|No| N[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内処理のみ）

### 更新テーブル一覧

該当なし（メモリ内処理のみ）

#### 内部データ構造

| 変数 | モジュール | 型 | 用途 |
|-----|----------|---|------|
| mBreak | ConsoleCallbacks.bas | Boolean | ブレーク発生フラグ |
| mBreakType | ConsoleCallbacks.bas | ConsoleBreakType | ブレーク種別 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンソール未存在 | GUIアプリからの使用 | AllocConsoleで作成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（OSイベント依存） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ControlBreakHandlerはスレッドセーフではないため、COMオブジェクトを使用しない
- 割り込みコンテキストで実行されるため、最小限の処理に留める
- 機密データのクリーンアップを確実に実行する

## 備考

- VB6 IDEで実行中にコンソールを閉じるとクラッシュするため注意が必要
- DoEventsなしでもBreakプロパティは更新される（OSコールバックのため）
- BreakプロパティをFalseにリセットしないと、次のブレークを検出できない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ブレークフラグを保持するモジュールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | mBreak, mBreakType変数（32-33行目） |
| 1-2 | Console.cls | `Source/CorLib/System/Console.cls` | ConsoleBreakType列挙型（163-169行目） |

**読解のコツ**: mBreakとmBreakTypeはConsoleCallbacksモジュールに配置されている。これはコールバックがスレッドセーフではないため、COMオブジェクトを避けるため。

#### Step 2: コンソール初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Console.cls | `Source/CorLib/System/Console.cls` | Init Sub（1313-1328行目） |

**主要処理フロー**:
- **1314行目**: AllocConsoleでコンソール作成
- **1321行目**: SetConsoleCtrlHandler AddressOf ControlBreakHandler, True

#### Step 3: コールバック処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | ControlBreakHandler関数（52-56行目） |

**主要処理フロー**:
- **53行目**: mBreak = True
- **54行目**: mBreakType = dwCtrlType
- **55行目**: ControlBreakHandler = True（イベント処理済み）

#### Step 4: Breakプロパティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Console.cls | `Source/CorLib/System/Console.cls` | Break Get/Let（245-258行目） |
| 4-2 | ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | Break Get/Let（36-42行目） |

**主要処理フロー**:
- **246行目**: Console.Break = ConsoleCallbacks.Break
- **257行目**: ConsoleCallbacks.Break = Value

### プログラム呼び出し階層図

```
[Console.Class_Initialize]
    │
    └─ Init()
           │
           ├─ AllocConsole
           │
           └─ SetConsoleCtrlHandler(AddressOf ControlBreakHandler, True)
                  │
                  ▼
           [Windows OSからのコールバック]
                  │
           ControlBreakHandler(dwCtrlType)
                  │
                  ├─ mBreak = True
                  │
                  └─ mBreakType = dwCtrlType
                         │
                         ▼
           [アプリケーション]
                  │
                  └─ Console.Break プロパティ参照
                         │
                         └─ ConsoleCallbacks.Break
                                │
                                └─ mBreak返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Ctrl+C/Break     ───▶ Windows OS           ───▶ ControlBreakHandler
押下                  CtrlHandler呼び出し         コールバック
                            │
                            ▼
dwCtrlType       ───▶ ControlBreakHandler ───▶ mBreak = True
(イベント種別)          │                        mBreakType = dwCtrlType
                       │
                       ▼
Console.Break    ◀─── ConsoleCallbacks     ◀─── mBreak
プロパティ参照          .Break
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Console.cls | `Source/CorLib/System/Console.cls` | ソース | コンソールクラス、Breakプロパティ公開 |
| ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | ソース | コールバックハンドラ、フラグ保持 |
