# 通知設計書 9-Console.BreakType

## 概要

本ドキュメントは、VBCorLibライブラリにおけるConsole.BreakTypeブレーク種別通知の設計を定義する。Console.BreakTypeプロパティはコンソールで発生したブレークイベントの種類を通知する機能を提供する。

### 本通知の処理概要

Console.BreakTypeは、Console.BreakプロパティがTrueの場合に、どの種類のブレークイベントが発生したかを示すプロパティである。ConsoleBreakType列挙型の値を返し、アプリケーションがイベント種別に応じた適切な処理を実行できるようにする。

**業務上の目的・背景**：ブレークイベントには複数の種類があり、それぞれ適切な対処方法が異なる。Ctrl+Cは単純な中断要求であり、ユーザー確認後に処理を継続できる場合がある。一方、シャットダウンイベントは緊急のデータ保存が必要である。BreakTypeプロパティにより、アプリケーションはイベント種別を判別し、適切な対応を実装できる。

**通知の送信タイミング**：ControlBreakHandlerコールバックが呼び出された時点でmBreakTypeが更新される。Console.BreakTypeプロパティ参照時に現在の値が返される。

**通知の受信者**：Consoleオブジェクトを使用するアプリケーションコード。

**通知内容の概要**：ConsoleBreakType列挙型の値（ControlC=0, ControlBreak=1, CloseWindow=2, LogOffUser=5, ShutDownSystem=6）を返す。

**期待されるアクション**：アプリケーションはBreakTypeに応じた処理を実装する。例えば、ControlCの場合は確認ダイアログを表示し、ShutDownSystemの場合は即座にデータを保存する。

## 通知種別

コンソール通知（列挙型によるブレーク種別識別）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（プロパティ参照） |
| 優先度 | 高（ブレーク処理の一部） |
| リトライ | 該当なし |

### 送信先決定ロジック

1. ControlBreakHandlerでdwCtrlTypeをmBreakTypeに保存
2. アプリケーションがConsole.BreakTypeプロパティを参照
3. ConsoleCallbacks.BreakType経由でmBreakTypeを返却

## 通知テンプレート

### BreakTypeプロパティ

| 項目 | 内容 |
|-----|------|
| プロパティ名 | BreakType |
| 型 | ConsoleBreakType |
| 読み取り | 可能（Get） |
| 書き込み | 不可 |

### ConsoleBreakType列挙型

| 値 | 名前 | 説明 |
|---|------|------|
| 0 | ControlC | Ctrl+C押下 |
| 1 | ControlBreak | Ctrl+Break押下 |
| 2 | CloseWindow | ウィンドウ閉じる |
| 5 | LogOffUser | ユーザーログオフ |
| 6 | ShutDownSystem | システムシャットダウン |

### 使用例

```vb
Sub Main()
    Do While True
        ' メイン処理
        ProcessData

        ' ブレークチェック
        If Console.Break Then
            Select Case Console.BreakType
                Case ControlC
                    Console.WriteLine "Ctrl+C pressed. Continue? (Y/N)"
                    If Console.ReadLine = "Y" Then
                        Console.Break = False
                        ' 処理継続
                    Else
                        Exit Do
                    End If

                Case ControlBreak
                    Console.WriteLine "Ctrl+Break pressed. Aborting..."
                    Exit Do

                Case CloseWindow
                    Console.WriteLine "Window closing..."
                    SaveData
                    Exit Do

                Case LogOffUser, ShutDownSystem
                    Console.WriteLine "System event. Emergency save..."
                    EmergencySave
                    Exit Do
            End Select
        End If

        DoEvents
    Loop
End Sub
```

### 添付ファイル

該当なし（プログラム内部機能）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| BreakType | ブレーク種別 | Console.BreakType | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロパティ参照 | Console.BreakType | 常時参照可能 | 最後のブレーク種別を返す |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に参照可能（ブレーク未発生時は前回値または初期値） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ブレークイベント発生] --> B[ControlBreakHandler dwCtrlType]
    B --> C[mBreakType = dwCtrlType]
    C --> D[アプリケーション処理]
    D --> E{Console.BreakType 参照}
    E --> F[ConsoleCallbacks.BreakType]
    F --> G[mBreakType 返却]
    G --> H{BreakType判別}
    H -->|ControlC| I[Ctrl+C用処理]
    H -->|ControlBreak| J[Ctrl+Break用処理]
    H -->|CloseWindow| K[ウィンドウ閉じる用処理]
    H -->|LogOffUser| L[ログオフ用処理]
    H -->|ShutDownSystem| M[シャットダウン用処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ内処理のみ）

### 更新テーブル一覧

該当なし（メモリ内処理のみ）

#### 内部データ構造

| 変数 | モジュール | 型 | 用途 |
|-----|----------|---|------|
| mBreakType | ConsoleCallbacks.bas | ConsoleBreakType | ブレーク種別保持 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | - | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ブレーク種別に応じた適切なデータ保護処理を実装する
- LogOffUser、ShutDownSystemでは機密データの確実な保存を行う

## 備考

- BreakTypeはBreakがTrueになった原因を示す
- 複数のブレークイベントが連続発生した場合、最後のイベント種別が保持される
- BreakをFalseにリセットしてもBreakTypeは保持される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 列挙型定義を理解する

ConsoleBreakType列挙型の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Console.cls | `Source/CorLib/System/Console.cls` | ConsoleBreakType列挙型（163-169行目） |

**読解のコツ**: 列挙値はWindows APIの定義に対応している。3,4は未定義（CTRL_CLOSE_EVENT=2の次がCTRL_LOGOFF_EVENT=5）。

#### Step 2: プロパティ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Console.cls | `Source/CorLib/System/Console.cls` | BreakType Getプロパティ（231-233行目） |
| 2-2 | ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | BreakType Getプロパティ（44-46行目） |

**主要処理フロー**:
- **232行目**: BreakType = ConsoleCallbacks.BreakType
- **45行目**: BreakType = mBreakType

#### Step 3: コールバックでの設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | ControlBreakHandler関数（52-56行目） |

**主要処理フロー**:
- **54行目**: mBreakType = dwCtrlType

### プログラム呼び出し階層図

```
[Windows OS]
    │
    └─ ブレークイベント発生
           │
           └─ ControlBreakHandler(dwCtrlType)
                  │
                  ├─ mBreak = True
                  │
                  └─ mBreakType = dwCtrlType
                         │
                         ▼
[アプリケーション]
    │
    ├─ Console.Break チェック
    │      │
    │      └─ True の場合
    │             │
    │             └─ Console.BreakType 参照
    │                    │
    │                    └─ ConsoleCallbacks.BreakType
    │                           │
    │                           └─ mBreakType 返却
    │
    └─ Select Case BreakType で分岐処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

dwCtrlType       ───▶ ControlBreakHandler ───▶ mBreakType設定
(Windows API)          │
                       │
                       ▼
Console.BreakType ◀─── ConsoleCallbacks    ◀─── mBreakType
プロパティ参照          .BreakType                (ConsoleBreakType)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Console.cls | `Source/CorLib/System/Console.cls` | ソース | BreakTypeプロパティ公開、ConsoleBreakType定義 |
| ConsoleCallbacks.bas | `Source/CorLib/System/ConsoleCallbacks.bas` | ソース | mBreakType保持、BreakTypeプロパティ実装 |
