---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-Ticker.Elapsed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **最小間隔1ミリ秒の仕様**：Windows Timerの実際の精度に依存
  2. **マルチスレッド非対応の記述**：VB6の一般的制約として記載したが明示的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Threading/Ticker.cls` 82行目 - Public Event Elapsed宣言
- E-02: `Source/CorLib/System.Threading/Ticker.cls` 209-215行目 - StartTickerメソッド
- E-03: `Source/CorLib/System.Threading/Ticker.cls` 255-265行目 - OnElapsedメソッド
- E-04: `Source/CorLib/System.Threading/Ticker.cls` 260行目 - RaiseEvent Elapsed(mData)
- E-05: `Source/CorLib/System.Threading/Ticker.cls` 262-264行目 - mCallback.Invoke呼び出し
- E-06: `Source/CorLib/System.Threading/Ticker.cls` 271-283行目 - Init Subでのコールバック設定
- E-07: `Source/CorLib/System.Threading/Ticker.cls` 134-149行目 - AutoResetプロパティ
- E-08: `Source/CorLib/System.Threading/Ticker.cls` 169-177行目 - Intervalプロパティ（バリデーション含む）
- E-09: `Source/CorLib/System.Threading/TickerShared.bas` 36-46行目 - StartTicker関数
- E-10: `Source/CorLib/System.Threading/TickerShared.bas` 39行目 - SetTimer API呼び出し
- E-11: `Source/CorLib/System.Threading/TickerShared.bas` 58-90行目 - TickerCallback Sub
- E-12: `Source/CorLib/System.Threading/TickerShared.bas` 44行目 - Hashtableへの登録
- E-13: `Source/CorLib/System/Delegation.bas` 44-47行目 - Delegate構造体定義
- E-14: `Source/CorLib/System/Delegation.bas` 72-85行目 - NewDelegate関数
- E-15: `Source/CorLib/System.Threading/Ticker.cls` 39-70行目 - クラスコメントにコード例
- E-16: `Source/CorLib/System.Threading/Ticker.cls` 289-292行目 - Class_Terminate

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tickerクラスは定期的なタイマーイベントを提供する | E-01, E-02 | ○ |
| C-02 | Elapsedイベントは指定した時間間隔で発火する | E-02, E-09, E-10 | ○ |
| C-03 | WithEventsでイベント受信が可能 | E-01, E-15 | ○ |
| C-04 | AddressOfでコールバック関数指定が可能 | E-05, E-06, E-15 | ○ |
| C-05 | AutoResetがTrueの場合は繰り返し発火 | E-03, E-07 | ○ |
| C-06 | AutoResetがFalseの場合は1回のみ発火 | E-03 (256-258行目) | ○ |
| C-07 | ElapsedイベントはByRef Data As Variant引数を持つ | E-01, E-04 | ○ |
| C-08 | StartTickerメソッドでタイマー開始 | E-02 | ○ |
| C-09 | SetTimer APIを使用 | E-10 | ○ |
| C-10 | Hashtableでタイマー管理 | E-12 | ○ |
| C-11 | Intervalに負の値でArgumentOutOfRangeエラー | E-08 (170-171行目) | ○ |
| C-12 | コールバックはAction_T_T型で呼び出し | E-05 | ○ |
| C-13 | 弱参照を使用してメモリリーク防止 | E-11 (72-81行目コメント) | ○ |
| C-14 | Class_TerminateでObjectPtrを使用して解除 | E-16 (291行目) | ○ |
| C-15 | Windows WM_TIMERメッセージで処理 | E-11 (59行目) | ○ |
| C-16 | OnElapsedメソッドでイベント発火とコールバック実行 | E-03, E-04, E-05 | ○ |
| C-17 | 最小間隔は1ミリ秒 | **根拠なし** | △ |
| C-18 | マルチスレッド非対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17 最小間隔1ミリ秒**：コード上の明示的な最小値チェックはない。Intervalプロパティは「0以上」のみチェック（170-171行目）。Windows SetTimer APIの仕様に依存。
  - 候補：Windows API ドキュメント / MSDN SetTimer仕様
- **C-18 マルチスレッド非対応**：VB6のCOMスレッドモデルの一般的制約として記載。コード内に明示的な記述なし。
  - 候補：VB6言語仕様 / COM STA仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 主要なイベント発火処理に関する記述（C-01〜C-16）
- **1: 中リスク** - タイマー精度に関する記述（C-17）：実際の動作はWindows環境に依存
- **0: 低リスク** - マルチスレッドに関する記述（C-18）：一般的なVB6の制約として妥当

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のElapsedイベント宣言が設計書の記述と一致するか確認
- [ ] E-03のOnElapsedメソッドのAutoReset処理が正しく記述されているか確認
- [ ] E-06のInit Subでのコールバック設定処理が設計書と一致するか確認
- [ ] C-17の最小間隔についてWindows SetTimer APIの仕様を確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
