---
generated_at: 2026-01-20 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Console.Beep

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Console.cls` 73行目 - BeepAPI宣言
- E-02: `Source/CorLib/System/Console.cls` 491-502行目 - Beep Sub
- E-03: `Source/CorLib/System/Console.cls` 491行目 - デフォルト引数 Frequency=800, Duration=200
- E-04: `Source/CorLib/System/Console.cls` 492行目 - MinFrequency = 37
- E-05: `Source/CorLib/System/Console.cls` 493行目 - MaxFrequency = 32767
- E-06: `Source/CorLib/System/Console.cls` 494行目 - MinDuration = 1
- E-07: `Source/CorLib/System/Console.cls` 496-497行目 - Frequency範囲チェック
- E-08: `Source/CorLib/System/Console.cls` 498-499行目 - Duration範囲チェック
- E-09: `Source/CorLib/System/Console.cls` 500-501行目 - BeepAPI呼び出しとエラーチェック
- E-10: `Source/CorLib/System/Console.cls` 497行目 - ArgumentOutOfRange_BeepFrequency使用
- E-11: `Source/CorLib/System/Console.cls` 499行目 - ArgumentOutOfRange_NeedPosNum使用
- E-12: `Source/CorLib/System/Console.cls` 501行目 - GetMessage(Err.LastDllError)
- E-13: `Source/CorLib/System/Console.cls` 485-490行目 - Beepメソッドコメント
- E-14: `Source/CorLib/System/Console.cls` 488-489行目 - パラメータコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BeepはWindows Beep APIを使用 | E-01 | ○ |
| C-02 | デフォルト周波数は800Hz | E-03 | ○ |
| C-03 | デフォルト時間は200ms | E-03 | ○ |
| C-04 | 最小周波数は37Hz | E-04 | ○ |
| C-05 | 最大周波数は32767Hz | E-05 | ○ |
| C-06 | 最小時間は1ms | E-06 | ○ |
| C-07 | Frequency範囲外でArgumentOutOfRangeException | E-07, E-10 | ○ |
| C-08 | Duration範囲外でArgumentOutOfRangeException | E-08, E-11 | ○ |
| C-09 | BeepAPI失敗でSystemException | E-09, E-12 | ○ |
| C-10 | FrequencyとDurationはOptional引数 | E-03 | ○ |
| C-11 | Beepメソッドは同期処理 | E-02, E-13 | ○ |
| C-12 | BeepAPIはkernel32.dllのBeep関数 | E-01 | ○ |
| C-13 | BeepはSubプロシージャ（戻り値なし） | E-02 | ○ |
| C-14 | コンソールスピーカーから音を出す | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-02のBeep Subの処理フローが設計書と一致するか確認
- [ ] E-04, E-05, E-06のパラメータ制約値が設計書と一致するか確認
- [ ] E-07, E-08のバリデーション処理が設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
