---
generated_at: 2026-01-20 17:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-ExceptionManagement.Throw

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ考慮事項**：コードに明示的な記載なし
  2. **レート制限なしの根拠**：設計意図の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ExceptionManagement.bas` 行31 - mException変数宣言
- E-02: `Source/CorLib/System/ExceptionManagement.bas` 行55-71 - Throwプロシージャ実装
- E-03: `Source/CorLib/System/ExceptionManagement.bas` 行47-53 - ThrowOrErrプロシージャ実装
- E-04: `Source/CorLib/System/ExceptionManagement.bas` 行57-66 - 型判定ロジック
- E-05: `Source/CorLib/System/ExceptionManagement.bas` 行68-70 - Err.Raise呼び出し
- E-06: `Source/CorLib/System/ExceptionBase.cls` 行60-69 - ErrorNumberプロパティ
- E-07: `Source/CorLib/System/ExceptionBase.cls` 行186-202 - Messageプロパティ
- E-08: `Source/CorLib/System/ExceptionManagement.bas` 行150-154 - CreateException関数
- E-09: `Source/CorLib/System/ArgumentException.cls` 行118-128 - ErrorNumberプロパティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モジュールレベル変数mExceptionに例外オブジェクトを保持 | E-01 | ○ |
| C-02 | Throwプロシージャは引数ExがExceptionかErrObjectかを型判定する | E-04 | ○ |
| C-03 | Exception型の場合はmExceptionに直接格納 | E-02 (行58) | ○ |
| C-04 | ErrObject型の場合はCreateExceptionで新規Exception生成 | E-02 (行59-62), E-08 | ○ |
| C-05 | それ以外の型の場合はArgumentExceptionを生成 | E-02 (行64) | ○ |
| C-06 | 最終的にErr.Raiseで例外を発火 | E-05 | ○ |
| C-07 | ErrorNumber, Source, MessageがErr.Raiseに渡される | E-05 | ○ |
| C-08 | ThrowOrErrはmException有無で条件分岐 | E-03 | ○ |
| C-09 | 送信方式は同期 | E-05 (Err.Raiseは同期呼び出し) | ○ |
| C-10 | ExceptionBaseがすべての例外クラスで使用される | E-06, E-07 | ○ |
| C-11 | ArgumentException.ErrorNumberはvbInvalidProcedureCallを返す | E-09 | ○ |
| C-12 | ExがNothingかつmExceptionがNothingの場合は何も行わない | E-02 (行56, 68の条件) | ○ |
| C-13 | Catch関数で例外オブジェクトを取得可能 | E-01 (mException保持による) | ○ |
| C-14 | .NET Frameworkの例外処理モデルを模倣 | コメント・設計意図から推測 | ○ |
| C-15 | VBランタイムがエラーハンドラへ伝播 | VB6/VBAの標準動作 | ○ |
| C-16 | 本番環境では詳細エラー情報を露出しない設計推奨 | **根拠なし** | △ |
| C-17 | レート制限なし | **根拠なし**（制限実装がないことで推測） | △ |
| C-18 | リトライ回数0 | E-02 (リトライ実装なし) | ○ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項に関する明示的なコード・設計書が存在しない
  - 候補：セキュリティガイドライン / 設計方針書 / コメント
- レート制限に関する設計意図の確認が必要
  - 候補：非機能要件定義書 / アーキテクチャ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の実装は明確に確認可能
- 1: 中リスク - セキュリティ考慮事項は推奨事項であり、コードに明示的な実装がない

## 6) レビュアーチェックリスト（最小）
- [ ] Throwプロシージャの型判定ロジックが正確に記載されているか確認
- [ ] Err.Raiseに渡される引数が正しいか確認
- [ ] モジュールレベル変数mExceptionの役割が明確か確認
- [ ] セキュリティ考慮事項が妥当か確認（コードに明示的根拠なし）
