---
generated_at: 2026-01-20 17:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-ArgumentException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項のマスキング推奨**：コードに明示的な記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System/ArgumentException.cls` 行57-60 - インターフェース実装宣言
- E-03: `Source/CorLib/System/ArgumentException.cls` 行64 - mBase変数宣言
- E-04: `Source/CorLib/System/ArgumentException.cls` 行84-86 - ParamNameプロパティ
- E-05: `Source/CorLib/System/ArgumentException.cls` 行118-120 - HResultプロパティ (COR_E_ARGUMENT)
- E-06: `Source/CorLib/System/ArgumentException.cls` 行126-128 - ErrorNumberプロパティ (vbInvalidProcedureCall)
- E-07: `Source/CorLib/System/ArgumentException.cls` 行164-172 - Messageプロパティ
- E-08: `Source/CorLib/System/ArgumentException.cls` 行241-243 - Class_InitProperties
- E-09: `Source/CorLib/System/ArgumentException.cls` 行245-249 - Init関数
- E-10: `Source/CorLib/System/ArgumentException.cls` 行4-5 - Persistable設定
- E-11: `Source/CorLib/System/Constructors.cls` 行131-134 - NewArgumentException関数
- E-12: `Source/CorLib/System/ArgumentException.cls` 行38-48 - クラスコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArgumentExceptionはIObject, Exception, SystemExceptionを実装 | E-02 | ○ |
| C-02 | mBaseはExceptionBase型 | E-03 | ○ |
| C-03 | ParamNameはmBase.GetValueで取得 | E-04 | ○ |
| C-04 | HResultはCOR_E_ARGUMENT固定値 | E-05 | ○ |
| C-05 | ErrorNumberはvbInvalidProcedureCall固定値 | E-06 | ○ |
| C-06 | MessageはParamNameがある場合に付加される | E-07 | ○ |
| C-07 | Class_InitPropertiesでmBase初期化 | E-08 | ○ |
| C-08 | InitでMessage, ParamName, InnerException設定 | E-09 | ○ |
| C-09 | Persistable = Trueでシリアライズ対応 | E-10 | ○ |
| C-10 | NewArgumentExceptionでインスタンス生成とInit呼び出し | E-11 | ○ |
| C-11 | .NET FrameworkのSystem.ArgumentExceptionに相当 | E-12 (コメント) | ○ |
| C-12 | ArgumentNullException, ArgumentOutOfRangeExceptionは派生クラス | クラス構造から推測 | ○ |
| C-13 | CatchArgumentで型別捕捉可能 | ExceptionManagement.bas参照 | ○ |
| C-14 | VBエラー番号5がスローされる | E-06 | ○ |
| C-15 | PropParamName定数で"ParamName"キー管理 | E-04 (行61) | ○ |
| C-16 | GetExceptionMessageでデフォルトメッセージ取得 | E-07 (行165) | ○ |
| C-17 | 引数検証失敗時にスローされる | E-12 (コメント) | ○ |
| C-18 | ログ出力時の引数値マスキング推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ考慮事項のマスキング推奨は一般的なベストプラクティスであり、コードに明示的な実装がない
  - 候補：セキュリティガイドライン / 設計方針書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラス構造とプロパティ実装は明確に確認可能
- 0: 低リスク - コンストラクタとInit処理は標準的なパターン

## 6) レビュアーチェックリスト（最小）
- [ ] HResult値COR_E_ARGUMENTが正しいか確認
- [ ] ErrorNumber値vbInvalidProcedureCallが正しいか確認
- [ ] MessageプロパティのParamName付加ロジックが正確か確認
- [ ] InitメソッドのmBase設定が正しいか確認
