---
generated_at: 2026-01-20 17:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ArgumentNullException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentNullException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System/ArgumentNullException.cls` 行57-60 - インターフェース実装宣言
- E-03: `Source/CorLib/System/ArgumentNullException.cls` 行65 - mBase変数宣言
- E-04: `Source/CorLib/System/ArgumentNullException.cls` 行85-87 - ParamNameプロパティ
- E-05: `Source/CorLib/System/ArgumentNullException.cls` 行119-121 - HResultプロパティ (E_POINTER)
- E-06: `Source/CorLib/System/ArgumentNullException.cls` 行128-130 - ErrorNumberプロパティ (vbObjectNotSet)
- E-07: `Source/CorLib/System/ArgumentNullException.cls` 行166-174 - Messageプロパティ
- E-08: `Source/CorLib/System/ArgumentNullException.cls` 行243-245 - Class_InitProperties
- E-09: `Source/CorLib/System/ArgumentNullException.cls` 行247-251 - Init関数
- E-10: `Source/CorLib/System/Constructors.cls` 行161-164 - NewArgumentNullException関数
- E-11: `Source/CorLib/System/ArgumentNullException.cls` 行38-48 - クラスコメント
- E-12: `Source/CorLib/System/ExceptionManagement.bas` 行94-99 - CatchArgumentNull関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArgumentNullExceptionはArgumentExceptionインターフェースを実装 | E-02 | ○ |
| C-02 | mBaseはExceptionBase型 | E-03 | ○ |
| C-03 | ParamNameはmBase.GetValueで取得 | E-04 | ○ |
| C-04 | HResultはE_POINTER固定値 | E-05 | ○ |
| C-05 | ErrorNumberはvbObjectNotSet固定値 | E-06 | ○ |
| C-06 | MessageはParamNameがある場合に付加される | E-07 | ○ |
| C-07 | Class_InitPropertiesでmBase初期化 | E-08 | ○ |
| C-08 | InitでParamName, Message, InnerException設定 | E-09 | ○ |
| C-09 | NewArgumentNullExceptionでインスタンス生成とInit呼び出し | E-10 | ○ |
| C-10 | Null参照やuninitialized配列に対する例外 | E-11 (コメント) | ○ |
| C-11 | CatchArgumentNullで型別捕捉可能 | E-12 | ○ |
| C-12 | VBエラー番号91がスローされる | E-06 | ○ |
| C-13 | Initの引数順序はParamName, Message, InnerException | E-09, E-10 | ○ |
| C-14 | ArgumentExceptionとの違いはHResult/ErrorNumber | E-05, E-06 | ○ |
| C-15 | IObject, Exception, SystemExceptionも実装 | E-02 | ○ |
| C-16 | Persistable = Trueでシリアライズ対応 | E-01 (行4-5) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] HResult値E_POINTERが正しいか確認
- [ ] ErrorNumber値vbObjectNotSetが正しいか確認
- [ ] Initメソッドの引数順序が正しいか確認
- [ ] ArgumentExceptionとの継承関係が正確か確認
