---
generated_at: 2026-01-20 17:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ArgumentOutOfRangeException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行55-58 - インターフェース実装宣言
- E-03: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行60-64 - InvocationMethod列挙型
- E-04: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行70 - mBase変数宣言
- E-05: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行87-89 - ActualValueプロパティ
- E-06: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行99-101 - ParamNameプロパティ
- E-07: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行133-135 - HResultプロパティ
- E-08: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行142-144 - ErrorNumberプロパティ
- E-09: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行180-194 - Messageプロパティ
- E-10: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行263-266 - Class_InitProperties
- E-11: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行268-274 - Init関数
- E-12: `Source/CorLib/System/ArgumentOutOfRangeException.cls` 行276-287 - GetErrorNumber関数
- E-13: `Source/CorLib/System/Constructors.cls` 行176-179 - NewArgumentOutOfRangeException関数
- E-14: `Source/CorLib/System/ExceptionManagement.bas` 行101-106 - CatchArgumentOutOfRange関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArgumentOutOfRangeExceptionはArgumentExceptionインターフェースを実装 | E-02 | ○ |
| C-02 | InvocationMethod列挙型でGenericInvocation, ArrayInvocation, PropertyInvocationを定義 | E-03 | ○ |
| C-03 | ActualValueプロパティで実際の値を取得可能 | E-05 | ○ |
| C-04 | ParamNameはmBase.GetValueで取得 | E-06 | ○ |
| C-05 | HResultはCOR_E_ARGUMENTOUTOFRANGE固定値 | E-07 | ○ |
| C-06 | ErrorNumberはmBase.ErrorNumber（動的） | E-08 | ○ |
| C-07 | MessageはParamNameとActualValue両方が付加される | E-09 | ○ |
| C-08 | Class_InitPropertiesでmBase初期化とデフォルトエラー番号設定 | E-10 | ○ |
| C-09 | InitでParamName, Message, ActualValue, InnerException, Method設定 | E-11 | ○ |
| C-10 | GetErrorNumberでMethodに基づきエラー番号決定 | E-12 | ○ |
| C-11 | GenericInvocationでvbInvalidProcedureCall(5) | E-12 (行278-279) | ○ |
| C-12 | ArrayInvocationでvbSubscriptOutOfRange(9) | E-12 (行280-281) | ○ |
| C-13 | PropertyInvocationでvbInvalidPropertyValue(380) | E-12 (行282-283) | ○ |
| C-14 | NewArgumentOutOfRangeExceptionでインスタンス生成とInit呼び出し | E-13 | ○ |
| C-15 | CatchArgumentOutOfRangeで型別捕捉可能 | E-14 | ○ |
| C-16 | Persistable = Trueでシリアライズ対応 | E-01 (行4-5) | ○ |
| C-17 | 不正なMethodが渡された場合は例外をスロー | E-12 (行284-285) | ○ |
| C-18 | IObject, Exception, SystemExceptionも実装 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] InvocationMethod列挙型の値が正しいか確認
- [ ] GetErrorNumber関数のエラー番号マッピングが正確か確認
- [ ] Messageプロパティのフォーマットが正しいか確認
- [ ] ActualValueの型がVariantであることを確認
