---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-DirectoryNotFoundException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行42-45 - インターフェース実装宣言
- E-03: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行49 - mBase変数宣言
- E-04: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行93-95 - HResultプロパティ
- E-05: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行102-104 - ErrorNumberプロパティ
- E-06: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行140-142 - Messageプロパティ
- E-07: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行211-213 - Class_InitProperties
- E-08: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行215-218 - Init関数
- E-09: `Source/CorLib/System/Constructors.cls` 行661-664 - NewDirectoryNotFoundException関数
- E-10: `Source/CorLib/System/ExceptionManagement.bas` 行108-113 - CatchDirectoryNotFound関数
- E-11: `Source/CorLib/System.IO/DirectoryNotFoundException.cls` 行38-40 - クラスコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectoryNotFoundExceptionはIOExceptionインターフェースを実装 | E-02 | ○ |
| C-02 | HResultはCOR_E_DIRECTORYNOTFOUND固定値 | E-04 | ○ |
| C-03 | ErrorNumberはvbPathNotFound固定値 | E-05 | ○ |
| C-04 | MessageはGetExceptionMessageで取得 | E-06 | ○ |
| C-05 | Class_InitPropertiesでmBase初期化 | E-07 | ○ |
| C-06 | InitでMessage, InnerException設定 | E-08 | ○ |
| C-07 | NewDirectoryNotFoundExceptionでインスタンス生成とInit呼び出し | E-09 | ○ |
| C-08 | CatchDirectoryNotFoundで型別捕捉可能 | E-10 | ○ |
| C-09 | VBエラー番号76がスローされる | E-05 | ○ |
| C-10 | IObject, Exception, SystemExceptionも実装 | E-02 | ○ |
| C-11 | Persistable = Trueでシリアライズ対応 | E-01 (行4-5) | ○ |
| C-12 | ディレクトリ名専用プロパティがない | E-01 (全体構造) | ○ |
| C-13 | FileNotFoundExceptionとは別クラス | E-01, E-11 | ○ |
| C-14 | Arg_DirectoryNotFoundExceptionリソースキー使用 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] HResult値COR_E_DIRECTORYNOTFOUNDが正しいか確認
- [ ] ErrorNumber値vbPathNotFoundが正しいか確認
- [ ] InitメソッドのMessage/InnerException設定が正しいか確認
- [ ] IOExceptionとの継承関係が正確か確認
