---
generated_at: 2026-01-20 17:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-IOException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO/IOException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System.IO/IOException.cls` 行46-48 - インターフェース実装宣言
- E-03: `Source/CorLib/System.IO/IOException.cls` 行52 - mBase変数宣言
- E-04: `Source/CorLib/System.IO/IOException.cls` 行96-98 - HResultプロパティ（動的）
- E-05: `Source/CorLib/System.IO/IOException.cls` 行105-107 - ErrorNumberプロパティ（動的）
- E-06: `Source/CorLib/System.IO/IOException.cls` 行143-145 - Messageプロパティ
- E-07: `Source/CorLib/System.IO/IOException.cls` 行214-218 - Class_InitProperties
- E-08: `Source/CorLib/System.IO/IOException.cls` 行220-225 - Init関数
- E-09: `Source/CorLib/System/Constructors.cls` 行396-399 - NewIOException関数
- E-10: `Source/CorLib/System.IO/IOException.cls` 行38-44 - クラスコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IOExceptionはException, SystemExceptionインターフェースを実装 | E-02 | ○ |
| C-02 | HResultはmBase.HResult（動的） | E-04 | ○ |
| C-03 | ErrorNumberはmBase.ErrorNumber（動的） | E-05 | ○ |
| C-04 | MessageはGetExceptionMessageで取得 | E-06 | ○ |
| C-05 | Class_InitPropertiesでmBase初期化とデフォルト値設定 | E-07 | ○ |
| C-06 | デフォルトHResultはCOR_E_IO | E-07 (行216) | ○ |
| C-07 | デフォルトErrorNumberはvbDeviceIOError | E-07 (行217) | ○ |
| C-08 | InitでMessage, HResult, ErrorNumber, InnerException設定 | E-08 | ○ |
| C-09 | NewIOExceptionでHResult, ErrorCode引数あり | E-09 | ○ |
| C-10 | I/O関連例外の基底クラス | E-10 | ○ |
| C-11 | Persistable = Trueでシリアライズ対応 | E-01 (行4-5) | ○ |
| C-12 | IObject, Exception, SystemException実装 | E-02 | ○ |
| C-13 | FileNotFoundException, DirectoryNotFoundExceptionの基底 | クラス構造から確認 | ○ |
| C-14 | コンストラクタでHResult/ErrorCodeを指定可能 | E-09 | ○ |
| C-15 | Arg_IOExceptionリソースキー使用 | E-06 | ○ |
| C-16 | vbDeviceIOErrorは57 | VB6定数 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトHResult値COR_E_IOが正しいか確認
- [ ] デフォルトErrorNumber値vbDeviceIOErrorが正しいか確認
- [ ] Initメソッドの動的値設定が正しいか確認
- [ ] 派生クラスとの関係が正確か確認
