---
generated_at: 2026-01-20 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-SafeHandle.ReleaseHandle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 53行目 - Public Event ReleaseHandle()宣言
- E-02: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 48-51行目 - メンバ変数宣言
- E-03: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 88-94行目 - CloseHandle Sub
- E-04: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 89行目 - OwnsHandle AND NOT IsClosed条件
- E-05: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 90行目 - RaiseEvent ReleaseHandle
- E-06: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 91行目 - mHandle = INVALID_HANDLE
- E-07: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 92行目 - mIsClosed = True
- E-08: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 59-62行目 - DangerousGetHandle関数
- E-09: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 77-79行目 - IsInvalidプロパティ
- E-10: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 100-104行目 - Init Sub
- E-11: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 67-69行目 - IsClosedプロパティ
- E-12: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 39-45行目 - クラスコメント
- E-13: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 78行目 - INVALID_HANDLE定数使用
- E-14: `Source/CorLib/Microsoft.Win32.SafeHandles/SafeHandle.cls` 82-87行目 - CloseHandleコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SafeHandleはOSハンドルのラッパークラス | E-12 | ○ |
| C-02 | ReleaseHandleイベントはハンドル解放時に発火 | E-01, E-05 | ○ |
| C-03 | CloseHandleメソッド呼び出しでイベント発火 | E-03, E-05 | ○ |
| C-04 | OwnsHandle=True かつ IsClosed=False の場合のみ発火 | E-04 | ○ |
| C-05 | ReleaseHandleイベントは引数を持たない | E-01 | ○ |
| C-06 | DangerousGetHandleでハンドル値取得 | E-08 | ○ |
| C-07 | イベント発火後にmHandle=INVALID_HANDLEを設定 | E-06 | ○ |
| C-08 | イベント発火後にmIsClosed=Trueを設定 | E-07 | ○ |
| C-09 | IsInvalidは-1または0（ZeroIsInvalid時）で判定 | E-09 | ○ |
| C-10 | WithEventsで派生クラスがイベント受信 | E-12, E-14 | ○ |
| C-11 | InitメソッドでHandle,OwnsHandle,ZeroIsInvalidを設定 | E-10 | ○ |
| C-12 | mOwnsHandleメンバ変数で所有権管理 | E-02 (50行目) | ○ |
| C-13 | mIsClosedメンバ変数で解放済み状態管理 | E-02 (49行目), E-11 | ○ |
| C-14 | 二重解放防止のためIsClosed二重チェック | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のReleaseHandleイベント宣言が設計書と一致するか確認
- [ ] E-03のCloseHandleメソッドの条件分岐が正しく記述されているか確認
- [ ] E-09のIsInvalidプロパティのロジックが設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
