---
generated_at: 2026-01-20 17:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-OutOfMemoryException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/OutOfMemoryException.cls` 行9 - クラス名定義
- E-02: `Source/CorLib/System/OutOfMemoryException.cls` 行44-46 - インターフェース実装宣言
- E-03: `Source/CorLib/System/OutOfMemoryException.cls` 行50 - mBase変数宣言
- E-04: `Source/CorLib/System/OutOfMemoryException.cls` 行60-62 - Dataプロパティ（Nothing）
- E-05: `Source/CorLib/System/OutOfMemoryException.cls` 行94-96 - HResultプロパティ
- E-06: `Source/CorLib/System/OutOfMemoryException.cls` 行103-105 - ErrorNumberプロパティ
- E-07: `Source/CorLib/System/OutOfMemoryException.cls` 行141-143 - Messageプロパティ
- E-08: `Source/CorLib/System/OutOfMemoryException.cls` 行212-214 - Class_InitProperties
- E-09: `Source/CorLib/System/OutOfMemoryException.cls` 行216-219 - Init関数
- E-10: `Source/CorLib/System/OutOfMemoryException.cls` 行35-41 - クラスコメント
- E-11: `Source/CorLib/System/OutOfMemoryException.cls` 行14-31 - ライセンス（GNU LGPL）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OutOfMemoryExceptionはException, SystemExceptionインターフェースを実装 | E-02 | ○ |
| C-02 | DataプロパティはNothingを返す | E-04 | ○ |
| C-03 | HResultはCOR_E_OUTOFMEMORY固定値 | E-05 | ○ |
| C-04 | ErrorNumberはvbOutOfMemory固定値 | E-06 | ○ |
| C-05 | MessageはGetExceptionMessageで取得 | E-07 | ○ |
| C-06 | Class_InitPropertiesでmBase初期化 | E-08 | ○ |
| C-07 | InitでMessage, InnerException設定 | E-09 | ○ |
| C-08 | VBエラー番号7がスローされる | E-06 | ○ |
| C-09 | IObject, Exception, SystemException実装 | E-02 | ○ |
| C-10 | Persistable = Trueでシリアライズ対応 | E-01 (行4-5) | ○ |
| C-11 | GNU Library General Public License | E-11 | ○ |
| C-12 | メモリ不足時にスローされる | E-10 | ○ |
| C-13 | Arg_OutOfMemoryExceptionリソースキー使用 | E-07 | ○ |
| C-14 | コンストラクタ関数がConstructors.clsに定義されていない | Constructors.cls検索結果 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] HResult値COR_E_OUTOFMEMORYが正しいか確認
- [ ] ErrorNumber値vbOutOfMemoryが正しいか確認
- [ ] DataプロパティがNothingを返すことを確認
- [ ] ライセンス（GNU LGPL）が他のクラスと異なる点を確認
