---
generated_at: 2026-01-20 12:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：21-CryptographicException

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-31：39箇所以上でThrow文が記述されている**：概算値であり正確なカウントが必要
  2. **C-32：約15のソースファイルで使用**：概算値であり正確なカウントが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/CryptographicException.cls`（全361行）
- E-02: `Source/CorLib/System/Constructors.cls`（1161-1163行目：NewCryptographicException関数）
- E-03: `Source/CorLib/System/ErrorStatic.cls`（95-105行目：Cryptographicヘルパー関数）
- E-04: `Source/CorLib/System.Security.Cryptography/CryptoAPI.cls`（285-287行目：CryptoError関数）
- E-05: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls`（複数箇所でThrow）
- E-06: `Source/CorLib/System.Security.Cryptography/CryptoHelper.cls`（181行目、205行目：パディングエラー）
- E-07: `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls`（612-678行目付近）
- E-08: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls`（469行目、471行目）
- E-09: `Source/CorLib/System.Security.Cryptography/TripleDESCryptoServiceProvider.cls`（382行目）
- E-10: `Source/CorLib/System.Security.Cryptography/HMACBase.cls`（102行目）
- E-11: `Source/CorLib/System.Security.Cryptography/MACTripleDES.cls`（93行目）
- E-12: `Source/CorLib/System.Security.Cryptography/DSAParameters.cls`（447行目、483行目）
- E-13: `Source/CorLib/System.Security.Cryptography/RSAParameters.cls`（281行目、311行目、397行目）
- E-14: `Source/CorLib/System.Security.Cryptography/CspKeyContainerInfo.cls`（251行目）
- E-15: `Source/CorLib/System.Security.Cryptography/DESStatic.cls`（122行目、125行目）
- E-16: `Source/CorLib/System.Security.Cryptography/TripleDESStatic.cls`（85行目）
- E-17: `Source/CorLib/System.Security.Cryptography/RNGCryptoServiceProvider.cls`（61行目）
- E-18: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls`（268行目、319行目、368行目）
- E-19: `Source/CorLib/System.Security.Cryptography/CryptoAPIHash.cls`（79行目、88行目、97行目）
- E-20: `Source/CorLib/System.Security.Cryptography/DSACryptoServiceProvider.cls`（546行目）
- E-21: `docs/code-to-docs/通知一覧/通知一覧.csv`（No.21の定義）
- E-22: `docs/code-to-docs/機能設計書/110-CryptographicException.md`（機能設計書）
- E-23: Grepコマンド結果（NewCryptographicException使用箇所一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CryptographicExceptionは暗号化操作中のエラー時にスローされる例外 | E-01 (39行目コメント), E-22 | ○ |
| C-02 | IObject、Exception、SystemExceptionを実装している | E-01 (41-44行目) | ○ |
| C-03 | mBaseでExceptionBaseに処理を委譲している | E-01 (50行目) | ○ |
| C-04 | HResultはCORSEC_E_CRYPTOを返却する | E-01 (94-96行目) | ○ |
| C-05 | ErrorNumberはvbInvalidProcedureCall (5)を返却する | E-01 (103-105行目) | ○ |
| C-06 | NewCryptographicException関数がConstructors.clsの1161-1163行目に存在 | E-02 | ○ |
| C-07 | 関数はMessage（必須）とInnerException（任意）を受け取る | E-02 (1161行目) | ○ |
| C-08 | ErrorStatic.clsにCryptographicヘルパー関数が存在（95-105行目） | E-03 | ○ |
| C-09 | LastDllErrorの場合はGetMessageでメッセージを生成する | E-03 (98-99行目) | ○ |
| C-10 | CryptoAPI.clsにCryptoError関数が存在（285-287行目） | E-04 | ○ |
| C-11 | CryptoError関数はGetMessage(Err.LastDllError)でメッセージを生成 | E-04 (286行目) | ○ |
| C-12 | CryptoAPITransform.clsでOFBモード非対応エラーをスロー | E-05 (206-207行目) | ○ |
| C-13 | CryptoAPITransform.clsで暗号化失敗時に「Encryption failed」メッセージでスロー | E-05 (281行目) | ○ |
| C-14 | CryptoAPITransform.clsで復号化失敗時に「Could not decrypt data」メッセージでスロー | E-05 (349行目, 399行目) | ○ |
| C-15 | CryptoAPITransform.clsでデータ長エラー時にスロー | E-05 (259行目, 357行目) | ○ |
| C-16 | CryptoHelper.clsでパディングエラー時に「Invalid padding」でスロー | E-06 (181行目, 205行目) | ○ |
| C-17 | パディング長がInputBlockSizeを超過した場合にエラー | E-06 (180行目の条件文) | ○ |
| C-18 | RSACryptoServiceProvider.clsでキー取得失敗時にスロー | E-07 (612-613行目) | ○ |
| C-19 | RSACryptoServiceProvider.clsでアルゴリズム非対応時にスロー | E-07 (632行目) | ○ |
| C-20 | RSACryptoServiceProvider.clsでハッシュ長エラー時にスロー | E-07 (670行目) | ○ |
| C-21 | DESCryptoServiceProvider.clsで弱いキーエラーをスロー | E-08 (469行目) | ○ |
| C-22 | DESCryptoServiceProvider.clsでセミ弱いキーエラーをスロー | E-08 (471行目) | ○ |
| C-23 | TripleDESCryptoServiceProvider.clsで弱いキーエラーをスロー | E-09 (382行目) | ○ |
| C-24 | HMACBase.clsでハッシュ開始後のキー変更エラーをスロー | E-10 (102行目) | ○ |
| C-25 | MACTripleDES.clsでハッシュ開始後のキー変更エラーをスロー | E-11 (93行目) | ○ |
| C-26 | DSAParameters.clsで不正なXML形式エラーをスロー | E-12 (447行目, 483行目) | ○ |
| C-27 | RSAParameters.clsで不正なXML/Blob形式エラーをスロー | E-13 (281行目, 311行目, 397行目) | ○ |
| C-28 | DESStatic.clsでキー長エラーをスロー | E-15 (122行目, 125行目) | ○ |
| C-29 | RNGCryptoServiceProvider.clsで乱数生成エラーをスロー | E-17 (61行目) | ○ |
| C-30 | RijndaelManagedTransform.clsで暗号モードエラー・データ長エラーをスロー | E-18 (268行目, 319行目, 368行目) | ○ |
| C-31 | 39箇所以上でThrow文が記述されている | E-23 (Grep結果の行数) | △ |
| C-32 | 約15のソースファイルで使用されている | E-23 (Grep結果のファイル数) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-31、C-32の正確な数値**：Grepによる概算カウントであり、厳密なコード解析による正確な数値ではない
  - 候補：静的解析ツールによる正確なカウント / 全ファイルの手動確認 / コード解析スクリプトの作成

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 主張の大半がソースコードの直接参照により確認済み
- 設計書の記述はソースコードと整合しており、暗号関連の例外処理機構の説明として適切
- Windows CryptoAPIとの連携部分（Err.LastDllError使用）についても実装が確認されている
- 唯一のリスクは統計的な数値（使用箇所数）の概算であるが、機能理解には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] CryptographicException.clsのHResult定数CORSEC_E_CRYPTOの値が.NET Frameworkと互換性があるか確認
- [ ] ErrorNumber値のvbInvalidProcedureCall (5)が適切なエラーコードか確認
- [ ] セキュリティ考慮事項に記載されたエラーメッセージの機密性レベルが適切か確認
- [ ] コードリーディングガイドの行番号がソースコードの現在のバージョンと一致するか確認
- [ ] 例外スロー箇所が網羅されているか、追加の使用箇所がないか確認
