---
generated_at: 2026-01-20 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Ticker_Callback

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Threading/Ticker.cls` 88-89行目 - mDelegate, mCallbackメンバ変数
- E-02: `Source/CorLib/System.Threading/Ticker.cls` 271-283行目 - Init Sub
- E-03: `Source/CorLib/System.Threading/Ticker.cls` 276行目 - AddressOfCallback <> vbNullPtr チェック
- E-04: `Source/CorLib/System.Threading/Ticker.cls` 281行目 - InitDelegate呼び出し
- E-05: `Source/CorLib/System.Threading/Ticker.cls` 255-265行目 - OnElapsed Sub
- E-06: `Source/CorLib/System.Threading/Ticker.cls` 262-264行目 - mCallback.Invoke呼び出し
- E-07: `Source/CorLib/System.Threading/Ticker.cls` 289-292行目 - Class_Terminate
- E-08: `Source/CorLib/System.Threading/Ticker.cls` 291行目 - ObjectPtr(mCallback) = vbNullPtr
- E-09: `Source/CorLib/System/Delegation.bas` 99-104行目 - InitDelegate関数
- E-10: `Source/CorLib/System/Delegation.bas` 44-47行目 - Delegate構造体
- E-11: `Source/CorLib/System.Threading/Ticker.cls` 54-70行目 - クラスコメントにコールバック例
- E-12: `Source/CorLib/System.Threading/Ticker.cls` 260行目 - RaiseEvent Elapsed
- E-13: `Source/CorLib/System/Delegation.bas` 101行目 - Struct.pfn = pfn
- E-14: `Source/CorLib/System/Delegation.bas` 102行目 - Struct.pVTable設定
- E-15: `Source/CorLib/System.Threading/Ticker.cls` 277-282行目 - コメントでObjectPtr使用の説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddressOf演算子でコールバック関数指定 | E-02, E-11 | ○ |
| C-02 | mCallbackはAction_T_T型 | E-01 | ○ |
| C-03 | mDelegateはDelegate構造体 | E-01, E-10 | ○ |
| C-04 | AddressOfCallback <> vbNullPtrでチェック | E-03 | ○ |
| C-05 | InitDelegateでデリゲート初期化 | E-04, E-09 | ○ |
| C-06 | OnElapsed内でmCallback.Invoke呼び出し | E-06 | ○ |
| C-07 | Elapsedイベント発火後にコールバック実行 | E-05, E-12 | ○ |
| C-08 | コールバック引数はByRef Ticker, ByRef Data | E-06, E-11 | ○ |
| C-09 | Not mCallback Is Nothingでコールバック有無チェック | E-06 (262行目) | ○ |
| C-10 | Class_TerminateでObjectPtr解除 | E-07, E-08 | ○ |
| C-11 | クラッシュ防止のためObjectPtr使用 | E-15 | ○ |
| C-12 | Struct.pfnに関数ポインタ設定 | E-13 | ○ |
| C-13 | Struct.pVTableにVTable設定 | E-14 | ○ |
| C-14 | Elapsedイベントとコールバックは同時発火 | E-05, E-12, E-06 | ○ |
| C-15 | 標準モジュールからコールバック指定可能 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-02のInit Subでのコールバック設定処理が設計書と一致するか確認
- [ ] E-06のmCallback.Invoke呼び出しの引数が正しく記述されているか確認
- [ ] E-08のObjectPtr解除処理が設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
