---
generated_at: 2026-01-20 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-CallbackSorter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/CallbackSorter.cls` 48行目 - mComparerメンバ変数
- E-02: `Source/CorLib/System/CallbackSorter.cls` 85-87行目 - Init Sub
- E-03: `Source/CorLib/System/CallbackSorter.cls` 86行目 - NewDelegate呼び出し
- E-04: `Source/CorLib/System/CallbackSorter.cls` 65-79行目 - Sort Sub
- E-05: `Source/CorLib/System/CallbackSorter.cls` 71-77行目 - 要素サイズ分岐
- E-06: `Source/CorLib/System/CallbackSorter.cls` 216-241行目 - SortInt32 Sub
- E-07: `Source/CorLib/System/CallbackSorter.cls` 222行目 - mComparer.Invoke呼び出し
- E-08: `Source/CorLib/System/CallbackSorter.cls` 223行目 - mComparer.Invoke呼び出し
- E-09: `Source/CorLib/System/CallbackSorter.cls` 226-228行目 - 要素入れ替え処理
- E-10: `Source/CorLib/System/CallbackSorter.cls` 89-99行目 - Class_Terminate
- E-11: `Source/CorLib/System/CallbackSorter.cls` 38-45行目 - クラスコメント
- E-12: `Source/CorLib/System/CallbackSorter.cls` 49-51行目 - mHasSortItems, mSortItems, mKeyItems
- E-13: `Source/CorLib/System/CallbackSorter.cls` 53-57行目 - 各型配列メンバ
- E-14: `Source/CorLib/System/Delegation.bas` 72-85行目 - NewDelegate関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mComparerはFunc_T_T_Long型 | E-01 | ○ |
| C-02 | NewDelegateでデリゲート作成 | E-02, E-03, E-14 | ○ |
| C-03 | Sort Subで要素サイズに応じた分岐 | E-04, E-05 | ○ |
| C-04 | mComparer.Invokeで比較コールバック呼び出し | E-07, E-08 | ○ |
| C-05 | 比較結果に基づき要素入れ替え | E-09 | ○ |
| C-06 | QuickSortアルゴリズムを使用 | E-06 | ○ |
| C-07 | Class_Terminateでバッファ解放 | E-10 | ○ |
| C-08 | Keys配列とItems配列の同時ソート対応 | E-04, E-12 | ○ |
| C-09 | 要素サイズ1,2,4,8,16バイトで分岐 | E-05 | ○ |
| C-10 | mHasSortItemsでItems配列有無管理 | E-12 | ○ |
| C-11 | VBCorLib第2高速ソート方式 | E-11 | ○ |
| C-12 | カスタム比較による完全制御 | E-11 | ○ |
| C-13 | 各型配列への参照保持 | E-13 | ○ |
| C-14 | CoTaskMemFreeでメモリ解放 | E-10 (96-98行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-02のInit Subでのデリゲート作成が設計書と一致するか確認
- [ ] E-06のSortInt32での比較・入れ替え処理が設計書と一致するか確認
- [ ] E-10のClass_Terminateでのリソース解放が設計書と一致するか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
