---
generated_at: 2026-01-20 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Delegation.NewDelegate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Delegation.bas` 27行目 - DelegationCode定数
- E-02: `Source/CorLib/System/Delegation.bas` 28行目 - SizeOfLocalDelegate定数
- E-03: `Source/CorLib/System/Delegation.bas` 30-32行目 - LocalDelegateVTable型
- E-04: `Source/CorLib/System/Delegation.bas` 34-36行目 - DelegateVTable型
- E-05: `Source/CorLib/System/Delegation.bas` 38-42行目 - LocalDelegate型
- E-06: `Source/CorLib/System/Delegation.bas` 44-47行目 - Delegate型
- E-07: `Source/CorLib/System/Delegation.bas` 72-85行目 - NewDelegate関数
- E-08: `Source/CorLib/System/Delegation.bas` 76行目 - CoTaskMemAlloc呼び出し
- E-09: `Source/CorLib/System/Delegation.bas` 78-79行目 - OutOfMemoryチェック
- E-10: `Source/CorLib/System/Delegation.bas` 81-82行目 - pfn, pVTable設定
- E-11: `Source/CorLib/System/Delegation.bas` 84行目 - ObjectPtr返却
- E-12: `Source/CorLib/System/Delegation.bas` 146-178行目 - Init Sub
- E-13: `Source/CorLib/System/Delegation.bas` 149行目 - VirtualProtect呼び出し
- E-14: `Source/CorLib/System/Delegation.bas` 184-187行目 - LocalDelegate_QueryInterface
- E-15: `Source/CorLib/System/Delegation.bas` 189-192行目 - LocalDelegate_AddRef
- E-16: `Source/CorLib/System/Delegation.bas` 194-202行目 - LocalDelegate_Release

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NewDelegateは軽量COMオブジェクトを作成 | E-07 | ○ |
| C-02 | Matt Curlandのデリゲーションコード使用 | E-01 | ○ |
| C-03 | LocalDelegate構造体はpVTable,pfn,cRefsを持つ | E-05 | ○ |
| C-04 | CoTaskMemAllocでメモリ確保 | E-08 | ○ |
| C-05 | OutOfMemoryException時はThrow | E-09 | ○ |
| C-06 | pfnに関数ポインタを設定 | E-10 | ○ |
| C-07 | ObjectPtrでIUnknownとして返却 | E-11 | ○ |
| C-08 | InitでVTable初期化 | E-12 | ○ |
| C-09 | VirtualProtectでPAGE_EXECUTE_READWRITE設定 | E-13 | ○ |
| C-10 | LocalDelegate_QueryInterfaceでインターフェース取得 | E-14 | ○ |
| C-11 | LocalDelegate_AddRefで参照カウント増加 | E-15 | ○ |
| C-12 | LocalDelegate_Releaseで参照カウント減少・解放 | E-16 | ○ |
| C-13 | cRefs=0でCoTaskMemFree呼び出し | E-16 (197-198行目) | ○ |
| C-14 | SizeOfLocalDelegateは12バイト | E-02 | ○ |
| C-15 | LocalDelegateVTableはFunc(3)配列 | E-03 | ○ |
| C-16 | Delegate型はpVTableとpfnのみ | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-07のNewDelegate関数の処理フローが設計書と一致するか確認
- [ ] E-12のInit Subでの初期化処理が設計書と一致するか確認
- [ ] E-16のLocalDelegate_Releaseでのメモリ解放処理が正しいか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
