---
generated_at: 2026-01-20 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Delegation.InitDelegate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/Delegation.bas` 44-47行目 - Delegate型
- E-02: `Source/CorLib/System/Delegation.bas` 34-36行目 - DelegateVTable型
- E-03: `Source/CorLib/System/Delegation.bas` 99-104行目 - InitDelegate関数
- E-04: `Source/CorLib/System/Delegation.bas` 101行目 - Struct.pfn = pfn
- E-05: `Source/CorLib/System/Delegation.bas` 102行目 - Struct.pVTable = mOkVTablePtr
- E-06: `Source/CorLib/System/Delegation.bas` 103行目 - ObjectPtr返却
- E-07: `Source/CorLib/System/Delegation.bas` 204-207行目 - Delegate_OKQueryInterface
- E-08: `Source/CorLib/System/Delegation.bas` 209-212行目 - Delegate_FailQueryInterface
- E-09: `Source/CorLib/System/Delegation.bas` 214-216行目 - Delegate_AddRefRelease
- E-10: `Source/CorLib/System/Delegation.bas` 161-173行目 - DelegateVTable初期化
- E-11: `Source/CorLib/System/Delegation.bas` 171行目 - mOkVTablePtr設定
- E-12: `Source/CorLib/System/Delegation.bas` 172行目 - mFailVTablePtr設定
- E-13: `Source/CorLib/System.Threading/Ticker.cls` 281行目 - InitDelegate使用例
- E-14: `Source/CorLib/System.Threading/Ticker.cls` 291行目 - ObjectPtr解除例

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Delegate型はpVTableとpfnのみの構造体 | E-01 | ○ |
| C-02 | InitDelegateは既存構造体を初期化 | E-03 | ○ |
| C-03 | Struct.pfnに関数ポインタを設定 | E-04 | ○ |
| C-04 | Struct.pVTableにmOkVTablePtrを設定 | E-05 | ○ |
| C-05 | ObjectPtrでVarPtr(Struct)を返却 | E-06 | ○ |
| C-06 | Delegate_OKQueryInterfaceでpVTable切り替え | E-07 | ○ |
| C-07 | Delegate_FailQueryInterfaceでE_NOINTERFACE返却 | E-08 | ○ |
| C-08 | Delegate_AddRefReleaseは何もしない | E-09 | ○ |
| C-09 | DelegateVTableはFunc(7)配列でOK版とFail版 | E-02, E-10 | ○ |
| C-10 | mOkVTablePtrは.Func(0)のアドレス | E-11 | ○ |
| C-11 | mFailVTablePtrは.Func(4)のアドレス | E-12 | ○ |
| C-12 | Tickerクラスでの使用例 | E-13 | ○ |
| C-13 | ObjectPtrで参照解除（Releaseを呼ばない） | E-14 | ○ |
| C-14 | 動的メモリ確保なし | E-03 (CoTaskMemAlloc呼び出しなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-03のInitDelegate関数の処理フローが設計書と一致するか確認
- [ ] E-07, E-08のQueryInterface処理が設計書と一致するか確認
- [ ] E-09のAddRefRelease処理が何もしないことを確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
